/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.runtime.utils;

import java.util.Arrays;
import java.util.List;

public final class URLHelper {
    private static final List<String> containerExtensions = Arrays.asList(".jar", ".war", ".ear");
    private static final List<String> containerProtos = Arrays.asList("jar:", "file:");
    private static final String containerProtoPattern = "^[a-z]{3,}:.+";

    private URLHelper() {
    }

    public static String toNormalizedURL(String string) {
        if (string == null) {
            return null;
        }
        if (!string.contains("/") && !string.contains("\\")) {
            return string;
        }
        boolean bl = string.matches(containerProtoPattern);
        return (bl ? string : "file:/" + string).replace('\\', '/').replaceAll("/+", "/").replace(" ", "%20");
    }

    public static String toNormalizedJarURL(String string) {
        int n;
        if (!(string = URLHelper.toNormalizedURL(string)).startsWith("jar:")) {
            string = "jar:" + string;
        }
        if ((n = string.lastIndexOf(".jar")) > 0 && !string.endsWith(".jar!/")) {
            string = string.substring(0, n) + ".jar!/";
        }
        return string;
    }

    public static String extractContainerPathFromURL(String string) {
        int n;
        if (string == null) {
            return null;
        }
        int n2 = 0;
        int n3 = string.length();
        block0: while (true) {
            for (String string3 : containerProtos) {
                if (!string.regionMatches(n2, string3, 0, n = string3.length())) continue;
                n2 += n;
                continue block0;
            }
            break;
        }
        if (n2 == 0) {
            return string;
        }
        if (string.regionMatches(n3 - 2, "!/", 0, 2)) {
            n3 -= 2;
        }
        int n4 = n3;
        boolean bl = containerExtensions.stream().anyMatch(string2 -> {
            int n2 = string2.length();
            return string.regionMatches(n4 - n2, (String)string2, 0, n2);
        });
        if (!bl && (n = containerExtensions.stream().mapToInt(string2 -> {
            int n = string.lastIndexOf(string2 + "!/");
            return n > 0 ? n + string2.length() : n;
        }).max().orElse(-1)) > 0) {
            n3 = n;
        }
        return ("/" + string.substring(n2, n3)).replaceAll("/+", "/").replace("%20", " ");
    }
}

