/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.runtime.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Consumer;

public final class TempFilesFactory {
    private static final String tempJarFileNamePrefix = "jar_cache";
    private static final String tempJarFileNameSuffix = ".jar";
    private static Timer timer;
    private static boolean shutdownStarted;
    private static final Map<File, TempFileDeletionTimerTask> map;

    private TempFilesFactory() {
    }

    public static TempFile createTempJarFile(Consumer<TempFile> consumer) throws IOException {
        return new TempFile(Files.createTempFile(tempJarFileNamePrefix, tempJarFileNameSuffix, new FileAttribute[0]).toFile(), consumer);
    }

    public static synchronized void shutdown() {
        shutdownStarted = true;
        timer.cancel();
        map.forEach((file, tempFileDeletionTimerTask) -> {
            try {
                tempFileDeletionTimerTask.cancel();
                file.delete();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        map.clear();
        timer.purge();
    }

    private static synchronized Timer getTimer() {
        if (timer == null) {
            timer = new Timer("CRSTempFilesExpirationTimer", true);
        }
        return timer;
    }

    public static synchronized void scheduleDeletion(TempFile tempFile, long l) {
        if (shutdownStarted) {
            tempFile.delete();
            throw new IllegalStateException("Too late to schedule deletion: shutdown in progress");
        }
        TempFileDeletionTimerTask tempFileDeletionTimerTask = new TempFileDeletionTimerTask(tempFile);
        map.put(tempFile, tempFileDeletionTimerTask);
        TempFilesFactory.getTimer().schedule((TimerTask)tempFileDeletionTimerTask, l);
    }

    public static synchronized boolean deleteIfScheduled(File file) {
        TempFileDeletionTimerTask tempFileDeletionTimerTask = map.remove(file);
        if (tempFileDeletionTimerTask != null) {
            tempFileDeletionTimerTask.cancel();
            return tempFileDeletionTimerTask.file.delete();
        }
        return false;
    }

    static {
        shutdownStarted = false;
        map = new HashMap<File, TempFileDeletionTimerTask>();
    }

    private static final class TempFileDeletionTimerTask
    extends TimerTask {
        public final TempFile file;

        public TempFileDeletionTimerTask(TempFile tempFile) {
            this.file = tempFile;
        }

        @Override
        public void run() {
            TempFilesFactory.deleteIfScheduled(this.file);
        }
    }

    public static class TempFile
    extends File {
        final Consumer<TempFile> onDeleteAction;

        private TempFile(File file, Consumer<TempFile> consumer) {
            super(file.toURI());
            this.onDeleteAction = consumer;
        }

        @Override
        public boolean equals(Object object) {
            return super.equals(object);
        }

        @Override
        public boolean delete() {
            if (super.delete()) {
                if (this.onDeleteAction != null) {
                    this.onDeleteAction.accept(this);
                }
                return true;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }
}

