/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.jar;

import com.azul.crs.client.JDKAccessor;
import com.azul.crs.client.Tweaks;
import com.azul.crs.client.Utils;
import com.azul.crs.util.logging.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public final class ZipTools {
    private static final Logger logger = Logger.getLogger(ZipTools.class);
    private static JDKAccessor jdkAccessor;
    private final boolean forceToUseGenericProvider;
    public final boolean allowAdvancedJarLoadDetection;
    private final CentralDirectoryProviderFactory jdkCentralDirectoryFactory;
    private final CentralDirectoryProviderFactory genericCentralDirectoryFactory;
    private final MultiMap<String, CentralDirectoryProviderFactory> cdTools;

    public ZipTools(boolean bl, boolean bl2, String string) {
        this.forceToUseGenericProvider = bl;
        this.allowAdvancedJarLoadDetection = bl2;
        this.jdkCentralDirectoryFactory = this.getJdkCentralDirectoryFactory();
        this.genericCentralDirectoryFactory = this.getGenericCentralDirectoryFactory(string);
        this.cdTools = new MultiMap();
        this.cdTools.put(JarFile.class.getName(), this.jdkCentralDirectoryFactory);
        this.cdTools.put("sun.net.www.protocol.jar.URLJarFile", this.jdkCentralDirectoryFactory);
        this.cdTools.put("jdk.internal.util.jar.PersistentJarFile", this.jdkCentralDirectoryFactory);
        this.cdTools.put("org.springframework.boot.loader.jar.JarFile", new Spring1xCentralDirectoryFactory());
        this.cdTools.put("org.springframework.boot.loader.jar.JarFile", new Spring2xCentralDirectoryFactory());
        this.cdTools.put("org.springframework.boot.loader.jar.JarFileWrapper", new Spring26xCentralDirectoryFactory());
    }

    public static ZipTools createDefault() {
        return new ZipTools(Boolean.getBoolean("com.azul.crs.jarload.forceToUseGenericProvider"), Boolean.getBoolean("com.azul.crs.jarload.allowAdvancedJarLoadDetection"), System.getProperty("com.azul.crs.jarload.genericCentralDirectoryProvider"));
    }

    public static void setJdkAccessor(JDKAccessor jDKAccessor) {
        jdkAccessor = jDKAccessor;
    }

    private CentralDirectoryProviderFactory getJdkCentralDirectoryFactory() {
        if (jdkAccessor != null && jdkAccessor.supportsGetZipCentralDirectory()) {
            return new JDKCentralDirectoryFactory();
        }
        return new GenericCentralDirectoryFactory();
    }

    private CentralDirectoryProviderFactory getGenericCentralDirectoryFactory(String string) {
        if (string != null) {
            switch (string) {
                case "generic": {
                    return new GenericCentralDirectoryFactory();
                }
                case "jdk": {
                    return this.getJdkCentralDirectoryFactory();
                }
                case "spring.1.x": {
                    return new Spring1xCentralDirectoryFactory();
                }
                case "spring.2.x": {
                    return new Spring2xCentralDirectoryFactory();
                }
            }
        }
        return new GenericCentralDirectoryFactory();
    }

    private CentralDirectoryProviderFactory findCentralDirectoryProviderFactoryForClass(Class clazz) {
        Class clazz2 = clazz;
        while (!clazz2.equals(Object.class)) {
            CentralDirectoryProviderFactory centralDirectoryProviderFactory = this.cdTools.get(clazz2.getName());
            if (centralDirectoryProviderFactory != null) {
                return centralDirectoryProviderFactory;
            }
            clazz2 = clazz2.getSuperclass();
        }
        return this.genericCentralDirectoryFactory;
    }

    public byte[] getManifestHash(MessageDigest messageDigest, URL uRL, JarFile jarFile) throws IOException {
        int n;
        if (jarFile == null) {
            return null;
        }
        ZipEntry zipEntry = jarFile.getEntry("META-INF/MANIFEST.MF");
        if (zipEntry == null) {
            logger.trace("ZipTools.getDigest got JarFile=%s [%s] without manifest file", jarFile, uRL);
            return null;
        }
        InputStream inputStream = jarFile.getInputStream(zipEntry);
        char[] cArray = new char[Tweaks.DEFAULT_BUFFER_SIZE];
        StringBuilder stringBuilder = new StringBuilder();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        while ((n = ((Reader)inputStreamReader).read(cArray, 0, cArray.length)) != -1) {
            stringBuilder.append(cArray, 0, n);
        }
        messageDigest.reset();
        return messageDigest.digest(stringBuilder.toString().getBytes());
    }

    public static boolean isJDKNative(JarFile jarFile) {
        return jarFile != null && ZipTools.isKnownJarFileImplementation(jarFile.getClass());
    }

    private static boolean isKnownJarFileImplementation(Class<? extends JarFile> clazz) {
        return clazz.equals(JarFile.class) || clazz.getName().equals("jdk.internal.util.jar.PersistentJarFile") || clazz.getName().equals("sun.net.www.protocol.jar.URLJarFile");
    }

    public static boolean isJarFile(String string) {
        return string != null && (string.endsWith(".jar") || string.endsWith(".war"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JarShortDigest getDigest(MessageDigest messageDigest, URL uRL, JarFile jarFile, Supplier<InputStream> supplier) throws IOException {
        CentralDirectoryProviderFactory centralDirectoryProviderFactory = null;
        try {
            if (uRL == null && jarFile == null && supplier != null) {
                return this.getDigest(this.genericCentralDirectoryFactory, messageDigest, null, null, supplier);
            }
            if (!this.allowAdvancedJarLoadDetection) {
                if (ZipTools.isJDKNative(jarFile)) {
                    centralDirectoryProviderFactory = this.jdkCentralDirectoryFactory;
                    return this.getDigest(centralDirectoryProviderFactory, messageDigest, uRL, jarFile, supplier);
                }
                logger.debug("Unsupported jarFile type %s skip notification for %s", jarFile.getClass().getName(), uRL.toString());
                return null;
            }
            Class<?> clazz = jarFile.getClass();
            centralDirectoryProviderFactory = this.forceToUseGenericProvider ? this.genericCentralDirectoryFactory : this.findCentralDirectoryProviderFactoryForClass(clazz);
            this.cdTools.put(clazz.getName(), centralDirectoryProviderFactory);
            return this.getDigest(centralDirectoryProviderFactory, messageDigest, uRL, jarFile, supplier);
        }
        catch (Exception exception) {
            Exception exception2 = ZipFileClosedException.isZipFileClosedException(exception) ? new ZipFileClosedException(exception) : exception;
            if (exception2 == null) return null;
            if (exception2 instanceof IOException) {
                throw (IOException)exception2;
            }
            logger.debug("central directory sha256 calculation ended with exception (%s). url=%s, file=%s, zip-cd provider=%s", exception2, uRL, jarFile, centralDirectoryProviderFactory == null ? "null" : centralDirectoryProviderFactory.getClass().getName());
            if (centralDirectoryProviderFactory == null) return null;
            if (ZipTools.isJDKNative(jarFile)) return null;
            logger.trace("Removing cached providerFactory for class %s", jarFile.getClass().getName());
            this.cdTools.remove(jarFile.getClass().getName(), centralDirectoryProviderFactory);
            return null;
        }
    }

    private JarShortDigest getDigest(CentralDirectoryProviderFactory centralDirectoryProviderFactory, MessageDigest messageDigest, URL uRL, JarFile jarFile, Supplier<InputStream> supplier) throws Exception {
        logger.trace("zip tools calculating sha256 of central directory: digest=%s, url=%s, file=%s, file.class=%s, ze=%s", messageDigest.toString().trim(), uRL, jarFile, jarFile != null ? jarFile.getClass().getName() : null, centralDirectoryProviderFactory.getClass().getName());
        DataProvider dataProvider = centralDirectoryProviderFactory.getCentralDirectoryProvider(uRL, jarFile, supplier);
        if (dataProvider == null) {
            logger.trace("Failed to craete DataProvider for %s", uRL);
            return null;
        }
        messageDigest.reset();
        AtomicLong atomicLong = new AtomicLong(0L);
        dataProvider.deliver((byArray, n, n2) -> {
            messageDigest.update(byArray, n, n2);
            atomicLong.getAndAdd(n2);
            if (Tweaks.DEBUG_ZIPTOOLS && Tweaks.TRACE_CD_CONTENT) {
                System.out.printf(">>> += encodeToStringOrNull(%d, %d, %d);\n", byArray.length, n, n2);
                System.out.printf(">>> += %s\n", Utils.encodeToStringOrNull(byArray, n, n2));
            }
        });
        byte[] byArray2 = messageDigest.digest();
        byte[] byArray3 = this.getManifestHash(messageDigest, uRL, jarFile);
        return new JarShortDigest(byArray2, byArray3, centralDirectoryProviderFactory.getClass().getName(), atomicLong.get());
    }

    public static final class ZipFileClosedException
    extends IOException {
        public ZipFileClosedException(Throwable throwable) {
            super(throwable);
        }

        public static boolean isZipFileClosedException(Throwable throwable) {
            while (throwable != null) {
                if (throwable instanceof IllegalStateException && "zip file closed".equals(throwable.getMessage())) {
                    return true;
                }
                if (throwable instanceof ZipException && "ZipFile closed".equals(throwable.getMessage())) {
                    return true;
                }
                throwable = throwable.getCause();
            }
            return false;
        }
    }

    public static final class JarShortDigest {
        public byte[] centralDirectoryHash;
        public byte[] manifestHash;
        public String provider;
        public long centralDirectoryLength;

        private JarShortDigest(byte[] byArray, byte[] byArray2, String string, long l) {
            this.centralDirectoryHash = byArray;
            this.manifestHash = byArray2;
            this.provider = string;
            this.centralDirectoryLength = l;
        }

        public byte[] getCentralDirectoryHash() {
            return this.centralDirectoryHash;
        }

        public byte[] getManifestHash() {
            return this.manifestHash;
        }

        public String getProvider() {
            return this.provider;
        }

        public long getCentralDirectoryLength() {
            return this.centralDirectoryLength;
        }

        public String toString() {
            return "JarShortDigest[hash=" + Utils.encodeToStringOrNull(this.centralDirectoryHash) + ", length=" + this.centralDirectoryLength + ", provider=" + this.provider + ", manifestHash=" + this.manifestHash + "]";
        }
    }

    public static class Spring1xCentralDirectoryFactory
    implements CentralDirectoryProviderFactory {
        private boolean initialized = false;
        Class jarFile;
        Field data;
        Class randomAccessData;
        Class resourceAccess;
        Object resourceAccessOnce;
        Method getInputStream;
        Class centralDirectoryEndRecord;
        Field centralDirectoryEndRecordBlock;
        Field centralDirectoryEndRecordBlockOffset;
        Field centralDirectoryEndRecordBlockLength;
        Method getCentralDirectory;
        Constructor<Object> newCentralDirectoryEndRecord;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void lazyInit(ClassLoader classLoader) {
            if (this.initialized) {
                return;
            }
            try {
                if (classLoader == null) {
                    classLoader = this.getClass().getClassLoader();
                }
                this.jarFile = Class.forName("org.springframework.boot.loader.jar.JarFile", true, classLoader);
                this.data = this.jarFile.getDeclaredField("data");
                this.data.setAccessible(true);
                this.randomAccessData = this.data.getType();
                this.resourceAccess = Class.forName("org.springframework.boot.loader.data.RandomAccessData$ResourceAccess", true, classLoader);
                for (Object t : this.resourceAccess.getEnumConstants()) {
                    if (!"ONCE".equals(t.toString())) continue;
                    this.resourceAccessOnce = t;
                }
                this.getInputStream = this.randomAccessData.getDeclaredMethod("getInputStream", this.resourceAccess);
                this.getInputStream.setAccessible(true);
                this.centralDirectoryEndRecord = Class.forName("org.springframework.boot.loader.jar.CentralDirectoryEndRecord", true, classLoader);
                this.centralDirectoryEndRecordBlock = this.centralDirectoryEndRecord.getDeclaredField("block");
                this.centralDirectoryEndRecordBlock.setAccessible(true);
                Class<?> clazz = this.centralDirectoryEndRecordBlock.getType();
                if (!clazz.equals(byte[].class)) {
                    throw new RuntimeException("CentralDirectoryEndRecord.block is not of byte[] type, as expected ==" + clazz.getName());
                }
                this.centralDirectoryEndRecordBlockOffset = this.centralDirectoryEndRecord.getDeclaredField("offset");
                this.centralDirectoryEndRecordBlockOffset.setAccessible(true);
                if (!Integer.TYPE.equals(this.centralDirectoryEndRecordBlockOffset.getType())) {
                    throw new RuntimeException("CentralDirectoryEndRecord.offset is not of int type, as expected ==" + this.centralDirectoryEndRecordBlockOffset.getType());
                }
                this.centralDirectoryEndRecordBlockLength = this.centralDirectoryEndRecord.getDeclaredField("size");
                this.centralDirectoryEndRecordBlockLength.setAccessible(true);
                if (!Integer.TYPE.equals(this.centralDirectoryEndRecordBlockLength.getType())) {
                    throw new RuntimeException("CentralDirectoryEndRecord.size is not of int type, as expected ==" + this.centralDirectoryEndRecordBlockLength.getType());
                }
                this.getCentralDirectory = this.centralDirectoryEndRecord.getDeclaredMethod("getCentralDirectory", this.randomAccessData);
                this.getCentralDirectory.setAccessible(true);
                this.newCentralDirectoryEndRecord = this.centralDirectoryEndRecord.getDeclaredConstructor(this.randomAccessData);
                this.newCentralDirectoryEndRecord.setAccessible(true);
            }
            catch (ClassNotFoundException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException exception) {
                logger.warning("%s initialization failed: %s", this.getClass().getSimpleName(), exception);
                this.jarFile = null;
                this.data = null;
                this.randomAccessData = null;
                this.resourceAccess = null;
                this.resourceAccessOnce = null;
                this.getInputStream = null;
                this.centralDirectoryEndRecord = null;
                this.centralDirectoryEndRecordBlock = null;
                this.centralDirectoryEndRecordBlockOffset = null;
                this.centralDirectoryEndRecordBlockLength = null;
                this.getCentralDirectory = null;
                this.newCentralDirectoryEndRecord = null;
            }
            finally {
                this.initialized = true;
            }
        }

        private void check(ZipFile zipFile) throws IllegalArgumentException {
            if (!zipFile.getClass().equals(this.jarFile)) {
                throw new IllegalArgumentException("Wrong extractor chosen");
            }
        }

        @Override
        public DataProvider getCentralDirectoryProvider(URL uRL, ZipFile zipFile, Supplier<InputStream> supplier) {
            this.lazyInit(zipFile.getClass().getClassLoader());
            assert (supplier == null);
            if (this.jarFile == null) {
                return null;
            }
            this.check(zipFile);
            return dataConsumer -> {
                Object object = this.data.get(zipFile);
                Object object2 = this.newCentralDirectoryEndRecord.newInstance(object);
                Object object3 = this.getCentralDirectory.invoke(object2, object);
                byte[] byArray = (byte[])this.centralDirectoryEndRecordBlock.get(object2);
                int n = (Integer)this.centralDirectoryEndRecordBlockOffset.get(object2);
                int n2 = (Integer)this.centralDirectoryEndRecordBlockLength.get(object2);
                try (InputStream inputStream = (InputStream)this.getInputStream.invoke(object3, this.resourceAccessOnce);){
                    int n3;
                    byte[] byArray2 = new byte[Tweaks.DEFAULT_BUFFER_SIZE];
                    while ((n3 = inputStream.read(byArray2)) > 0) {
                        dataConsumer.consume(byArray2, 0, n3);
                    }
                    dataConsumer.consume(byArray, n, n2);
                }
            };
        }
    }

    public static class Spring26xCentralDirectoryFactory
    implements CentralDirectoryProviderFactory {
        private boolean initialized = false;
        private Field parent;
        private Class jarFileWrapper;
        private Class jarFile;
        private Spring2xCentralDirectoryFactory delegate;

        private synchronized void lazyInit(ClassLoader classLoader) {
            if (this.initialized) {
                return;
            }
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            try {
                this.jarFile = Class.forName("org.springframework.boot.loader.jar.JarFile", true, classLoader);
                this.jarFileWrapper = Class.forName("org.springframework.boot.loader.jar.JarFileWrapper", true, classLoader);
                this.parent = this.jarFileWrapper.getDeclaredField("parent");
                this.delegate = new Spring2xCentralDirectoryFactory();
                this.parent.setAccessible(true);
                if (!this.jarFile.equals(this.parent.getType())) {
                    throw new IllegalArgumentException(String.format("Field 'parent' expecting to have type %s, but has %s", this.jarFile.getName(), this.parent.getType()));
                }
            }
            catch (ClassNotFoundException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
                logger.warning("%s initialization failed: %s", this.getClass().getSimpleName(), exception);
                this.parent = null;
                this.jarFileWrapper = null;
                this.jarFile = null;
                this.delegate = null;
            }
            finally {
                this.initialized = true;
            }
        }

        private void check(ZipFile zipFile) throws IllegalArgumentException {
            if (!zipFile.getClass().equals(this.jarFileWrapper)) {
                throw new IllegalArgumentException("Wrong extractor chosen");
            }
        }

        @Override
        public DataProvider getCentralDirectoryProvider(URL uRL, ZipFile zipFile, Supplier<InputStream> supplier) {
            this.lazyInit(zipFile.getClass().getClassLoader());
            assert (supplier == null);
            if (this.jarFile == null) {
                return null;
            }
            this.check(zipFile);
            try {
                Object object = this.parent.get(zipFile);
                return this.delegate.getCentralDirectoryProvider(uRL, (ZipFile)object, supplier);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                logger.warning(this.getClass().getSimpleName() + " initialization failed", exception);
                return null;
            }
        }
    }

    public static class Spring2xCentralDirectoryFactory
    implements CentralDirectoryProviderFactory {
        private boolean initialized = false;
        Class jarFile;
        Field data;
        Class randomAccessData;
        Method read;
        Method getSize;
        Class centralDirectoryEndRecord;
        Field centralDirectoryEndRecordBlock;
        Field centralDirectoryEndRecordBlockOffset;
        Field centralDirectoryEndRecordBlockLength;
        Method getCentralDirectory;
        Constructor<Object> newCentralDirectoryEndRecord;

        private synchronized void lazyInit(ClassLoader classLoader) {
            if (this.initialized) {
                return;
            }
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            try {
                this.jarFile = Class.forName("org.springframework.boot.loader.jar.JarFile", true, classLoader);
                this.data = this.jarFile.getDeclaredField("data");
                this.data.setAccessible(true);
                this.randomAccessData = this.data.getType();
                this.read = this.randomAccessData.getDeclaredMethod("read", new Class[0]);
                this.read.setAccessible(true);
                this.getSize = this.randomAccessData.getDeclaredMethod("getSize", null);
                this.getSize.setAccessible(true);
                this.centralDirectoryEndRecord = Class.forName("org.springframework.boot.loader.jar.CentralDirectoryEndRecord", true, classLoader);
                this.centralDirectoryEndRecordBlock = this.centralDirectoryEndRecord.getDeclaredField("block");
                this.centralDirectoryEndRecordBlock.setAccessible(true);
                Class<?> clazz = this.centralDirectoryEndRecordBlock.getType();
                if (!clazz.equals(byte[].class)) {
                    throw new RuntimeException("CentralDirectoryEndRecord.block is not of byte[] type, as expected ==" + clazz.getName());
                }
                this.centralDirectoryEndRecordBlockOffset = this.centralDirectoryEndRecord.getDeclaredField("offset");
                this.centralDirectoryEndRecordBlockOffset.setAccessible(true);
                if (!Integer.TYPE.equals(this.centralDirectoryEndRecordBlockOffset.getType())) {
                    throw new RuntimeException("CentralDirectoryEndRecord.offset is not of int type, as expected ==" + this.centralDirectoryEndRecordBlockOffset.getType());
                }
                this.centralDirectoryEndRecordBlockLength = this.centralDirectoryEndRecord.getDeclaredField("size");
                this.centralDirectoryEndRecordBlockLength.setAccessible(true);
                if (!Integer.TYPE.equals(this.centralDirectoryEndRecordBlockLength.getType())) {
                    throw new RuntimeException("CentralDirectoryEndRecord.size is not of int type, as expected ==" + this.centralDirectoryEndRecordBlockLength.getType());
                }
                this.getCentralDirectory = this.centralDirectoryEndRecord.getDeclaredMethod("getCentralDirectory", this.randomAccessData);
                this.getCentralDirectory.setAccessible(true);
                this.newCentralDirectoryEndRecord = this.centralDirectoryEndRecord.getDeclaredConstructor(this.randomAccessData);
                this.newCentralDirectoryEndRecord.setAccessible(true);
            }
            catch (ClassNotFoundException | NoSuchFieldException | NoSuchMethodException | SecurityException exception) {
                logger.warning("%s initialization failed: %s", this.getClass().getSimpleName(), exception);
                this.jarFile = null;
                this.data = null;
                this.randomAccessData = null;
                this.read = null;
                this.getSize = null;
                this.centralDirectoryEndRecord = null;
                this.centralDirectoryEndRecordBlock = null;
                this.centralDirectoryEndRecordBlockOffset = null;
                this.centralDirectoryEndRecordBlockLength = null;
                this.getCentralDirectory = null;
                this.newCentralDirectoryEndRecord = null;
            }
            finally {
                this.initialized = true;
            }
        }

        private void check(ZipFile zipFile) throws IllegalArgumentException {
            if (!zipFile.getClass().equals(this.jarFile)) {
                throw new IllegalArgumentException("Wrong extractor chosen");
            }
        }

        @Override
        public DataProvider getCentralDirectoryProvider(URL uRL, ZipFile zipFile, Supplier<InputStream> supplier) {
            this.lazyInit(zipFile.getClass().getClassLoader());
            assert (supplier == null);
            if (this.jarFile == null) {
                return null;
            }
            this.check(zipFile);
            return dataConsumer -> {
                Object object = this.data.get(zipFile);
                Object object2 = this.newCentralDirectoryEndRecord.newInstance(object);
                Object object3 = this.getCentralDirectory.invoke(object2, object);
                byte[] byArray = (byte[])this.read.invoke(object3, new Object[0]);
                byte[] byArray2 = (byte[])this.centralDirectoryEndRecordBlock.get(object2);
                int n = (Integer)this.centralDirectoryEndRecordBlockOffset.get(object2);
                int n2 = (Integer)this.centralDirectoryEndRecordBlockLength.get(object2);
                dataConsumer.consume(byArray);
                dataConsumer.consume(byArray2, n, n2);
            };
        }
    }

    public static class GenericCentralDirectoryFactory
    implements CentralDirectoryProviderFactory {
        @Override
        public DataProvider getCentralDirectoryProvider(URL uRL, ZipFile zipFile, Supplier<InputStream> supplier) {
            return dataConsumer -> {
                try (InputStream inputStream = supplier != null ? (InputStream)supplier.get() : uRL.openConnection().getInputStream();){
                    long l;
                    ZipInputStreamCentralDirectoryParser zipInputStreamCentralDirectoryParser = new ZipInputStreamCentralDirectoryParser(inputStream);
                    zipInputStreamCentralDirectoryParser.deliver(dataConsumer);
                    if (Tweaks.DEBUG_ZIPTOOLS && zipFile != null && zipInputStreamCentralDirectoryParser.endtot != (l = (long)Collections.list(zipFile.entries()).size())) {
                        throw new RuntimeException(String.format("ERROR: file=%s:%s contains %dl entries, but we calculated the number as %dl.", zipFile, zipFile.getClass().getName(), l, zipInputStreamCentralDirectoryParser.endtot));
                    }
                }
            };
        }

        private static class ZipInputStreamCentralDirectoryParser
        implements DataProvider {
            private final RandomAccessBuffer buffer;
            public long endpos;
            public long endtot;
            public long endsiz;
            public long endoff;
            public long endcom;
            public long cenpos;
            public long locpos;
            static final int ENDTOT = 10;
            static final int ENDSIZ = 12;
            static final int ENDOFF = 16;
            static final int ENDCOM = 20;
            static final long LOCSIG = 67324752L;
            static final long CENSIG = 33639248L;
            static final long ENDSIG = 101010256L;
            static final int ENDHDR = 22;
            static final long ZIP64_MAGICVAL = 0xFFFFFFFFL;
            static final int ZIP64_LOCHDR = 20;
            static final long ZIP64_LOCSIG = 117853008L;
            static final int ZIP64_LOCOFF = 8;
            static final long ZIP64_ENDSIG = 101075792L;
            static final int ZIP64_ENDOFF = 48;
            static final int ZIP64_ENDTOT = 32;
            static final int ZIP64_MAGICCOUNT = 65535;
            static final int ZIP64_ENDSIZ = 40;

            ZipInputStreamCentralDirectoryParser(InputStream inputStream) {
                this.buffer = new RandomAccessBuffer(inputStream);
            }

            private void readCentralDirectory(DataConsumer dataConsumer) throws IOException {
                long l = -1L;
                this.buffer.readNextPage();
                int n = 0;
                while (!this.buffer.meetEOF() && (long)n >= this.buffer.getStart() && (long)(n + 4) < this.buffer.getEnd()) {
                    if (this.buffer.get32(n) == 67324752L) {
                        l = n;
                    }
                    ++n;
                }
                this.buffer.readUntilEOF();
                for (long i = this.buffer.getEnd() - 22L; i > this.buffer.getStart(); --i) {
                    long l2;
                    if (this.buffer.get32(i) != 101010256L) continue;
                    long l3 = i;
                    long l4 = this.buffer.get16(l3 + 10L);
                    long l5 = this.buffer.get32(l3 + 12L);
                    long l6 = this.buffer.get32(l3 + 16L);
                    long l7 = this.buffer.get16(l3 + 20L);
                    long l8 = l3 - l5;
                    long l9 = l8 - l6;
                    if (l3 + 22L + l7 != this.buffer.getEnd() && (l8 < 0L || l9 < 0L || l != -1L && l9 != l || this.buffer.get32(l8) != 33639248L)) continue;
                    if (l3 >= 20L && this.buffer.get32(l3 - 20L) == 117853008L && this.buffer.get32(l2 = this.buffer.get64(l3 - 20L + 8L)) == 101075792L) {
                        long l10 = this.buffer.get64(l2 + 40L);
                        long l11 = this.buffer.get64(l2 + 48L);
                        long l12 = this.buffer.get64(l2 + 32L);
                        if (!(l10 != l5 && l5 != 0xFFFFFFFFL || l11 != l6 && l6 != 0xFFFFFFFFL || l12 != l4 && l4 != 65535L)) {
                            l5 = l10;
                            l6 = l11;
                            l4 = l12;
                            l3 = l2;
                            l8 = l3 - l5;
                            l9 = l8 - l6;
                        }
                    }
                    if (Tweaks.DEBUG_ZIPTOOLS) {
                        this.endpos = l3;
                        this.endtot = l4;
                        this.endsiz = l5;
                        this.endoff = l6;
                        this.endcom = l7;
                        this.cenpos = l8;
                        this.locpos = l9;
                    }
                    this.buffer.deliver(dataConsumer, l8, l3 + 22L - l8);
                    return;
                }
            }

            @Override
            public void deliver(DataConsumer dataConsumer) throws IOException {
                this.readCentralDirectory(dataConsumer);
            }

            private static class RandomAccessBuffer {
                private final int maxChunks = Tweaks.genericCentralDirectoryMaxChunks;
                private final Queue<Chunk> queue;
                private final Chunk[] chunks;
                private final InputStream stream;
                private boolean eof;
                private long dataStartOffset;
                private long dataEndOffset;

                private void renumerate() {
                    int n = 0;
                    for (Chunk chunk : this.queue) {
                        this.chunks[n++] = chunk;
                    }
                }

                private Chunk getFreeChunk() {
                    if (this.queue.size() < this.maxChunks) {
                        Chunk chunk = new Chunk();
                        this.queue.add(chunk);
                        return chunk;
                    }
                    Chunk chunk = this.queue.remove();
                    if (chunk.buf.length != chunk.filled) {
                        throw new RuntimeException("!");
                    }
                    this.dataStartOffset += (long)chunk.filled;
                    chunk.clear();
                    this.queue.add(chunk);
                    this.renumerate();
                    return chunk;
                }

                public RandomAccessBuffer(InputStream inputStream) {
                    this.stream = inputStream;
                    this.eof = false;
                    this.dataEndOffset = 0L;
                    this.dataStartOffset = 0L;
                    this.queue = new LinkedList<Chunk>();
                    this.chunks = new Chunk[this.maxChunks];
                }

                public void deliver(DataConsumer dataConsumer, long l, long l2) throws IOException {
                    if (l < this.dataStartOffset || l + l2 > this.dataEndOffset) {
                        throw new RuntimeException(String.format("off=%dl, len=%dl are out of range [%dl, %dl]", l, l2, this.dataStartOffset, this.dataEndOffset));
                    }
                    int n = this.getChunkNumber(l);
                    int n2 = this.getOffsetInsideChunk(l);
                    int n3 = this.getChunkNumber(l + l2);
                    int n4 = this.getOffsetInsideChunk(l + l2);
                    if (n == n3) {
                        if (n4 < n2) {
                            throw new RuntimeException(String.format("lastOffset=%dl < firstOffset=%dl", n4, n2));
                        }
                        dataConsumer.consume(this.chunks[n].buf, n2, n4 - n2);
                    } else {
                        dataConsumer.consume(this.chunks[n].buf, n2, Tweaks.DEFAULT_BUFFER_SIZE - n2);
                        for (int i = n + 1; i < n3; ++i) {
                            dataConsumer.consume(this.chunks[i].buf, 0, Tweaks.DEFAULT_BUFFER_SIZE);
                        }
                        dataConsumer.consume(this.chunks[n3].buf, 0, n4);
                    }
                }

                public boolean meetEOF() {
                    return !this.eof;
                }

                public long getStart() {
                    return this.dataStartOffset;
                }

                public long getEnd() {
                    return this.dataEndOffset;
                }

                public boolean readNextPage() throws IOException {
                    if (this.eof) {
                        return false;
                    }
                    Chunk chunk = this.getFreeChunk();
                    long l = -1L;
                    while (chunk.buf.length - chunk.filled > 0 && (l = (long)this.stream.read(chunk.buf, chunk.filled, chunk.buf.length - chunk.filled)) != -1L) {
                        chunk.filled = (int)((long)chunk.filled + l);
                        this.dataEndOffset += l;
                    }
                    this.renumerate();
                    if (l == -1L) {
                        this.eof = true;
                    }
                    return !this.eof;
                }

                public void readUntilEOF() throws IOException {
                    while (this.readNextPage()) {
                    }
                }

                private int getChunkNumber(long l) {
                    if (l > this.dataEndOffset || l < this.dataStartOffset) {
                        throw new RuntimeException(String.format("i is not in range: i=%dl range=[%dl, %dl]", l, this.dataStartOffset, this.dataEndOffset));
                    }
                    return (int)((l - this.dataStartOffset) / (long)Tweaks.DEFAULT_BUFFER_SIZE);
                }

                private int getOffsetInsideChunk(long l) {
                    if (l > this.dataEndOffset || l < this.dataStartOffset) {
                        throw new RuntimeException(String.format("i is not in range: i=%dl range=[%dl, %dl]", l, this.dataStartOffset, this.dataEndOffset));
                    }
                    return (int)(l % (long)Tweaks.DEFAULT_BUFFER_SIZE);
                }

                public byte get8(long l) {
                    if (l < this.dataStartOffset || l >= this.dataEndOffset) {
                        throw new RuntimeException(String.format("RandomAccessBuffer out of index access off=%dl, expecting range: [%dl, %dl]", l, this.dataStartOffset, this.dataEndOffset));
                    }
                    return this.chunks[this.getChunkNumber((long)l)].buf[this.getOffsetInsideChunk(l)];
                }

                public int get16(long l) {
                    return this.get8(l) & 0xFF | (this.get8(l + 1L) & 0xFF) << 8;
                }

                public long get32(long l) {
                    return ((long)this.get16(l) | (long)this.get16(l + 2L) << 16) & 0xFFFFFFFFL;
                }

                public long get64(long l) {
                    return this.get32(l) | this.get32(l + 4L) << 32;
                }

                private static class Chunk {
                    public byte[] buf = new byte[Tweaks.DEFAULT_BUFFER_SIZE];
                    public int filled = 0;

                    Chunk() {
                    }

                    public void clear() {
                        this.filled = 0;
                    }
                }
            }
        }
    }

    public static class JDKCentralDirectoryFactory
    implements CentralDirectoryProviderFactory {
        @Override
        public DataProvider getCentralDirectoryProvider(URL uRL, ZipFile zipFile, Supplier<InputStream> supplier) {
            assert (supplier == null);
            return dataConsumer -> dataConsumer.consume(jdkAccessor.getZipFileCentralDirectory(zipFile));
        }
    }

    public static interface CentralDirectoryProviderFactory {
        public DataProvider getCentralDirectoryProvider(URL var1, ZipFile var2, Supplier<InputStream> var3);
    }

    public static interface DataProvider {
        public void deliver(DataConsumer var1) throws Exception;
    }

    public static interface DataConsumer {
        public void consume(byte[] var1, int var2, int var3) throws IOException;

        default public void consume(byte[] byArray) throws IOException {
            this.consume(byArray, 0, byArray.length);
        }
    }

    private class MultiMap<K, V> {
        Map<K, List<V>> map = new HashMap<K, List<V>>();

        private MultiMap() {
        }

        synchronized void put(K k, V v) {
            List list = this.map.computeIfAbsent(k, object -> new ArrayList());
            if (!list.contains(v)) {
                list.add(v);
            }
        }

        synchronized V get(K k) {
            List<V> list = this.map.get(k);
            return list == null || list.isEmpty() ? null : (V)list.get(0);
        }

        synchronized void remove(K k, V v) {
            List<V> list = this.map.get(k);
            if (list != null) {
                list.remove(v);
            }
        }
    }
}

