/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.util;

import com.azul.crs.client.FileUtils;
import com.azul.crs.util.logging.Logger;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class TraceFileWriter {
    private PrintWriter traceOut;
    private final String traceOutputFile;

    public TraceFileWriter(String string, Logger logger) {
        this.traceOutputFile = this.createWriter(string, logger);
    }

    public String getTraceOutputFile() {
        return this.traceOutputFile;
    }

    public void close() {
        if (this.traceOut != null) {
            this.traceOut.close();
        }
    }

    public void printf(String string, Object ... objectArray) {
        if (this.traceOut != null) {
            this.traceOut.printf(string, objectArray);
        }
    }

    public void println(String string) {
        if (this.traceOut != null) {
            this.traceOut.println(string);
        }
    }

    private String createWriter(String string, Logger logger) {
        this.traceOut = null;
        if (logger.isEnabled(Logger.Level.TRACE)) {
            Path path;
            try {
                path = FileUtils.createTempFile(string, ".log");
            }
            catch (IOException iOException) {
                logger.warning(iOException.getMessage(), new Object[0]);
                return null;
            }
            try {
                this.traceOut = new PrintWriter(Files.newBufferedWriter(path, new OpenOption[0]));
                return path.toString();
            }
            catch (IOException iOException) {
                logger.error("Cannot trace events into file: %s", iOException);
            }
        }
        return null;
    }
}

