/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.sysinfo;

import com.azul.crs.client.sysinfo.SystemInfoProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

final class MacOSXSystemInfoProvider
extends SystemInfoProvider.SystemInfoProviderImpl {
    MacOSXSystemInfoProvider() {
    }

    @Override
    protected void initProps() throws IOException, InterruptedException {
        ProcessBuilder processBuilder = new ProcessBuilder("sysctl", "-a");
        Process process = processBuilder.start();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                int n = string.indexOf(58);
                if (n < 0) continue;
                String string2 = string.substring(0, n).trim();
                String string3 = string.substring(n + 1).trim();
                this.machdepProps.set("sysctl." + string2, string3);
            }
        }
        this.cpuProps.set(SystemInfoProvider.CPUInfoKey.PROCESSOR_COUNT, this.machdepProps.intValue("sysctl.hw.ncpu"));
        this.cpuProps.set(SystemInfoProvider.CPUInfoKey.VENDOR, this.machdepProps.strValue("sysctl.machdep.cpu.vendor"));
        this.cpuProps.set(SystemInfoProvider.CPUInfoKey.MODEL_NAME, this.machdepProps.strValue("sysctl.machdep.cpu.brand_string"));
        this.cpuProps.set(SystemInfoProvider.CPUInfoKey.PHYSICAL_CORE_COUNT, this.machdepProps.intValue("sysctl.hw.physicalcpu"));
        process.waitFor();
    }
}

