/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.service;

import com.azul.crs.client.Client;
import com.azul.crs.client.Inventory;
import com.azul.crs.client.PerformanceMetrics;
import com.azul.crs.client.Tweaks;
import com.azul.crs.client.Utils;
import com.azul.crs.client.jars.JarFileFactory;
import com.azul.crs.client.jars.NestedJarsDependencies;
import com.azul.crs.client.models.VMArtifact;
import com.azul.crs.client.models.VMEvent;
import com.azul.crs.client.service.ClientService;
import com.azul.crs.client.service.ServerRequestsService;
import com.azul.crs.client.service.VmJarInfoRequestSupport;
import com.azul.crs.client.util.LRUCache;
import com.azul.crs.client.util.TraceFileWriter;
import com.azul.crs.digest.Digest;
import com.azul.crs.digest.ShadedClassHashCalculator;
import com.azul.crs.jar.ZipTools;
import com.azul.crs.runtime.utils.DataEntriesMap;
import com.azul.crs.runtime.utils.KnownAzulRuntimeContainers;
import com.azul.crs.runtime.utils.TempFilesFactory;
import com.azul.crs.runtime.utils.URLHelper;
import com.azul.crs.util.logging.Logger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;

public final class JarLoadMonitor
implements ClientService {
    private static final JarLoadMonitor instance = new JarLoadMonitor();
    private Client client;
    private AtomicBoolean started = new AtomicBoolean();
    private volatile Utils.Deadline deadline;
    private final TraceFileWriter traceOut;
    private final MessageDigest md;
    private ZipTools zt;
    private TaskExecutor taskExecutor;
    private static final Set<String> knownVmJars = JarLoadMonitor.initKnownVmJars();
    private static final Object activeTasksLock = new Object();
    private static final Set<NotificationTask> activeTasks = new HashSet<NotificationTask>();
    private boolean sendPOMProperties = true;
    private long maxJarFileCacheSize;
    private AtomicLong jarFileCacheLimit = new AtomicLong();
    private static AtomicLong unconfirmedJarsNumber = new AtomicLong();
    private static final int VM_JAR_LOADED_EVENT_INLINE_PAYLOAD_THRESHOLD = 524288;

    public void setSendPOMProperties(boolean bl) {
        this.sendPOMProperties = bl;
    }

    public void setMaxJarFileCacheSize(long l) {
        this.maxJarFileCacheSize = l;
        this.jarFileCacheLimit.getAndSet(l);
    }

    private JarLoadMonitor() {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.logger().error("Failed to initialize SHA-256 MessageDigest: %s", noSuchAlgorithmException);
            this.stop(Utils.Deadline.in(0L, TimeUnit.MILLISECONDS));
        }
        this.md = messageDigest;
        this.zt = ZipTools.createDefault();
        this.traceOut = new TraceFileWriter("CRSJarLoadMonitor", this.logger());
        this.logger().trace("writing JarLoadMonitor trace to file %s", this.traceOut.getTraceOutputFile());
        this.taskExecutor = new TaskExecutor(Tweaks.jarLoadMonitorTaskQueueSize);
    }

    public static JarLoadMonitor getInstance(Client client) {
        JarLoadMonitor.instance.client = client;
        return instance;
    }

    private VMEvent jarLoadEvent(String string, InitiatedBy initiatedBy, int n, String string2, long l, String string3, String string4, String string5, Long l2, List<String> list, Set<MavenComponent> set, Map<String, Long> map, String string6, Long l3) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("url", string);
        hashMap.put("jarName", string2);
        hashMap.put("centralDirectoryHash", string3);
        hashMap.put("manifestHash", string4);
        hashMap.put("centralDirectoryExtractionMethod", string5);
        hashMap.put("centralDirectoryLength", l2 != null ? Long.toString(l2) : null);
        hashMap.put("entries", list);
        hashMap.put("initiatedBy", (Object)initiatedBy);
        hashMap.put("recursionDepth", n);
        hashMap.put("mavenComponents", set);
        hashMap.put("stats", map);
        hashMap.put("parentCentralDirectoryHash", string6);
        hashMap.put("parentCentralDirectoryLength", l3 != null ? Long.toString(l3) : null);
        return new VMEvent().eventType(VMEvent.Type.VM_JAR_LOADED).eventTime(l).eventPayload(hashMap);
    }

    @Override
    public synchronized void start() {
        if (!this.started.compareAndSet(false, true)) {
            this.logger().error("JarLoadMonitor has been started already", new Object[0]);
            return;
        }
        if (this.hardstop()) {
            return;
        }
        this.taskExecutor.start();
        ServerRequestsService.addListener(VmJarInfoRequestSupport.VmJarInfoRequest.class, vmJarInfoRequest -> this.processVmJarInfoRequest((VmJarInfoRequestSupport.VmJarInfoRequest)vmJarInfoRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processVmJarInfoRequest(VmJarInfoRequestSupport.VmJarInfoRequest vmJarInfoRequest) {
        File file;
        this.logger().trace("processVmJarInfoRequest request=%s", vmJarInfoRequest);
        if (this.hardstop()) {
            return;
        }
        File file2 = file = vmJarInfoRequest.getPath() != null ? new File(vmJarInfoRequest.getPath()) : null;
        if (vmJarInfoRequest.getDetailsLevel() == VmJarInfoRequestSupport.VmJarInfoRequest.DetailsLevel.NONE) {
            if (TempFilesFactory.deleteIfScheduled(file)) {
                this.logger().debug("Removed temporary file %s after server acknowlegement", vmJarInfoRequest.getPath());
            }
            if (!Tweaks.forceFullJarLoadedEvents) {
                PerformanceMetrics.logJarLoadEventConfirmed();
                unconfirmedJarsNumber.getAndDecrement();
            }
            if (!Tweaks.nonBlockingJarDiscovery) {
                this.taskExecutor.release(this.taskIdWithDetails(vmJarInfoRequest.getCDHash()));
            }
            return;
        }
        if (file == null) {
            this.logger().debug("VmJarInfoRequest can not be processed - incoming path is empty.", new Object[0]);
            return;
        }
        if (!file.exists()) {
            this.logger().debug("VmJarInfoRequest can not be processed - incoming path=%s doesn't exist anymore.", vmJarInfoRequest.getPath());
            return;
        }
        NotificationTask notificationTask = new NotificationTask(vmJarInfoRequest.getPath());
        boolean bl = false;
        try {
            this.addActiveTask(notificationTask);
            String string = vmJarInfoRequest.getPath();
            URL uRL = null;
            JarFile jarFile = null;
            try {
                uRL = Paths.get(string, new String[0]).toUri().toURL();
                jarFile = new JarFile(string, false);
                bl = this.postVMJarLoadedEvent(null, uRL, jarFile, file, null, null, vmJarInfoRequest.getUrl(), InitiatedBy.SERVER_REQUEST, 0, true);
            }
            catch (Exception exception) {
                this.logger().error("Failed to process VmJarInfoRequest: request=%s, path=%s, url=%s, jar=%s, Exception %s", vmJarInfoRequest, string, uRL, jarFile, exception);
                this.taskExecutor.terminateWithParents(this.taskIdWithDetails(vmJarInfoRequest.getCDHash()), JarLoadProcessingError.EXCEPTION, exception.toString() + " while processVmJarInfoRequest for jar with path=" + string);
            }
        }
        finally {
            notificationTask.setCompletionStatus(bl);
            this.removeActiveTask(notificationTask);
        }
    }

    @Override
    public synchronized void stop(Utils.Deadline deadline) {
        this.deadline = deadline;
        try {
            while (!(this.hardstop() || ServerRequestsService.getRequestsCount() <= 0 && VMEvent.Type.VM_JAR_LOADED.getInFlightEventsCounter() <= 0)) {
                ServerRequestsService.waitAllRequestsProcessed(deadline);
                VMEvent.Type.VM_JAR_LOADED.waitAllEventsProcessed(deadline);
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.interrupted();
        }
        this.taskExecutor.stop(deadline);
        this.waitActiveTasks(deadline);
        if (this.traceOut != null) {
            this.traceOut.close();
        }
    }

    private boolean hardstop() {
        return this.deadline != null && this.deadline.hasExpired();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addActiveTask(NotificationTask notificationTask) {
        Object object = activeTasksLock;
        synchronized (object) {
            activeTasks.add(notificationTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeActiveTask(NotificationTask notificationTask) {
        Object object = activeTasksLock;
        synchronized (object) {
            activeTasks.remove(notificationTask);
            activeTasksLock.notify();
        }
        if (!notificationTask.isCompletedSuccessfully()) {
            this.logger().warning("There were issues processing %s", notificationTask.description);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int activeTasksNumber() {
        Object object = activeTasksLock;
        synchronized (object) {
            return activeTasks.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitActiveTasks(Utils.Deadline deadline) {
        Object object = activeTasksLock;
        synchronized (object) {
            while (!this.hardstop() && !activeTasks.isEmpty()) {
                try {
                    this.logger().debug("Waiting for " + activeTasks + " in progress VM_JAR_LOADED events", new Object[0]);
                    activeTasksLock.wait(Math.max(1L, deadline.remainder(TimeUnit.MILLISECONDS)));
                }
                catch (InterruptedException interruptedException) {
                    Thread.interrupted();
                    break;
                }
            }
            if (!activeTasks.isEmpty()) {
                this.logger().debug("UNSENT DATA AFTER TERMINATION: VM_JAR_LOADED_EVENTs  %s still not processed. You may want to increase delayTermination.", activeTasks);
            }
        }
    }

    private static URL getJarURL(URL uRL) {
        if (uRL == null) {
            return null;
        }
        String string = uRL.toString();
        if (string.contains("!/") && !(string = string.substring(0, string.lastIndexOf("!/"))).contains("!/") && string.startsWith("jar:")) {
            string = string.substring(4);
        }
        if (!(string.endsWith(".jar!/") || string.endsWith(".war!/") || string.endsWith(".jar") || string.endsWith(".war"))) {
            Logger.getLogger(JarLoadMonitor.class).debug("given url=" + uRL + " does not have jar to be reported for load event. source=" + string, new Object[0]);
            return null;
        }
        if (string.equals(uRL.toString())) {
            return uRL;
        }
        try {
            return new URL(string);
        }
        catch (Exception exception) {
            Logger.getLogger(JarLoadMonitor.class).warning("Failed to construct jar url from url=%s, modified source string=%s", uRL, string, exception);
            return uRL;
        }
    }

    private ZipTools.JarShortDigest getJarCentralDirectorySignature(URL uRL, JarFile jarFile, Supplier<InputStream> supplier) throws IOException {
        try {
            URL uRL2 = JarLoadMonitor.getJarURL(uRL);
            if (null == uRL2 && supplier == null) {
                return null;
            }
            ZipTools.JarShortDigest jarShortDigest = this.zt.getDigest((MessageDigest)this.md.clone(), uRL2, jarFile, supplier);
            this.logger().trace("jar central directory signature calculated jar=%s, url=%s, digest=%s", jarFile, uRL, jarShortDigest);
            if (jarShortDigest == null) {
                return null;
            }
            if (Tweaks.DEBUG_JARLOAD && Tweaks.TRACE_CD_CONTENT) {
                System.out.println(">>> notifyJarLoad url=" + uRL + "\njar=" + jarFile + "\ncentralDirectoryHashString=" + Utils.encodeToStringOrNull(jarShortDigest.getCentralDirectoryHash()) + "\nmanifestHashString=" + Utils.encodeToStringOrNull(jarShortDigest.getManifestHash()));
            }
            if (this.traceOut != null) {
                this.traceOut.println(Objects.toString(uRL));
            }
            return jarShortDigest;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            this.logger().error("Exception during calculation of central directory", cloneNotSupportedException);
            return null;
        }
    }

    private void visitJarEntries(JarFile jarFile, List<Consumer<JarEntry>> list) {
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (!this.hardstop() && enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            if (jarEntry.isDirectory()) continue;
            list.forEach(consumer -> consumer.accept(jarEntry));
        }
    }

    private boolean hasSpaceInJarCache(long l) {
        return this.jarFileCacheLimit.get() >= l;
    }

    private void acquireSpaceInJarCache(long l) {
        this.jarFileCacheLimit.addAndGet(-l);
    }

    private void releaseSpaceInJarCache(long l) {
        this.jarFileCacheLimit.addAndGet(l);
    }

    private boolean notifyNestedJars(URL uRL, JarFile jarFile2, String string, ZipTools.JarShortDigest jarShortDigest, Supplier<InputStream> supplier, int n, JarIdentifierVisitor jarIdentifierVisitor) throws IOException {
        this.logger().trace("notifyNestedJars parentUrl=%s, parentJar=%s, parentMetaUrl=%s, parentHash=%s, depth=%d, stack=%s", uRL, jarFile2, string, jarShortDigest == null ? "null" : Utils.encodeToStringOrNull(jarShortDigest.getCentralDirectoryHash()), n, Tweaks.DEBUG_JARLOAD ? new RuntimeException("here") : null);
        if (jarFile2 == null) {
            throw new NestedJarsAreNotAccessibleException(String.format("NestedJarsAreNotAccessibleException: parentUrl=%s, parentJar=%s, parentMetaUrl=%s, parentHash=%s, depth=%d", uRL, jarFile2, string, jarShortDigest == null ? "null" : Utils.encodeToStringOrNull(jarShortDigest.getCentralDirectoryHash()), n));
        }
        try {
            JarLoadMonitor.doWithJarReopen(jarFile2, uRL, jarFile -> {
                for (JarEntry jarEntry : Collections.list(jarFile.entries())) {
                    if (!ZipTools.isJarFile(jarEntry.getName())) continue;
                    try {
                        Object object;
                        Object object2;
                        long l = jarEntry.getSize();
                        String string2 = string + jarEntry.getName() + "!/";
                        String string3 = string + "!/" + jarEntry.getName();
                        JarEntry jarEntry2 = jarEntry;
                        if (l > this.maxJarFileCacheSize) {
                            this.logger().warning("jar=" + jarFile + "(url=" + uRL + ") contains nested entry (jar file) which size (" + l + " bytes) is bigger than allowed consumption of temp fs (" + this.maxJarFileCacheSize + " bytes)", new Object[0]);
                            object2 = null;
                            object = jarFile.getInputStream(jarEntry2);
                            Supplier<InputStream> supplier = () -> JarLoadMonitor.lambda$null$2((InputStream)object);
                            object2 = this.getJarCentralDirectorySignature(null, null, supplier);
                            if (jarIdentifierVisitor != null) {
                                jarIdentifierVisitor.visit(null, null, null, (ZipTools.JarShortDigest)object2, string3, jarEntry.getName());
                            }
                            if (ProcessedJarFiles.isAlreadyProcessed(string3, null, (ZipTools.JarShortDigest)object2)) continue;
                            if (!Tweaks.nonBlockingJarDiscovery) {
                                this.taskExecutor.addDependency(this.taskIdWithDetails((ZipTools.JarShortDigest)object2), this.taskIdWithDetails(jarShortDigest));
                            }
                            this.taskExecutor.terminateWithParents(this.taskIdWithDetails((ZipTools.JarShortDigest)object2), JarLoadProcessingError.TEMPFS_LIMIT, jarEntry.getName() + ": notifyJarLoad there is no tempfs space for preparing withDetails event");
                            this.notifyJarLoad(uRL, (JarFile)jarFile, string, jarShortDigest, null, null, null, null, (ZipTools.JarShortDigest)object2, InitiatedBy.RECURSIVE_LOADING, string2, n);
                            continue;
                        }
                        object2 = this.taskIdWithDetails(jarShortDigest);
                        object = string3;
                        this.taskExecutor.schedule(true, null, (String)object2, () -> this.hasSpaceInJarCache(l), (arg_0, arg_1) -> this.lambda$null$6(l, (String)object2, jarEntry2, jarFile, uRL, jarEntry, jarIdentifierVisitor, string3, jarShortDigest, string, string2, n, arg_0, arg_1));
                    }
                    catch (Exception exception) {
                        this.logger().error("failed to dump nested jar entry %s/%s: %s", jarFile.getName(), jarEntry.getName(), exception);
                        if (!Tweaks.nonBlockingJarDiscovery) {
                            this.taskExecutor.terminateWithParents(this.taskIdWithDetails(jarShortDigest), JarLoadProcessingError.NESTED_JAR, jarEntry.getName() + ": " + exception);
                        }
                        throw exception;
                    }
                }
            });
        }
        catch (Exception exception) {
            this.logger().debug("notifyNestedJars parentUrl={} failed with e={}", uRL, exception);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean notifyJarLoad(URL uRL, JarFile jarFile, String string, ZipTools.JarShortDigest jarShortDigest, URL uRL2, JarFile jarFile3, File file, Supplier<InputStream> supplier, ZipTools.JarShortDigest jarShortDigest2, InitiatedBy initiatedBy, String string2, int n) {
        String string3;
        this.logger().trace("notifyJarLoad %s initiated by %s", new Object[]{uRL2, initiatedBy});
        if (this.hardstop()) {
            this.logger().debug("Skip processing notifyJarLoad because of hardstop", new Object[0]);
            return false;
        }
        if (!this.started.get()) {
            this.logger().error("service is not yet started", new Object[0]);
            return false;
        }
        String string4 = string3 = uRL2 != null ? uRL2.toString() : string2;
        if (supplier == null && jarShortDigest2 == null && (uRL2 == null || jarFile3 == null)) {
            this.logger().debug("Skip processing invalid notifyJarLoad", new Object[0]);
            return false;
        }
        String string5 = URLHelper.toNormalizedJarURL(string2);
        NotificationTask notificationTask = new NotificationTask(string3);
        this.addActiveTask(notificationTask);
        try {
            JarLoadMonitor.doWithJarReopen(jarFile3, uRL2, jarFile2 -> {
                ZipTools.JarShortDigest jarShortDigest3 = jarShortDigest2 == null ? this.getJarCentralDirectorySignature(uRL2, (JarFile)jarFile2, supplier) : jarShortDigest2;
                this.notifyJarLoadImpl(uRL, jarFile, string, jarShortDigest, uRL2, (JarFile)jarFile2, file, supplier, jarShortDigest3, initiatedBy, string5, n);
            });
            notificationTask.setCompletionStatus(true);
        }
        catch (Exception exception) {
            this.logger().warning("Exception while processing notifyJarLoad (%s)", uRL2, exception);
            this.taskExecutor.terminateWithParents(this.taskIdWithDetails(jarShortDigest2), JarLoadProcessingError.EXCEPTION, exception.toString());
        }
        finally {
            this.removeActiveTask(notificationTask);
        }
        return notificationTask.isCompletedSuccessfully();
    }

    private boolean notifyJarLoadImpl(URL uRL, JarFile jarFile, String string, ZipTools.JarShortDigest jarShortDigest, URL uRL2, JarFile jarFile2, File file, Supplier<InputStream> supplier, ZipTools.JarShortDigest jarShortDigest2, InitiatedBy initiatedBy, String string2, int n) throws IOException {
        if (knownVmJars.contains(URLHelper.extractContainerPathFromURL(string2))) {
            this.logger().trace("Skip VM JAR reporting: %s", string2);
            return true;
        }
        if (jarShortDigest2 == null) {
            jarShortDigest2 = this.getJarCentralDirectorySignature(uRL2, jarFile2, supplier);
        }
        if (jarShortDigest2 == null) {
            this.logger().trace("Can not create Jar digest - skip: " + uRL2, new Object[0]);
        }
        if (ProcessedJarFiles.isAlreadyProcessed(string2, jarFile2, jarShortDigest2)) {
            this.logger().trace("Skip already processed: %s", string2);
            return true;
        }
        boolean bl = !this.hardstop() & this.postVMJarLoadedEvent(jarShortDigest, uRL2, jarFile2, file, supplier, jarShortDigest2, string2, initiatedBy, n, Tweaks.forceFullJarLoadedEvents);
        return bl;
    }

    private void prepareVMJarLoadedEventDetails(DataEntriesMap<Hashes> dataEntriesMap, Set<MavenComponent> set, Map<String, Long> map, URL uRL2, JarFile jarFile2, File file2, Supplier<InputStream> supplier, ZipTools.JarShortDigest jarShortDigest2, String string3, InitiatedBy initiatedBy, int n) throws IOException {
        ArrayList<Consumer<JarEntry>> arrayList = new ArrayList<Consumer<JarEntry>>();
        AtomicLong atomicLong = new AtomicLong();
        if (Tweaks.sendJarEntriesHashes) {
            arrayList.add(jarEntry -> {
                atomicLong.addAndGet(-System.nanoTime());
                try {
                    DataEntriesMap.DataEntry dataEntry = dataEntriesMap.getEntry(jarEntry.getName());
                    dataEntry.put(Hashes.ENTRY_CRC32, String.format("%08x", jarEntry.getCrc()));
                    dataEntry.put(Hashes.ENTRY_SIZE, Long.toString(jarEntry.getSize()));
                }
                finally {
                    atomicLong.addAndGet(System.nanoTime());
                }
            });
        }
        AtomicLong atomicLong2 = new AtomicLong();
        if (Tweaks.sendJarEntriesShadedHashes) {
            arrayList.add(jarEntry -> {
                block18: {
                    atomicLong2.addAndGet(-System.nanoTime());
                    try {
                        String string = jarEntry.getName();
                        if (!string.endsWith(".class")) break block18;
                        try {
                            Digest digest = Digest.get();
                            Digest digest2 = Digest.get();
                            try (InputStream inputStream = jarFile2.getInputStream((ZipEntry)jarEntry);){
                                InputStream inputStream2 = new BufferedInputStream(inputStream);
                                inputStream2 = JarLoadMonitor.wrapStream(inputStream2, digest);
                                ShadedClassHashCalculator.updateHash(inputStream2, digest2);
                                dataEntriesMap.put(string, Hashes.CLASS_SHADED_HASH, digest2.asHexString());
                                inputStream2.skip(Long.MAX_VALUE);
                                dataEntriesMap.put(string, Hashes.SHA256, digest.asHexString());
                            }
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            this.logger().info("Calculating shaded has of class %s from jar %s failed for reason: %s", string, jarFile2.getName(), illegalAccessException.getMessage());
                            dataEntriesMap.put(string, Hashes.SHA256, "0000000000000000000000000000000000000000000000000000000000000000");
                        }
                        catch (Exception exception) {
                            this.logger().error("Calculating shaded hash of class %s from jar %s failed with exception: %s", string, jarFile2.getName(), exception);
                            dataEntriesMap.put(string, Hashes.SHA256, "0000000000000000000000000000000000000000000000000000000000000000");
                        }
                    }
                    finally {
                        atomicLong2.addAndGet(System.nanoTime());
                    }
                }
            });
        }
        AtomicLong atomicLong3 = new AtomicLong();
        if (this.sendPOMProperties) {
            arrayList.add(jarEntry -> {
                block17: {
                    atomicLong3.addAndGet(-System.nanoTime());
                    try {
                        if (!jarEntry.getName().endsWith("/pom.properties")) break block17;
                        try (InputStream inputStream = jarFile2.getInputStream((ZipEntry)jarEntry);){
                            MavenComponent mavenComponent = new MavenComponent();
                            mavenComponent.load(inputStream);
                            set.add(mavenComponent);
                        }
                        catch (IOException iOException) {
                            this.logger().warning("Failed to read %s: %s", jarEntry.getName(), iOException.toString());
                        }
                    }
                    finally {
                        atomicLong3.addAndGet(System.nanoTime());
                    }
                }
            });
        }
        long l = System.nanoTime();
        this.visitJarEntries(jarFile2, arrayList);
        map.put("visitJarEntries", System.nanoTime() - l);
        map.put("jarEntriesShaded", atomicLong2.get());
        map.put("jarEntriesHashes", atomicLong.get());
        if (this.sendPOMProperties) {
            map.put("pomProperties", atomicLong3.get());
        }
        if (!this.hardstop()) {
            this.notifyNestedJars(uRL2, jarFile2, string3, jarShortDigest2, supplier, n + 1, (uRL, jarFile, file, jarShortDigest, string, string2) -> {
                DataEntriesMap.DataEntry dataEntry = dataEntriesMap.getEntry(string2);
                dataEntry.put(Hashes.ENTRY_CD, Utils.encodeToStringOrNull(jarShortDigest.getCentralDirectoryHash()));
                dataEntry.put(Hashes.ENTRY_CD_LENGTH, Long.toString(jarShortDigest.getCentralDirectoryLength()));
            });
        }
    }

    private void scheduleVMJarLoadedEvent(VMEvent vMEvent, DataEntriesMap dataEntriesMap, ZipTools.JarShortDigest jarShortDigest, URL uRL, JarFile jarFile, File file, Supplier<InputStream> supplier, ZipTools.JarShortDigest jarShortDigest2, String string, InitiatedBy initiatedBy, int n, boolean bl) throws IOException {
        int n2 = vMEvent.toJson().length();
        boolean bl2 = n2 > 524288;
        this.taskExecutor.schedule(!bl, this.taskId(jarShortDigest2, bl), this.taskIdWithDetails(jarShortDigest), (jarLoadProcessingError, string2) -> {
            try {
                Map map = (Map)vMEvent.getEventPayload();
                if (jarLoadProcessingError != null) {
                    map.remove("entries");
                    map.remove("requestCookie");
                    map.put("error", jarLoadProcessingError);
                    map.put("cause", string2);
                    this.client.postVMEvent(vMEvent);
                    ProcessedJarFiles.setAlreadyProcessed(string, jarFile, jarShortDigest2);
                    return;
                }
                map.put("entries", dataEntriesMap.pack().toExternalForm());
                vMEvent.onError(() -> JarLoadMonitor.instance.taskExecutor.terminateWithParents(this.taskId(jarShortDigest2, bl), JarLoadProcessingError.SEND_FAILED, "Failed to send VMEvent with retries: " + vMEvent));
                if (!bl2) {
                    this.client.postVMEvent(vMEvent);
                    ProcessedJarFiles.setAlreadyProcessed(string, jarFile, jarShortDigest2);
                    return;
                }
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("eventId", vMEvent.getEventId());
                hashMap.put("tags", Inventory.instanceTags());
                this.syncUpload("VM_JAR_LOADED event" + vMEvent.getEventId(), VMArtifact.Type.LARGE_VM_EVENT, hashMap, (n, outputStream) -> {
                    PrintStream printStream = new PrintStream((OutputStream)outputStream);
                    Utils.serializer.serialize(printStream, (Object)vMEvent);
                    map.remove("entries");
                    map.put("STORED_VM_JAR_LOADED_EVENT", Client.artifactIdToString(n));
                    this.client.postVMEvent(vMEvent);
                    ProcessedJarFiles.setAlreadyProcessed(string, jarFile, jarShortDigest2);
                });
            }
            finally {
                if (bl) {
                    TempFilesFactory.deleteIfScheduled(file);
                    if (!Tweaks.forceFullJarLoadedEvents && jarLoadProcessingError == null) {
                        PerformanceMetrics.logJarLoadEventConfirmed();
                        unconfirmedJarsNumber.getAndDecrement();
                    }
                    if (!Tweaks.nonBlockingJarDiscovery && jarLoadProcessingError == null) {
                        this.taskExecutor.release(this.taskIdWithDetails(jarShortDigest2));
                    }
                }
            }
        });
    }

    private boolean postVMJarLoadedEvent(ZipTools.JarShortDigest jarShortDigest2, URL uRL2, JarFile jarFile2, File file2, Supplier<InputStream> supplier, ZipTools.JarShortDigest jarShortDigest3, String string3, InitiatedBy initiatedBy, int n, boolean bl) throws IOException {
        boolean bl2 = true;
        boolean bl3 = uRL2 != null && jarFile2 != null;
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        jarShortDigest3 = jarShortDigest3 == null ? this.getJarCentralDirectorySignature(uRL2, jarFile2, supplier) : jarShortDigest3;
        this.logger().debug("postVMJarLoadedEvent %s initiated by %s (with details: %b)", new Object[]{string3, initiatedBy, bl});
        DataEntriesMap<Hashes> dataEntriesMap = new DataEntriesMap<Hashes>(Hashes.class);
        HashSet<MavenComponent> hashSet = new HashSet<MavenComponent>();
        assert (!bl || bl3);
        if (bl && bl3) {
            this.prepareVMJarLoadedEventDetails(dataEntriesMap, hashSet, hashMap, uRL2, jarFile2, file2, supplier, jarShortDigest3, string3, initiatedBy, n);
        } else if (bl3 && Tweaks.proactiveJarDiscovery && Tweaks.recursiveJarDiscovery) {
            bl2 &= !this.hardstop() && this.notifyNestedJars(uRL2, jarFile2, string3, jarShortDigest3, supplier, n + 1, (uRL, jarFile, file, jarShortDigest, string, string2) -> {});
        }
        String string4 = Tweaks.sendCentralDirectoryHash && jarShortDigest3 != null ? Utils.encodeToStringOrNull(jarShortDigest3.getCentralDirectoryHash()) : null;
        String string5 = Tweaks.sendCentralDirectoryHash && jarShortDigest3 != null ? Utils.encodeToStringOrNull(jarShortDigest3.getManifestHash()) : null;
        String string6 = Tweaks.sendCentralDirectoryHash && jarShortDigest3 != null ? jarShortDigest3.getProvider() : null;
        Long l = Tweaks.sendCentralDirectoryHash && jarShortDigest3 != null ? Long.valueOf(jarShortDigest3.getCentralDirectoryLength()) : null;
        String string7 = Tweaks.sendCentralDirectoryHash && jarShortDigest2 != null ? Utils.encodeToStringOrNull(jarShortDigest2.getCentralDirectoryHash()) : null;
        Long l2 = Tweaks.sendCentralDirectoryHash && jarShortDigest2 != null ? Long.valueOf(jarShortDigest2.getCentralDirectoryLength()) : null;
        long l3 = Utils.currentTimeMillis();
        String string8 = jarFile2 != null ? jarFile2.getName() : string3;
        VMEvent vMEvent = this.jarLoadEvent(string3, initiatedBy, n, string8, l3, string4, string5, string6, l, dataEntriesMap.pack().toExternalForm(), hashSet, hashMap, string7, l2);
        if (!bl && !Tweaks.forceFullJarLoadedEvents) {
            PerformanceMetrics.logJarLoadEventReported();
            unconfirmedJarsNumber.getAndIncrement();
        }
        if (this.hardstop()) {
            return false;
        }
        if (!Tweaks.nonBlockingJarDiscovery && Tweaks.postponeExitUntilNoUnconfirmedJars) {
            this.taskExecutor.keepUntilTerminated(this.taskIdWithDetails(jarShortDigest3));
        }
        if (!bl) {
            VmJarInfoRequestSupport.VmJarInfoRequestCookie vmJarInfoRequestCookie = new VmJarInfoRequestSupport.VmJarInfoRequestCookie(string8, string3, string4);
            ((Map)vMEvent.getEventPayload()).put("requestCookie", vmJarInfoRequestCookie.encode());
        }
        if (!bl) {
            this.taskExecutor.keepUntilTerminated(this.taskIdWithDetails(jarShortDigest3));
            this.taskExecutor.addDependency(this.taskIdWithDetails(jarShortDigest3), this.taskIdWithDetails(jarShortDigest2));
        }
        this.scheduleVMJarLoadedEvent(vMEvent, dataEntriesMap, jarShortDigest2, uRL2, jarFile2, file2, supplier, jarShortDigest3, string3, initiatedBy, n, bl);
        return bl2;
    }

    private String taskId(ZipTools.JarShortDigest jarShortDigest) {
        return jarShortDigest == null ? null : Utils.encodeToStringOrNull(jarShortDigest.getCentralDirectoryHash());
    }

    private String taskIdWithDetails(String string) {
        if (string == null) {
            return null;
        }
        return "withDetails:" + string;
    }

    private String taskId(ZipTools.JarShortDigest jarShortDigest, boolean bl) {
        return bl ? this.taskIdWithDetails(jarShortDigest) : this.taskId(jarShortDigest);
    }

    private String taskIdWithDetails(ZipTools.JarShortDigest jarShortDigest) {
        return jarShortDigest == null ? null : this.taskIdWithDetails(Utils.encodeToStringOrNull(jarShortDigest.getCentralDirectoryHash()));
    }

    private static InputStream wrapStream(InputStream inputStream, Digest digest) {
        return new DigestInputStream(inputStream, digest.getMessageDigest()){

            @Override
            public long skip(long l) throws IOException {
                int n;
                long l2;
                if (l <= 0L) {
                    return 0L;
                }
                int n2 = (int)Math.min(2048L, l2);
                byte[] byArray = new byte[n2];
                for (l2 = l; l2 > 0L && (n = this.read(byArray, 0, (int)Math.min((long)n2, l2))) >= 0; l2 -= (long)n) {
                }
                return l - l2;
            }

            @Override
            public boolean markSupported() {
                return false;
            }
        };
    }

    private void notifyJarLoad(URL uRL, JarFile jarFile, File file) {
        InitiatedBy initiatedBy = ZipTools.isJDKNative(jarFile) ? InitiatedBy.JDK_NATIVE_LOADING : InitiatedBy.OTHER;
        this.notifyJarLoad(null, null, null, null, uRL, jarFile, file, null, null, initiatedBy, uRL.toString(), 0);
    }

    public void notifyJarLoad(URL uRL, JarFile jarFile) {
        try {
            this.taskExecutor.schedule(true, (jarLoadProcessingError, string) -> {
                if (!this.canCalculateCentralDirectory(jarFile, uRL)) {
                    this.logger().trace("[notifyJarLoad] skip notifying nested jar %s (url=%s) loaded by %s.", jarFile, uRL, jarFile.getClass());
                    return;
                }
                this.notifyJarLoad(uRL, jarFile, null);
            });
        }
        catch (Exception exception) {
            System.out.println("!!! unexpected exception: " + exception);
            exception.printStackTrace();
        }
    }

    private boolean syncUpload(String string, VMArtifact.Type type, Map<String, Object> map, ThrowingBiConsumer<Integer, OutputStream, IOException> throwingBiConsumer) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        int n = this.client.createArtifactId();
        this.client.postVMArtifact(type, n, map, outputStream -> {
            try {
                throwingBiConsumer.accept(n, outputStream);
                atomicBoolean.set(true);
            }
            catch (IOException iOException) {
                this.logger().error("syncUpload for %s failed: %s", string, iOException);
            }
            finally {
                countDownLatch.countDown();
            }
        });
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            this.logger().warning("syncUpload for %s interrupted", string);
        }
        return atomicBoolean.get();
    }

    private boolean canCalculateCentralDirectory(JarFile jarFile, URL uRL) {
        return this.zt.allowAdvancedJarLoadDetection || ZipTools.isJDKNative(jarFile) || uRL.toString().indexOf("!/") == uRL.toString().lastIndexOf("!/");
    }

    public void notifyClassSourceSeen(String string) {
        try {
            if (string == null) {
                return;
            }
            if (!Tweaks.jarLoadByClassLoad) {
                return;
            }
            if ("__JVM_DefineClass__".equals(string)) {
                return;
            }
            if (ProcessedJarFiles.isAlreadyProcessedSource(string)) {
                this.logger().trace("Skip already processed source: %s", string);
                return;
            }
            ProcessedJarFiles.setAlreadyProcessedSource(string);
            this.taskExecutor.schedule(true, (jarLoadProcessingError2, string3) -> {
                this.logger().trace("processing source: %s", string);
                try {
                    URL uRL = JarFileFactory.getURLbySource(string);
                    JarFileFactory.JarFileDescriptor jarFileDescriptor = JarFileFactory.createJarFile(uRL);
                    if (jarFileDescriptor == null) {
                        this.logger().trace("Unsupported jar URL: %s", string);
                        return;
                    }
                    String string4 = jarFileDescriptor.getUrl().toString();
                    if (knownVmJars.contains(URLHelper.extractContainerPathFromURL(string4))) {
                        this.logger().trace("Skip VM JAR reporting: %s", string4);
                        return;
                    }
                    if (ProcessedJarFiles.isAlreadyProcessedURL(string4)) {
                        this.logger().trace("Skip already processed: %s", string4);
                        return;
                    }
                    if (!this.canCalculateCentralDirectory(jarFileDescriptor.getJarFile(), jarFileDescriptor.getUrl())) {
                        this.logger().trace("[notifyClassSourceSeen] skip notifying nested jar %s (url=%s, source=%s) loaded by %s.", jarFileDescriptor.getJarFile(), jarFileDescriptor.getUrl(), string, jarFileDescriptor.getJarFile().getClass());
                        return;
                    }
                    this.taskExecutor.schedule(true, (jarLoadProcessingError, string2) -> this.notifyJarLoad(null, null, null, null, jarFileDescriptor.getUrl(), jarFileDescriptor.getJarFile(), null, null, null, InitiatedBy.CLASS_LOADING, string4, 0));
                }
                catch (Exception exception) {
                    this.logger().debug("Class source (%s) is malformed or is not applicable to extract jar file", string, exception);
                }
            });
        }
        catch (Exception exception) {
            System.out.println("!!! unexpected exception: " + exception);
            exception.printStackTrace();
        }
    }

    private static boolean getBooleanProperty(String string, boolean bl) {
        return Boolean.parseBoolean(System.getProperty(string, String.valueOf(bl)));
    }

    private static int getIntProperty(String string, int n) {
        return Integer.parseInt(System.getProperty(string, String.valueOf(n)));
    }

    private static Set<String> initKnownVmJars() {
        String string = System.getProperty("java.home");
        String string2 = System.getProperty("java.specification.version");
        return KnownAzulRuntimeContainers.get(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T, E extends Throwable> void doWithReopen(T t, ThrowingSupplier<T, E> throwingSupplier, ThrowingConsumer<T, E> throwingConsumer, int n, Function<Throwable, Boolean> function, ThrowingConsumer<T, E> throwingConsumer2) throws E {
        boolean bl = false;
        try {
            for (int i = 0; i < n; ++i) {
                try {
                    throwingConsumer2.accept(t);
                    return;
                }
                catch (Throwable throwable) {
                    try {
                        if (!function.apply(throwable).booleanValue()) {
                            throw throwable;
                        }
                        t = throwingSupplier.get();
                        bl = true;
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                        throw new RuntimeException("Failed to succeed with closureWithRetry, instance=" + t + ", attempts=" + n);
                    }
                }
            }
        }
        finally {
            if (bl) {
                throwingConsumer.accept(t);
            }
        }
    }

    public static void doWithJarReopen(JarFile jarFile2, URL uRL, ThrowingConsumer<JarFile, Exception> throwingConsumer) throws Exception {
        JarLoadMonitor.doWithReopen(jarFile2, () -> new JarFile(uRL.getPath(), false), jarFile -> jarFile.close(), 2, throwable -> throwable instanceof IOException || ZipTools.ZipFileClosedException.isZipFileClosedException(throwable), throwingConsumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$null$6(long l, String string, JarEntry jarEntry, JarFile jarFile, URL uRL, JarEntry jarEntry2, JarIdentifierVisitor jarIdentifierVisitor, String string2, ZipTools.JarShortDigest jarShortDigest, String string3, String string4, int n, JarLoadProcessingError jarLoadProcessingError, String string5) {
        TempFilesFactory.TempFile tempFile2;
        boolean bl = false;
        Logger logger = this.logger();
        try {
            tempFile2 = TempFilesFactory.createTempJarFile(tempFile -> {
                try {
                    PerformanceMetrics.logJarCacheDeleted(l);
                    this.releaseSpaceInJarCache(l);
                }
                catch (Exception exception) {
                    logger.debug("Error while completing onDeleteAction after deleting temp file=%s, e=%s", tempFile, exception);
                }
            });
        }
        catch (IOException iOException) {
            this.logger().error("Failed to create temp file although requied space is in limit. limit=%ld, rest=%ld, consumption=%ld (cause=%s)", this.maxJarFileCacheSize, this.jarFileCacheLimit.get(), this.maxJarFileCacheSize - this.jarFileCacheLimit.get(), iOException);
            if (!Tweaks.nonBlockingJarDiscovery) {
                this.taskExecutor.terminateWithParents(string, JarLoadProcessingError.NESTED_JAR, jarEntry.getName() + ": TempFilesFactory.createTempFarFile failed: " + iOException);
            }
            return;
        }
        PerformanceMetrics.logJarCacheCreated(l);
        this.acquireSpaceInJarCache(l);
        try {
            JarLoadMonitor.doWithJarReopen(jarFile, uRL, jarFile2 -> {
                try (InputStream inputStream = jarFile.getInputStream(jarEntry2);){
                    Files.copy(inputStream, tempFile2.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    URL uRL2 = tempFile2.toURL();
                    JarFile jarFile3 = new JarFile(tempFile2);
                    ZipTools.JarShortDigest jarShortDigest2 = this.getJarCentralDirectorySignature(uRL2, jarFile3, null);
                    if (jarIdentifierVisitor != null) {
                        jarIdentifierVisitor.visit(uRL2, jarFile3, tempFile2, jarShortDigest2, string2, jarEntry2.getName());
                    }
                    if (ProcessedJarFiles.isAlreadyProcessed(string2, jarFile3, jarShortDigest2)) {
                        this.taskExecutor.release(this.taskId(jarShortDigest2, false));
                        this.taskExecutor.release(this.taskId(jarShortDigest2, true));
                        return;
                    }
                    if (!Tweaks.nonBlockingJarDiscovery) {
                        this.taskExecutor.addDependency(this.taskIdWithDetails(jarShortDigest2), this.taskIdWithDetails(jarShortDigest));
                    }
                    this.notifyJarLoad(uRL, jarFile, string3, jarShortDigest, uRL2, jarFile3, tempFile2, null, jarShortDigest2, InitiatedBy.RECURSIVE_LOADING, string4, n);
                }
            });
            if (tempFile2 != null) {
                bl = !ServerRequestsService.isDisabled();
                TempFilesFactory.scheduleDeletion(tempFile2, Tweaks.tempfilesTimeToLive);
            }
        }
        catch (Exception exception) {
            this.logger().error("Failed to notify nested jar load, parentJar1=%s(%s) (%s), entryName=%s; exception=%s", jarFile, jarFile.getName(), uRL, jarEntry.getName(), exception);
            this.taskExecutor.terminateWithParents(string, JarLoadProcessingError.EXCEPTION, jarEntry.getName() + ": " + exception);
        }
        finally {
            if (!bl) {
                tempFile2.delete();
            }
        }
    }

    private static /* synthetic */ InputStream lambda$null$2(InputStream inputStream) {
        return inputStream;
    }

    @FunctionalInterface
    public static interface ThrowingSupplier<T, E extends Throwable> {
        public T get() throws E;
    }

    @FunctionalInterface
    public static interface ThrowingConsumer<T, E extends Throwable> {
        public void accept(T var1) throws E;
    }

    private static final class TaskExecutor {
        private NestedJarsDependencies dependencies;
        private Map<String, String> blocked;
        private Map<String, Tuple<JarLoadProcessingError, String>> terminated;
        private Set<String> scheduled;
        private Queue<Task> queue;
        private volatile boolean isAlive = true;
        private Thread thread;
        private Object lock = this;
        private static Logger logger = Logger.getLogger(JarLoadMonitor.class);
        private long uniqCounter = 0L;
        private volatile Utils.Deadline deadline;

        TaskExecutor(int n) {
            this.queue = new LinkedList<Task>();
            this.dependencies = new NestedJarsDependencies();
            this.blocked = new HashMap<String, String>();
            this.terminated = new HashMap<String, Tuple<JarLoadProcessingError, String>>();
            this.scheduled = new HashSet<String>();
        }

        public synchronized void release(String string) {
            String string2 = this.blocked.remove(string);
            logger.trace("TaskExecutor.release hash=%s, parentHash=%s, stack=%s", string, string2, Tweaks.DEBUG_JARLOAD ? new RuntimeException("here") : null);
            this.dependencies.removeFromItself(string);
            Tuple<JarLoadProcessingError, String> tuple = this.terminated.remove(string);
            if (string2 == null) {
                return;
            }
            if (!Tweaks.nonBlockingJarDiscovery && tuple != null) {
                this.terminateWithParents(string2, JarLoadProcessingError.NESTED_JAR, (String)tuple.second);
            }
            if (this.dependencies.removeFromParent(string2, string)) {
                this.notify();
            } else {
                logger.warning("Hash %s has not been removed from parent %s ... ", string, string2);
            }
        }

        private synchronized void schedule(Task task) {
            if (!this.isAlive) {
                logger.trace("TaskExecutor.schedule is not allowed (task executor is not alive) task=%s, stack=%s", task, Tweaks.DEBUG_JARLOAD ? new RuntimeException("here") : null);
                return;
            }
            if (this.scheduled.contains(task.hash)) {
                logger.debug("TaskExecutor.schedule task with hash=%s already scheduled. dropping: task=%s, stack=%s", task.hash, task, Tweaks.DEBUG_JARLOAD ? new RuntimeException("here") : null);
                return;
            }
            if (this.queue.size() >= Tweaks.jarLoadMonitorTaskQueueSize) {
                logger.error("queue size limit reached (task=%s) %s", task, new RuntimeException("here"));
            }
            if (this.queue.offer(task)) {
                this.scheduled.add(task.hash);
                this.notify();
            }
        }

        public synchronized String getUniqId() {
            ++this.uniqCounter;
            return ":" + this.toString() + ":" + this.hashCode() + ":" + this.uniqCounter;
        }

        public synchronized String addDependency(String string, String string2) {
            if (!this.isAlive) {
                logger.trace("TaskExecutor.addDependency is not allowed (task executor is not alive) hash=%s, parentHash=%s, stack=%s", string, string2, Tweaks.DEBUG_JARLOAD ? new RuntimeException("here") : null);
                return null;
            }
            logger.trace("TaskExecutor.addDependency hash=%s, parentHash=%s, terminated=%s, stack=%s", string, string2, this.terminated.get(string) != null, Tweaks.DEBUG_JARLOAD ? new RuntimeException("here") : null);
            if (string == null && string2 != null) {
                string = this.getUniqId();
            }
            if (this.terminated.get(string) != null) {
                this.terminateWithParents(string2, JarLoadProcessingError.NESTED_JAR, (String)this.terminated.get((Object)string).second);
            }
            if (string2 != null) {
                if (!string.equals(string2)) {
                    this.blocked.put(string, string2);
                }
                this.dependencies.add(string2, string);
            }
            return string;
        }

        public synchronized void keepUntilTerminated(String string) {
            this.addDependency(string, string);
        }

        public synchronized void terminateWithParents(String string, JarLoadProcessingError jarLoadProcessingError, String string2) {
            logger.trace("TaskExecutor.terminateWithParents hash=%s, error=%s, cause=%s, stack=%s", new Object[]{string, jarLoadProcessingError, string2, Tweaks.DEBUG_JARLOAD ? new RuntimeException("here") : null});
            String string3 = this.blocked.remove(string);
            if (this.terminated.get(string) == null && string3 != null) {
                this.terminated.put(string, new Tuple<JarLoadProcessingError, String>(jarLoadProcessingError, string2));
            }
            this.dependencies.remove(string3, string);
            if (!Tweaks.nonBlockingJarDiscovery && string3 != null) {
                this.terminateWithParents(string3, JarLoadProcessingError.NESTED_JAR, string2);
            }
        }

        public synchronized void keepUntilDeadline(int n, String string) {
            if (n == 0) {
                return;
            }
            String string4 = string + ":deadline=" + n;
            String string5 = string + ":onCompletion";
            this.addDependency(string4, string);
            this.addDependency(string, string5);
            TaskExecutor taskExecutor = this;
            Task task = new Task(this, string4, () -> Utils.Deadline.in(n, TimeUnit.MILLISECONDS).hasExpired(), (jarLoadProcessingError, string3) -> {
                taskExecutor.release(string);
                taskExecutor.release(string5);
            });
            this.schedule(task);
            Task task2 = new Task(this, string5, null, (jarLoadProcessingError, string2) -> taskExecutor.release(string4));
            this.schedule(task2);
        }

        public synchronized void schedule(boolean bl, Integer n, String string, String string2, Supplier<Boolean> supplier, BiConsumer<JarLoadProcessingError, String> biConsumer) {
            String string3 = this.addDependency(string, string2);
            logger.trace("TaskExecutor.schedule hash=%s, parentHash=%s, keepUntilTerminated=%s, keepUntilDeadline=%s, task=%s, stack=%s", string, string2, bl, n, biConsumer, Tweaks.DEBUG_JARLOAD ? new RuntimeException("here") : null);
            if (bl) {
                this.keepUntilTerminated(string3);
            } else if (n != null) {
                this.keepUntilDeadline(n, string3);
            }
            Task task = new Task(this, string3, supplier, biConsumer);
            this.schedule(task);
        }

        public synchronized void schedule(boolean bl, String string, String string2, Supplier<Boolean> supplier, BiConsumer<JarLoadProcessingError, String> biConsumer) {
            this.schedule(bl, null, string, string2, supplier, biConsumer);
        }

        public synchronized void schedule(boolean bl, String string, String string2, BiConsumer<JarLoadProcessingError, String> biConsumer) {
            this.schedule(bl, string, string2, null, biConsumer);
        }

        public synchronized void schedule(boolean bl, BiConsumer<JarLoadProcessingError, String> biConsumer) {
            Task task = new Task(this, null, null, biConsumer);
            if (bl) {
                this.keepUntilTerminated(task.hash);
            }
            this.schedule(task);
        }

        public synchronized boolean isExpectingTasks() {
            return instance.activeTasksNumber() > 0 || !this.queue.isEmpty() || !this.blocked.isEmpty() || this.dependencies.anyDependency() || Tweaks.nonBlockingJarDiscovery && Tweaks.postponeExitUntilNoUnconfirmedJars && unconfirmedJarsNumber.get() > 0L;
        }

        public synchronized void start() {
            logger.trace("TaskExecutor starting...", new Object[0]);
            this.thread = new Thread(() -> {
                try {
                    Task task = null;
                    Object object = this.lock;
                    synchronized (object) {
                        while (this.deadline == null || !instance.hardstop() && this.isExpectingTasks()) {
                            Task task2 = this.queue.poll();
                            logger.trace("TaskExecutor: run loop (deadline=%s): queue poll t=%s", this.deadline, task2);
                            if (Tweaks.DEBUG_JARLOAD) {
                                logger.trace(">>> tasks=" + this.queue.size(), new Object[0]);
                                logger.trace(">>> (deadline == null)=" + (this.deadline == null), new Object[0]);
                                logger.trace(">>> deadline.hasExpired=" + (this.deadline != null && this.deadline.hasExpired()), new Object[0]);
                                logger.trace(">>> isExpectingTasks()=" + this.isExpectingTasks(), new Object[0]);
                                logger.trace(">>> unconfirmedJarsNumber=" + unconfirmedJarsNumber.get(), new Object[0]);
                                logger.trace(">>> blocked=" + this.blocked.keySet().stream().map(string -> "" + string + "=" + this.blocked.get(string)).collect(Collectors.joining(", ", "{", "}")), new Object[0]);
                                logger.trace(">>> " + this.dependencies.toString(), new Object[0]);
                                logger.trace(">>> terminated=" + this.terminated.keySet().stream().map(string -> "" + string + "=" + this.terminated.get((Object)string).first + " : " + (String)this.terminated.get((Object)string).second).collect(Collectors.joining(", ", "[", "]")), new Object[0]);
                                logger.trace(">>> tempSpaceAvailable=" + instance.jarFileCacheLimit.get() + ", tempSpaceUsed=" + (instance.maxJarFileCacheSize - instance.jarFileCacheLimit.get()), new Object[0]);
                            }
                            if (task2 == null) {
                                if (this.deadline == null) {
                                    this.lock.wait();
                                    continue;
                                }
                                long l = Utils.currentTimeMillis();
                                instance.client.postVMEvent(new VMEvent().randomEventId().eventType(VMEvent.Type.VM_HEARTBEAT).eventTime(l));
                                long l2 = Tweaks.HEARTBEAT_SLEEP;
                                if (this.deadline != null) {
                                    l2 = Math.min(l2, Math.max(Tweaks.YIELD_SLEEP, this.deadline.remainder(TimeUnit.MILLISECONDS) - Tweaks.LAST_HEARTBEAT_BEFORE_DEADLINE));
                                }
                                this.lock.wait(l2);
                                continue;
                            }
                            if (task2 == task) {
                                if (this.deadline == null) {
                                    this.lock.wait(task2.postponedCount < 10 ? Tweaks.YIELD_SLEEP : Tweaks.HEARTBEAT_SLEEP);
                                } else {
                                    this.lock.wait(Tweaks.YIELD_SLEEP);
                                }
                            }
                            if (!task2.isReady() && this.terminated.get(task2.hash) == null) {
                                logger.trace("TaskExecutor: task is not ready. running=%s, postpone t=%s", this.isAlive, task2);
                                ++task2.postponedCount;
                                if (task2.isOutdated()) {
                                    logger.debug("task t=%s is outdated. Removing from task queue", task2);
                                    this.terminateWithParents(task2.hash, JarLoadProcessingError.OTHER, "canceled after postponing " + task2.postponedCount + " times");
                                } else {
                                    task = task2;
                                    this.queue.add(task2);
                                    continue;
                                }
                            }
                            logger.trace("TaskExecutor: run task t=%s", task2);
                            task2.run();
                            this.release(task2.hash);
                            this.lock.wait(Tweaks.YIELD_SLEEP);
                        }
                        this.isAlive = false;
                    }
                    logger.trace("TaskExecutor loop is done, exiting...", new Object[0]);
                    if (Tweaks.DEBUG_JARLOAD) {
                        logger.trace(">>> tasks=" + this.queue.size(), new Object[0]);
                        logger.trace(">>> (deadline == null)=" + (this.deadline == null), new Object[0]);
                        logger.trace(">>> deadline.hasExpired=" + (this.deadline != null && this.deadline.hasExpired()), new Object[0]);
                        logger.trace(">>> isExpectingTasks()=" + this.isExpectingTasks(), new Object[0]);
                        logger.trace(">>> unconfirmedJarsNumber=" + unconfirmedJarsNumber.get(), new Object[0]);
                        logger.trace(">>> blocked=" + this.blocked.keySet().stream().map(string -> "" + string + "=" + this.blocked.get(string)).collect(Collectors.joining(", ", "{", "}")), new Object[0]);
                        logger.trace(">>> " + this.dependencies.toString(), new Object[0]);
                        logger.trace(">>> terminated=" + this.terminated.keySet().stream().map(string -> "" + string + "=" + this.terminated.get((Object)string).first + " : " + (String)this.terminated.get((Object)string).second).collect(Collectors.joining(", ", "[", "]")), new Object[0]);
                        logger.trace(">>> tempSpaceAvailable=" + instance.jarFileCacheLimit.get() + ", tempSpaceUsed=" + (instance.maxJarFileCacheSize - instance.jarFileCacheLimit.get()), new Object[0]);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
            this.thread.setDaemon(true);
            this.thread.setName("JarLoadMonitor.TaskExecutor");
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop(Utils.Deadline deadline) {
            TaskExecutor taskExecutor = this;
            synchronized (taskExecutor) {
                if (!this.isAlive) {
                    return;
                }
                this.deadline = deadline == null ? Utils.Deadline.in(0L, TimeUnit.MILLISECONDS) : deadline;
                logger.debug("Stopping JarLoadMonitor.TaskExecutor", new Object[0]);
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notify();
                }
                if (this.thread == null) {
                    return;
                }
            }
            try {
                this.thread.join(deadline.remainder(TimeUnit.MILLISECONDS));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.thread.interrupt();
        }

        private static final class Task {
            public final TaskExecutor context;
            public final BiConsumer<JarLoadProcessingError, String> action;
            public final String hash;
            public final Supplier<Boolean> condition;
            public int postponedCount;
            public final Utils.Deadline deadline;
            private final Instant createdTime;
            private Duration waitingTime;

            public boolean isReady() {
                boolean bl;
                if (this.condition != null && !this.condition.get().booleanValue()) {
                    PerformanceMetrics.logJarLoadNoSpace();
                    logger.trace("TaskExecutor: task t=%s pre-condition not-satisfied", this);
                    return false;
                }
                if (Tweaks.nonBlockingJarDiscovery) {
                    return true;
                }
                if (this.hash == null) {
                    return true;
                }
                Set set = this.context.dependencies.get(this.hash);
                boolean bl2 = bl = set == null || set.size() == 0 || set.size() == 1 && set.contains(this.hash);
                if (Tweaks.DEBUG_JARLOAD && !bl) {
                    logger.trace("TaskExecutor: task t=%s has active dependencies: %s, deps contains hash == %s", this, set.stream().map(object -> object.toString()).collect(Collectors.joining(", ")), set.contains(this.hash));
                }
                return bl;
            }

            public boolean isOutdated() {
                return this.postponedCount > Tweaks.jarLoadMonitorTaskQueuePostponeLimit || this.deadline.hasExpired();
            }

            public Task(TaskExecutor taskExecutor, String string, Supplier<Boolean> supplier, BiConsumer<JarLoadProcessingError, String> biConsumer) {
                this.hash = string != null ? string : instance.taskExecutor.getUniqId();
                this.action = biConsumer;
                this.context = taskExecutor;
                this.condition = supplier;
                this.postponedCount = 0;
                this.deadline = Utils.Deadline.in(Tweaks.jarLoadMonitorTaskQueuePostponeTimeout, TimeUnit.MILLISECONDS);
                this.createdTime = Instant.now();
            }

            public String toString() {
                return "Task[jarHash=" + this.hash + ",postponedCount=" + this.postponedCount + "]";
            }

            public void run() {
                this.waitingTime = Duration.between(this.createdTime, Instant.now());
                PerformanceMetrics.logJarWaitingTime(this.waitingTime.toMillis());
                Tuple tuple = (Tuple)instance.taskExecutor.terminated.get(this.hash);
                if (tuple == null) {
                    this.action.accept(null, null);
                } else {
                    this.action.accept((JarLoadProcessingError)((Object)tuple.first), (String)tuple.second);
                }
                instance.taskExecutor.scheduled.remove(this.hash);
            }
        }
    }

    static class Tuple<X, Y> {
        public final X first;
        public final Y second;

        public Tuple(X x, Y y) {
            this.first = x;
            this.second = y;
        }
    }

    private static class NotificationTask {
        private final AtomicBoolean completedSuccessfully = new AtomicBoolean();
        private final String description;

        private NotificationTask(String string) {
            this.description = string;
        }

        private void setCompletionStatus(boolean bl) {
            this.completedSuccessfully.set(bl);
        }

        private boolean isCompletedSuccessfully() {
            return this.completedSuccessfully.get();
        }

        public String toString() {
            return this.description;
        }
    }

    private static final class MavenComponent
    extends Properties {
        private MavenComponent() {
        }
    }

    @FunctionalInterface
    public static interface ThrowingBiConsumer<T, U, E extends Throwable> {
        public void accept(T var1, U var2) throws E;
    }

    private static interface JarIdentifierVisitor {
        public void visit(URL var1, JarFile var2, File var3, ZipTools.JarShortDigest var4, String var5, String var6);
    }

    private static enum Hashes {
        ENTRY_CRC32,
        ENTRY_SIZE,
        SHA256,
        CLASS_SHADED_HASH,
        ENTRY_CD,
        ENTRY_CD_LENGTH;

    }

    private static final class NestedJarsAreNotAccessibleException
    extends RuntimeException {
        public NestedJarsAreNotAccessibleException(String string) {
            super(string);
        }
    }

    public static enum JarLoadProcessingError {
        TEMPFS_LIMIT,
        EXCEPTION,
        NESTED_JAR,
        SEND_FAILED,
        OTHER;

    }

    public static enum InitiatedBy {
        CLASS_LOADING,
        JDK_NATIVE_LOADING,
        RECURSIVE_LOADING,
        SERVER_REQUEST,
        OTHER;

    }

    private static final class JarFileAccess {
        private final Collection<Pattern> patterns = new ArrayList<Pattern>();

        JarFileAccess(String string) {
            if (string != null && string.length() > 0) {
                for (String string2 : string.split(",")) {
                    string2 = string2.replaceAll("\\*\\*", "%%%%1%%%%");
                    string2 = string2.replaceAll("\\*", "%%%%2%%%%");
                    string2 = string2.replaceAll("%%%%1%%%%", ".*");
                    string2 = string2.replaceAll("%%%%2%%%%", "[^/]*");
                    this.patterns.add(Pattern.compile(string2));
                }
            }
        }

        public boolean isAllowed(String string) {
            for (Pattern pattern : this.patterns) {
                if (!pattern.matcher(string).matches()) continue;
                return true;
            }
            return false;
        }
    }

    private static final class JarEntryAccess {
        private static final String prefix = "**/";
        private final Collection<String> entireFileNameMatch = new ArrayList<String>();
        private final Collection<String> suffixMatch = new ArrayList<String>();

        JarEntryAccess(String string) {
            for (String string2 : string.split(",")) {
                if (string2.startsWith(prefix)) {
                    this.suffixMatch.add(string2.substring(prefix.length()));
                    continue;
                }
                this.entireFileNameMatch.add(string2);
            }
        }

        public boolean isAllowed(String string) {
            if (string == null) {
                return false;
            }
            if (this.entireFileNameMatch.contains(string)) {
                return true;
            }
            for (String string2 : this.suffixMatch) {
                int n;
                int n2 = string.length();
                if (n2 < (n = string2.length()) || !string.endsWith(string2) || n2 != n && string.charAt(n2 - n - 1) != '/') continue;
                return true;
            }
            return false;
        }
    }

    private static final class ProcessedJarFiles {
        private static final LRUCache<String> knownURLs = new LRUCache(Tweaks.dedupSize);
        private static final LRUCache<String> knownCDHashes = new LRUCache(Tweaks.dedupSize);
        private static final LRUCache<String> knownSources = new LRUCache(Tweaks.dedupSize);
        private static Logger logger = Logger.getLogger(JarLoadMonitor.class);

        private ProcessedJarFiles() {
        }

        private static String getJarUUID(String string, JarFile jarFile, ZipTools.JarShortDigest jarShortDigest) {
            if (jarShortDigest == null) {
                return null;
            }
            String string2 = Utils.encodeToStringOrNull(jarShortDigest.getCentralDirectoryHash());
            return string2 + ":" + jarShortDigest.getCentralDirectoryLength();
        }

        public static boolean isAlreadyProcessed(String string, JarFile jarFile, ZipTools.JarShortDigest jarShortDigest) {
            assert (jarShortDigest != null);
            String string2 = ProcessedJarFiles.getJarUUID(string, jarFile, jarShortDigest);
            boolean bl = knownURLs.contains(string) || knownCDHashes.contains(string2);
            logger.trace("ProcessedJarFiles.isAlreadyProcessed: metaUrl=%s, jar.name=%s, hash=%s, result=%s, stack=%s", string, jarFile != null ? jarFile.getName() : null, string2, bl, Tweaks.DEBUG_JARLOAD ? new RuntimeException("here") : null);
            return bl;
        }

        public static boolean isAlreadyProcessedURL(String string) {
            return knownURLs.contains(string);
        }

        public static boolean isAlreadyProcessedSource(String string) {
            return knownSources.contains(string);
        }

        public static void setAlreadyProcessedURL(String string) {
            knownURLs.put(string);
        }

        public static void setAlreadyProcessedSource(String string) {
            knownSources.put(string);
        }

        public static void setAlreadyProcessed(String string, JarFile jarFile, ZipTools.JarShortDigest jarShortDigest) {
            assert (string != null);
            assert (jarShortDigest != null);
            String string2 = ProcessedJarFiles.getJarUUID(string, jarFile, jarShortDigest);
            knownURLs.put(string);
            knownCDHashes.put(string2);
        }
    }
}

