/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.service;

import com.azul.crs.client.Client;
import com.azul.crs.client.Inventory;
import com.azul.crs.client.Utils;
import com.azul.crs.client.models.VMArtifact;
import com.azul.crs.client.service.ClientService;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class CRSLogMonitor
implements ClientService {
    private static final int INITIAL_BUFFER_SIZE = 4096;
    private static final String OVERFLOW_WARNING = "... [truncated] ...";
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private final AtomicReference<ByteBuffer> bufferRef;
    private final AtomicBoolean overflow = new AtomicBoolean(false);
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private final AtomicInteger artifactID = new AtomicInteger(0);
    private final AtomicReference<Client> clientRef = new AtomicReference();

    public CRSLogMonitor() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4096);
        byteBuffer.limit(4096 - OVERFLOW_WARNING.length());
        this.bufferRef = new AtomicReference<ByteBuffer>(byteBuffer);
    }

    public void setClient(Client client) {
        if (!this.clientRef.compareAndSet(null, client)) {
            throw new IllegalStateException(this.serviceName() + " client is defined already");
        }
    }

    @Override
    public void start() {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException(this.serviceName() + " is running already");
        }
        Client client = this.clientRef.get();
        if (client == null) {
            throw new IllegalStateException(this.serviceName() + " starting without client defined");
        }
        int n = client.createArtifactId();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("name", "crs.log");
        hashMap.put("tags", Inventory.instanceTags());
        client.postVMArtifactCreate(VMArtifact.Type.CRS_LOG, n, hashMap);
        if (!this.artifactID.compareAndSet(0, n)) {
            throw new IllegalStateException(this.serviceName() + " artifactID is set already");
        }
    }

    @Override
    public void stop(Utils.Deadline deadline) {
        this.stopped.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyCRSLogEntry(byte[] byArray, int n, int n2) {
        block10: {
            try {
                if (this.stopped.get()) {
                    return;
                }
                int n3 = this.artifactID.get();
                ByteBuffer byteBuffer = this.bufferRef.get();
                if (n3 == 0) {
                    if (this.overflow.get()) break block10;
                    AtomicBoolean atomicBoolean = this.overflow;
                    synchronized (atomicBoolean) {
                        if (!this.overflow.get() && byteBuffer.remaining() > n2) {
                            byteBuffer.put(byArray, n, n2);
                        } else {
                            byteBuffer.limit(byteBuffer.capacity());
                            byteBuffer.put(OVERFLOW_WARNING.getBytes());
                            this.overflow.set(true);
                        }
                        break block10;
                    }
                }
                Client client = this.clientRef.get();
                if (byteBuffer != null && this.bufferRef.compareAndSet(byteBuffer, null)) {
                    client.postVMArtifactData(n3, new String(byteBuffer.array(), 0, byteBuffer.position(), CHARSET));
                }
                client.postVMArtifactData(n3, new String(byArray, n, n2, CHARSET));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.out);
            }
        }
    }
}

