/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.jars;

import com.azul.crs.util.logging.Logger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class NestedJarsDependencies {
    private static Logger logger = Logger.getLogger(NestedJarsDependencies.class);
    private final Map<String, Set<String>> dependencies = new HashMap<String, Set<String>>();

    public void removeFromItself(String string) {
        this.removeFromParent(string, string);
    }

    public boolean removeFromParent(String string, String string2) {
        Set<String> set = this.dependencies.get(string);
        if (set != null) {
            set.remove(string2);
            if (set.size() == 0) {
                this.dependencies.remove(string);
            }
            return true;
        }
        return false;
    }

    public void add(String string, String string2) {
        Set<String> set;
        if (string2.equals(string)) {
            logger.trace("Creating dependencies to itself: %s", string2);
        }
        if ((set = this.dependencies.get(string)) == null) {
            set = new HashSet<String>();
            this.dependencies.put(string, set);
        }
        set.add(string2);
    }

    public void remove(String string, String string2) {
        this.dependencies.remove(string2);
        if (string != null) {
            this.removeFromParent(string, string2);
        }
    }

    public boolean anyDependency() {
        return this.dependencies.keySet().stream().anyMatch(string -> this.dependencies.get(string).isEmpty());
    }

    public Set get(String string) {
        return this.dependencies.get(string);
    }

    public String toString() {
        return "dependencies=" + this.dependencies.keySet().stream().map(string -> "" + string + "=" + this.dependencies.get(string).stream().collect(Collectors.joining(", ", "[", "]"))).collect(Collectors.joining(", ", "{", "}"));
    }
}

