/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client;

import com.azul.crs.json.JSONSerializer;
import com.azul.crs.json.JSONStaticSerializer;
import com.azul.crs.util.logging.Logger;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class Utils {
    private static final Logger logger = Logger.getLogger(Utils.class);
    private static final char[] digit = "0123456789abcdef".toCharArray();
    public static final JSONSerializer serializer = new JSONStaticSerializer();
    public static final JSONSerializer prettySerializer = new JSONStaticSerializer(true);
    public static final int BUFFER_SIZE = 8192;
    private static final ThreadLocal<WeakReference<byte[]>> buffers = new ThreadLocal();

    private Utils() {
    }

    public static String uuid() {
        return UUID.randomUUID().toString();
    }

    public static String uuid(String string) {
        return UUID.nameUUIDFromBytes(string.getBytes()).toString();
    }

    public static String uuid(Object ... objectArray) {
        return Utils.uuid(Arrays.toString(objectArray));
    }

    public static String lower(String string) {
        return string != null ? string.toLowerCase() : null;
    }

    public static long currentTimeCount() {
        return System.nanoTime();
    }

    public static long nextTimeCount(long l) {
        return System.nanoTime() + l * 1000000L;
    }

    public static String elapsedTimeString(long l) {
        return String.format(" (%,d ms)", Utils.elapsedTimeMillis(l));
    }

    public static long elapsedTimeMillis(long l) {
        return (System.nanoTime() - l + 500000L) / 1000000L;
    }

    public static void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static String encodeToStringOrNull(byte[] byArray, int n, int n2) {
        if (null == byArray) {
            return null;
        }
        char[] cArray = new char[n2 * 2];
        for (int i = n; i < n + n2; ++i) {
            byte by = byArray[i];
            cArray[(i - n) * 2] = digit[by >>> 4 & 0xF];
            cArray[(i - n) * 2 + 1] = digit[by & 0xF];
        }
        return new String(cArray);
    }

    public static String encodeToStringOrNull(byte[] byArray) {
        if (null == byArray) {
            return null;
        }
        return Utils.encodeToStringOrNull(byArray, 0, byArray.length);
    }

    public static void transfer(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray;
        WeakReference<byte[]> weakReference = buffers.get();
        if (weakReference == null || (byArray = (byte[])weakReference.get()) == null) {
            byArray = new byte[8192];
            buffers.set(new WeakReference<byte[]>(byArray));
        }
        while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    public static final class Deadline {
        private final long deadline;
        private volatile boolean expired = false;

        private Deadline(long l) {
            this.deadline = l;
        }

        public static Deadline in(long l, TimeUnit timeUnit) {
            if (l < 0L) {
                throw new IllegalArgumentException("Can setup deadline in the future only");
            }
            return new Deadline(System.nanoTime() + timeUnit.toNanos(l));
        }

        public boolean hasExpired() {
            this.remainder(TimeUnit.NANOSECONDS);
            return this.expired;
        }

        public long remainder(TimeUnit timeUnit) {
            if (this.expired) {
                return 0L;
            }
            long l = Math.max(0L, this.deadline - System.nanoTime());
            if (l == 0L) {
                this.expired = true;
                return 0L;
            }
            return timeUnit.convert(l, TimeUnit.NANOSECONDS);
        }

        public <R, E extends Exception> Optional<R> applyIfNotExpired(TimeLimitedFunction<R, E> timeLimitedFunction) throws E {
            long l = this.remainder(TimeUnit.MILLISECONDS);
            return l > 0L ? Optional.ofNullable(timeLimitedFunction.apply(l)) : Optional.empty();
        }

        public <E extends Exception> void runIfNotExpired(TimeLimitedRunnable<E> timeLimitedRunnable) throws E {
            long l = this.remainder(TimeUnit.MILLISECONDS);
            if (l > 0L) {
                timeLimitedRunnable.run(l);
            }
        }

        @FunctionalInterface
        public static interface TimeLimitedRunnable<E extends Exception> {
            public void run(long var1) throws E;
        }

        @FunctionalInterface
        public static interface TimeLimitedFunction<R, E extends Exception> {
            public R apply(long var1) throws E;
        }
    }

    public static final class CountingOutputStream
    extends FilterOutputStream {
        private final Consumer<Long> onClose;
        private long counter = 0L;

        public CountingOutputStream(OutputStream outputStream, Consumer<Long> consumer) {
            super(outputStream);
            this.onClose = consumer;
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.out.write(byArray, n, n2);
            this.counter += (long)n2;
        }

        @Override
        public void write(int n) throws IOException {
            this.out.write(n);
            ++this.counter;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.onClose.accept(this.counter);
        }
    }

    public static final class Digest {
        private static final int MAC_POOL_SIZE = 2;
        private static volatile BlockingQueue<Mac> macPool = null;
        private static final String DIGEST_ALGO = "HmacSHA256";
        private static final Object lock = new Object();
        private static boolean macPoolInitialized = false;

        private Digest() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Mac acquireMAC() throws InterruptedException {
            BlockingQueue<Mac> blockingQueue = macPool;
            if (blockingQueue == null) {
                Object object = lock;
                synchronized (object) {
                    blockingQueue = macPool;
                    if (blockingQueue == null && !macPoolInitialized) {
                        macPoolInitialized = true;
                        ArrayBlockingQueue<Mac> arrayBlockingQueue = new ArrayBlockingQueue<Mac>(2);
                        byte[] byArray = new byte[256];
                        new SecureRandom().nextBytes(byArray);
                        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, DIGEST_ALGO);
                        for (int i = 0; i < 2; ++i) {
                            try {
                                Mac mac = Mac.getInstance(DIGEST_ALGO);
                                if (mac == null) {
                                    logger.error("Unable to instantiate MAC for %s", DIGEST_ALGO);
                                    return null;
                                }
                                mac.init(secretKeySpec);
                                arrayBlockingQueue.put(mac);
                                continue;
                            }
                            catch (InvalidKeyException | NoSuchAlgorithmException generalSecurityException) {
                                logger.error("Unable to instantiate MAC for %s", DIGEST_ALGO);
                                return null;
                            }
                        }
                        macPool = arrayBlockingQueue;
                        blockingQueue = arrayBlockingQueue;
                    }
                }
            }
            return blockingQueue == null ? null : blockingQueue.take();
        }

        private static void releaseMAC(Mac mac) throws InterruptedException {
            BlockingQueue<Mac> blockingQueue = macPool;
            if (blockingQueue != null) {
                mac.reset();
                blockingQueue.put(mac);
            }
        }

        public static byte[] digest(byte[] byArray) {
            byte[] byArray2;
            block5: {
                byArray2 = null;
                try {
                    Mac mac = Digest.acquireMAC();
                    if (mac == null) break block5;
                    try {
                        byArray2 = mac.doFinal(byArray);
                    }
                    finally {
                        Digest.releaseMAC(mac);
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.interrupted();
                }
            }
            return byArray2;
        }

        public static String digestBase64(String string) {
            byte[] byArray = Digest.digest(string.getBytes());
            return byArray == null ? null : Base64.getEncoder().encodeToString(byArray);
        }
    }
}

