/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.zip.ZipFile;
import javax.net.ssl.HttpsURLConnection;
import sun.net.dns.ResolverConfiguration;
import sun.net.www.http.HttpClient;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.net.www.protocol.https.HttpsURLConnectionImpl;

public class JDKAccessor {
    private static final Boolean isJDK8 = System.getProperty("java.version").startsWith("1.");
    private boolean initialized = false;
    private Field res;
    private Class cleanableResource;
    private Field zsrc;
    private Class source;
    private Field cen;
    private Method getCentralDirectory;
    private boolean canGetCentralDirectory;
    private static Field connectionHttpsDelegateField;
    private static Field connectionHttpField;

    private synchronized void lazyInit() {
        if (this.initialized) {
            return;
        }
        try {
            if (isJDK8.booleanValue()) {
                this.getCentralDirectory = ZipFile.class.getDeclaredMethod("getCentralDirectory", new Class[0]);
                this.getCentralDirectory.setAccessible(true);
            } else {
                this.res = ZipFile.class.getDeclaredField("res");
                this.res.setAccessible(true);
                this.cleanableResource = this.res.getType();
                this.zsrc = this.cleanableResource.getDeclaredField("zsrc");
                this.zsrc.setAccessible(true);
                this.source = this.zsrc.getType();
                this.cen = this.source.getDeclaredField("cen");
                this.cen.setAccessible(true);
            }
            this.canGetCentralDirectory = true;
        }
        catch (Throwable throwable) {
            this.res = null;
            this.cleanableResource = null;
            this.zsrc = null;
            this.source = null;
            this.cen = null;
            this.getCentralDirectory = null;
        }
        try {
            connectionHttpsDelegateField = HttpsURLConnectionImpl.class.getDeclaredField("delegate");
            connectionHttpsDelegateField.setAccessible(true);
            connectionHttpField = HttpURLConnection.class.getDeclaredField("http");
            connectionHttpField.setAccessible(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.initialized = true;
    }

    public byte[] getZipFileCentralDirectory(ZipFile zipFile) throws UnsupportedOperationException, IllegalAccessException, InvocationTargetException {
        this.lazyInit();
        if (!this.canGetCentralDirectory) {
            throw new IllegalStateException("initialization failure");
        }
        if (isJDK8.booleanValue()) {
            return (byte[])this.getCentralDirectory.invoke((Object)zipFile, new Object[0]);
        }
        Object object = this.res.get(zipFile);
        Object object2 = this.zsrc.get(object);
        return (byte[])this.cen.get(object2);
    }

    public boolean supportsGetZipCentralDirectory() {
        this.lazyInit();
        return this.canGetCentralDirectory;
    }

    public List<String> getDnsResolverSearchList() throws IllegalAccessError {
        ResolverConfiguration resolverConfiguration = ResolverConfiguration.open();
        return resolverConfiguration.searchlist();
    }

    public boolean isNotCachedHttpsURLConnection(HttpsURLConnection httpsURLConnection) {
        if (connectionHttpsDelegateField != null && connectionHttpField != null) {
            try {
                HttpClient httpClient = (HttpClient)connectionHttpField.get(connectionHttpsDelegateField.get(httpsURLConnection));
                if (!httpClient.isCachedConnection()) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public String getHostNameViaReflection() throws InternalError {
        try {
            Class<?> clazz = Class.forName("java.net.Inet4AddressImpl");
            Method method = clazz.getDeclaredMethod("getLocalHostName", new Class[0]);
            method.setAccessible(true);
            for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
                if (constructor.getParameterCount() != 0) continue;
                constructor.setAccessible(true);
                Object obj = constructor.newInstance(new Object[0]);
                Object object = method.invoke(obj, new Object[0]);
                if (object instanceof String) {
                    return (String)object;
                }
                throw new InternalError("internal error " + (object == null ? null : object.getClass()));
            }
        }
        catch (ReflectiveOperationException | SecurityException exception) {
            throw new InternalError(exception);
        }
        return null;
    }
}

