/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client;

import com.azul.crs.client.CRSException;
import com.azul.crs.client.Client;
import com.azul.crs.client.ConnectionManager;
import com.azul.crs.client.Inventory;
import com.azul.crs.client.JDKAccessor;
import com.azul.crs.client.Options;
import com.azul.crs.client.PerformanceMetrics;
import com.azul.crs.client.Result;
import com.azul.crs.client.Utils;
import com.azul.crs.client.models.VMEvent;
import com.azul.crs.client.service.CRSLogMonitor;
import com.azul.crs.client.service.ClassLoadMonitor;
import com.azul.crs.client.service.ClientService;
import com.azul.crs.client.service.HeartbeatService;
import com.azul.crs.client.service.JarLoadMonitor;
import com.azul.crs.client.util.DnsDetect;
import com.azul.crs.runtime.utils.TempFilesFactory;
import com.azul.crs.util.logging.Logger;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;

abstract class AgentBase {
    protected static final String AGENT_NAME = "Azul IC Agent";
    private static final String SM_RELATED_ERR_MSG = "Unable to initialize Azul IC Agent: not enough permissions - please check security settings and see the documentation for details.";
    JarLoadMonitor jarLoadMonitor;
    ClassLoadMonitor classLoadMonitor;
    HeartbeatService heartbeatService;
    Client client;
    private Thread agentStartupThread;
    private final Lock agentStartupThreadLock = new ReentrantLock();
    private long delayTermination;
    final Logger logger;
    final CRSLogMonitor crslogMonitor = new CRSLogMonitor();
    private static volatile Utils.Deadline deadline;

    AgentBase() {
        this.logger = Logger.getLogger(this.getClass());
        Logger.addOutputStream(new OutputStream(){

            @Override
            public void write(int n) throws IOException {
            }

            @Override
            public void write(byte[] byArray, int n, int n2) throws IOException {
                AgentBase.this.crslogMonitor.notifyCRSLogEntry(byArray, n, n2);
            }
        });
    }

    void init(String string, Predicate<Options> predicate) {
        try {
            long l = Utils.currentTimeCount();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> this.teardownAgent(l)));
            Options.read(string);
            Options.checkIntegrity(predicate);
            Options.dump(predicate);
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        catch (SecurityException securityException) {
            throw new SecurityException(SM_RELATED_ERR_MSG);
        }
    }

    void finishInit(JDKAccessor jDKAccessor) {
        PerformanceMetrics.init(jDKAccessor);
        this.delayTermination = Options.delayTermination.getLong();
        System.setProperty("com.azul.crs.instance.options.delayTermination", Long.toString(this.delayTermination));
        if ("on".equals(Options.mode.get())) {
            this.activateAgent(null);
        } else if (!"auto".equals(Options.mode.get())) {
            // empty if block
        }
    }

    private void activateAgent(String string) {
        block8: {
            if (this.hardstop()) {
                return;
            }
            this.agentStartupThreadLock.lock();
            try {
                if (this.agentStartupThread == null) {
                    this.agentStartupThread = new Thread(() -> this.startupAgent(string), "CRSStartThread");
                    this.agentStartupThread.setDaemon(true);
                    this.agentStartupThread.start();
                    break block8;
                }
                if (string == null) break block8;
                try {
                    this.agentStartupThread.join();
                }
                catch (InterruptedException interruptedException) {
                    Thread.interrupted();
                    this.agentStartupThreadLock.unlock();
                    return;
                }
                this.postMainMethodName(string);
            }
            finally {
                this.agentStartupThreadLock.unlock();
            }
        }
    }

    void startupAgent(String string) {
        long l = Utils.currentTimeMillis() - ManagementFactory.getRuntimeMXBean().getUptime();
        try {
            if (!this.startupSpecific0()) {
                return;
            }
            this.client = new Client(this.getClientProps(), new Client.ClientListener(){
                private boolean connectionEstablished = false;

                @Override
                public void authenticated() {
                    if (AgentBase.this.client.getVmId() != null) {
                        AgentBase.this.logger.info("Agent authenticated: vmId=%s", AgentBase.this.client.getVmId());
                        if (AgentBase.this.logger.isEnabled(Logger.Level.DEBUG)) {
                            AgentBase.this.logger.debug(" VM uptime %dms", ManagementFactory.getRuntimeMXBean().getUptime());
                        }
                        if (!this.connectionEstablished) {
                            AgentBase.this.client.connectionEstablished();
                        }
                        this.connectionEstablished = true;
                    } else {
                        AgentBase.this.disableCRS("Backend malfunction, invalid vmId received", null);
                    }
                }

                @Override
                public void syncFailed(Result<String[]> result) {
                    IOException iOException;
                    AgentBase.this.logger.error("Data synchronization to the CRS cloud has failed: %s", result.errorString());
                    if (result.hasException() && (iOException = result.getException()) instanceof CRSException && ((CRSException)iOException).isProtocolFailure()) {
                        AgentBase.this.disableCRS("Protocol failure", iOException);
                    }
                }
            });
            if (this.logger.isEnabled(Logger.Level.DEBUG)) {
                this.logger.debug("%s initialized. VM start timestamp %d, VM uptime %dms", AGENT_NAME, l, ManagementFactory.getRuntimeMXBean().getUptime());
            }
            this.postVMStart(l, string);
            this.heartbeatService = HeartbeatService.getInstance(this.client);
            this.crslogMonitor.setClient(this.client);
            this.classLoadMonitor = ClassLoadMonitor.getInstance(this.client);
            this.jarLoadMonitor = JarLoadMonitor.getInstance(this.client);
            this.jarLoadMonitor.setSendPOMProperties(Options.sendPOMData.isYes());
            this.jarLoadMonitor.setMaxJarFileCacheSize(1024L * Options.maxJarFileCacheSize.getLong());
            this.startServices(this.crslogMonitor, this.heartbeatService, this.classLoadMonitor, this.jarLoadMonitor);
            this.startupSpecific1(l);
            this.client.startup();
            this.postSystemInformation();
            this.startupSpecific2();
        }
        catch (Throwable throwable) {
            this.disableCRS("CRS failed to start: %s", throwable);
        }
    }

    public boolean isSupportedOption(Options options) {
        return true;
    }

    boolean startupSpecific0() {
        return true;
    }

    void startupSpecific1(long l) {
    }

    void startupSpecific2() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void teardownAgent(long l2) {
        try {
            Utils.Deadline deadline;
            AgentBase.deadline = deadline = Utils.Deadline.in(this.delayTermination, TimeUnit.MILLISECONDS);
            long l3 = Utils.currentTimeCount();
            this.logger.trace("checking if startup is complete and waiting for it to finish (%d ms)", this.delayTermination);
            this.teardownSpecific1(AgentBase.deadline);
            if (AgentBase.deadline.applyIfNotExpired(l -> this.agentStartupThreadLock.tryLock(l, TimeUnit.MILLISECONDS)).orElse(false).booleanValue()) {
                try {
                    if (this.agentStartupThread != null) {
                        AgentBase.deadline.runIfNotExpired(l -> this.agentStartupThread.join(l));
                    }
                }
                finally {
                    this.agentStartupThreadLock.unlock();
                }
            }
            this.teardownSpecific2(AgentBase.deadline);
            this.stopServices(deadline, this.heartbeatService, this.classLoadMonitor, this.jarLoadMonitor, this.crslogMonitor);
            if (this.client != null) {
                Map map = PerformanceMetrics.logPreShutdown(Utils.elapsedTimeMillis(l3));
                this.postVMShutdown(map);
                this.client.shutdown(deadline);
                if (this.client.getVmId() != null) {
                    PerformanceMetrics.logShutdown(Utils.elapsedTimeMillis(l3));
                    PerformanceMetrics.report();
                    this.logger.info("Agent terminated: vmId=%s, runningTime=%d", this.client.getVmId(), Utils.elapsedTimeMillis(l2));
                } else {
                    this.logger.info("Agent shut down during startup. Data is discarded. runningTime=%d", Utils.elapsedTimeMillis(l2));
                }
            }
            if (AgentBase.deadline.hasExpired()) {
                this.logger.warning("Agent exceeded delayTermination timeout. Some data might be unsent. Consider increasing delayTermination timeout.", new Object[0]);
            } else {
                this.logger.debug("Remaining delayTermination time: %dms", AgentBase.deadline.remainder(TimeUnit.MILLISECONDS));
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.interrupted();
            this.logger.error("%s shutdown was interrupted. Data is discarded.", AGENT_NAME);
        }
        catch (Throwable throwable) {
            this.logger.error("Internal error or unexpected problem occurred - %s is disabled.", AGENT_NAME);
            throwable.printStackTrace(System.err);
        }
        finally {
            try {
                TempFilesFactory.shutdown();
            }
            catch (Throwable throwable) {}
        }
    }

    void teardownSpecific1(Utils.Deadline deadline) throws InterruptedException {
    }

    void teardownSpecific2(Utils.Deadline deadline) {
    }

    private void postVMStart(long l, String string) throws Exception {
        Map<String, Object> map = new Inventory().populate(this.client.getEnvFilter(), this.client.getSysPropsFilter()).mainMethod(string).toMap();
        this.logger.trace("Post VM start to CRS service", new Object[0]);
        this.client.postVMStart(map, l);
    }

    private void postMainMethodName(String string) {
        Map<String, Object> map = new Inventory().mainMethod(string).toMap();
        this.client.patchInventory(map);
    }

    private void postSystemInformation() {
        Map<String, Object> map = new Inventory().systemInformation().toMap();
        this.client.patchInventory(map);
    }

    private void postVMShutdown(Map map) {
        this.logger.trace("Post VM shutdown to CRS service", new Object[0]);
        ArrayList<VMEvent> arrayList = new ArrayList<VMEvent>();
        arrayList.add(new VMEvent().eventType(VMEvent.Type.VM_PERFORMANCE_METRICS).randomEventId().eventTime(Utils.currentTimeMillis()).eventPayload(map));
        this.client.postVMShutdown(arrayList);
    }

    void startServices(ClientService ... clientServiceArray) {
        for (ClientService clientService : clientServiceArray) {
            if (clientService == null) continue;
            try {
                clientService.start();
            }
            catch (Exception exception) {
                this.logger.error("Agent failed to start " + clientService.serviceName() + ". Data is discarded", new Object[0]);
                exception.printStackTrace(System.err);
            }
        }
    }

    void stopServices(Utils.Deadline deadline, ClientService ... clientServiceArray) {
        for (ClientService clientService : clientServiceArray) {
            if (clientService == null) continue;
            try {
                clientService.stop(deadline);
            }
            catch (Exception exception) {
                this.logger.error("Agent failed to stop " + clientService.serviceName() + ". Data is discarded", new Object[0]);
                exception.printStackTrace(System.err);
            }
        }
    }

    synchronized void shutdownAgent() {
        if (this.client != null) {
            this.client.cancel();
        }
    }

    private void disableCRS(String string, Throwable throwable) {
        this.shutdownAgent();
        if (throwable == null) {
            this.logger.error(string, new Object[0]);
        } else {
            this.logger.error(string, throwable);
            if (throwable.getCause() != null) {
                this.logger.trace("caused by: %s", throwable.getCause());
            }
        }
    }

    private Map<Client.ClientProp, Object> getClientProps() throws CRSException {
        boolean bl;
        Map<Client.ClientProp, Object> map = Options.getClientProps();
        boolean bl2 = map.get((Object)Client.ClientProp.API_URL) != null;
        boolean bl3 = bl = map.get((Object)Client.ClientProp.API_MAILBOX) != null;
        if (!bl2 || !bl) {
            try {
                DnsDetect dnsDetect = new DnsDetect(Options.stackRecordId.get());
                Logger.getLogger(ConnectionManager.class).info("querying DNS record%s", dnsDetect.getRecordNamePostfix().length() > 0 ? " (postfix " + dnsDetect.getRecordNamePostfix() + ")" : "");
                if (!bl2) {
                    String string = dnsDetect.queryEndpoint();
                    if (string != null) {
                        map.put(Client.ClientProp.API_URL, "https://" + string);
                    } else {
                        throw new CRSException(-1);
                    }
                }
                if (!bl) {
                    map.put(Client.ClientProp.API_MAILBOX, dnsDetect.queryMailbox());
                }
            }
            catch (IOException iOException) {
                throw new CRSException(-1, "DNS query error and not enough configuration supplied", iOException);
            }
        }
        map.put(Client.ClientProp.VM_SHUTDOWN_DELAY, this.delayTermination);
        return map;
    }

    void mainMethodDetected(String string) {
        if (!string.startsWith("com/sun/tools")) {
            this.activateAgent(string);
        } else {
            this.shutdownAgent();
        }
    }

    boolean hardstop() {
        Utils.Deadline deadline = AgentBase.deadline;
        return deadline != null && deadline.hasExpired();
    }

    static enum VMCRSCapability {
        POST_CLASS_LOAD_EVENTS,
        POST_FIRST_CALL_EVENTS,
        POST_NOTIFY_TO_JAVA_CALLS,
        POST_VM_LOG_EVENTS,
        POST_JAR_LOAD_EVENTS,
        POST_VM_TOOLING_EVENT;

    }
}

