/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.util.async;

import com.azul.crs.client.Tweaks;
import com.azul.crs.client.util.async.AsyncResourceHandler;
import com.azul.crs.util.logging.Logger;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class AsyncPipeline<T> {
    private static final Logger logger = Logger.getLogger(AsyncPipeline.class);
    private AsyncResourceHandler<T> first = null;
    private AsyncResourceHandler<T> last = null;

    private AsyncPipeline() {
    }

    public static <T> AsyncPipeline<T> first(Supplier<T> supplier) {
        AsyncPipeline<T> asyncPipeline = new AsyncPipeline<T>();
        AsyncResourceHandler<T> asyncResourceHandler2 = new AsyncResourceHandler<T>(asyncPipeline);
        asyncResourceHandler2.allocator = asyncResourceHandler -> {
            assert (asyncResourceHandler.getObject() == null);
            asyncResourceHandler.next().accept(supplier.get());
            return asyncResourceHandler.next();
        };
        asyncPipeline.first = asyncResourceHandler2;
        asyncPipeline.last = asyncResourceHandler2;
        return asyncPipeline;
    }

    public AsyncPipeline<T> next(Function<AsyncPipeline<T>, Function<AsyncResourceHandler<T>, AsyncResourceHandler<T>>> function) {
        AsyncResourceHandler asyncResourceHandler = new AsyncResourceHandler(this);
        AsyncResourceHandler<T> asyncResourceHandler2 = this.last;
        asyncResourceHandler.allocator = function.apply(this);
        this.last = asyncResourceHandler;
        asyncResourceHandler.outer = asyncResourceHandler2;
        asyncResourceHandler2.inner = asyncResourceHandler;
        return this;
    }

    public AsyncPipeline<T> step(Consumer<AsyncResourceHandler<T>> consumer) {
        return this.next(asyncPipeline -> asyncResourceHandler -> {
            consumer.accept((AsyncResourceHandler)asyncResourceHandler);
            if (Tweaks.DEBUG_ASYNC_UTILS && asyncResourceHandler.errorHandler != null) {
                Consumer<Exception> consumer2 = asyncResourceHandler.errorHandler;
                asyncResourceHandler.errorHandler = exception -> {
                    logger.trace("errorHandler.accept(%s) context (%s)", exception, asyncResourceHandler.getObject());
                    consumer2.accept((Exception)exception);
                };
            }
            asyncResourceHandler.next().accept(asyncResourceHandler.getObject());
            return asyncResourceHandler.next();
        });
    }

    public void start() {
        this.next(asyncPipeline -> asyncResourceHandler -> {
            asyncResourceHandler.finalize();
            return null;
        });
        this.first.accept(null);
    }

    public void start(ExecutorService executorService) {
        this.next(asyncPipeline -> asyncResourceHandler -> {
            asyncResourceHandler.finalize();
            return null;
        });
        executorService.submit(() -> this.first.accept(null));
    }

    public static <T> Function<AsyncResourceHandler<T>, AsyncResourceHandler<T>> notNull(AsyncPipeline<T> asyncPipeline) {
        return asyncResourceHandler -> {
            if (asyncResourceHandler.getObject() == null) {
                asyncResourceHandler.finalize();
                return null;
            }
            asyncResourceHandler.next().accept(asyncResourceHandler.getObject());
            return asyncResourceHandler.next();
        };
    }
}

