/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.util;

import com.azul.crs.client.Tweaks;
import com.azul.crs.client.Utils;
import com.azul.crs.client.jars.JarAccess;
import com.azul.crs.jar.ZipTools;
import com.azul.crs.util.logging.Logger;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.concurrent.atomic.AtomicReference;

public class JarAccessUtils {
    private final ZipTools zt;
    private final MessageDigest digest;
    final Logger logger = Logger.getLogger(this.getClass());

    public JarAccessUtils(ZipTools zipTools, MessageDigest messageDigest) {
        this.zt = zipTools;
        this.digest = messageDigest;
    }

    public ZipTools.JarShortDigest calculateJarShortDigest(JarAccess jarAccess) {
        try {
            AtomicReference atomicReference = new AtomicReference();
            jarAccess.withInputStream(inputStream -> atomicReference.set(this.zt.getDigest((MessageDigest)this.digest.clone(), jarAccess.getURL(), jarAccess.getJarFile(), (InputStream)inputStream)));
            ZipTools.JarShortDigest jarShortDigest = (ZipTools.JarShortDigest)atomicReference.get();
            this.logger.trace("jar central directory signature calculated jar=%s, url=%s, digest=%s", jarAccess.getJarFile(), jarAccess.getURL(), jarShortDigest);
            if (jarShortDigest == null) {
                return null;
            }
            if (Tweaks.DEBUG_JARLOAD && Tweaks.TRACE_CD_CONTENT) {
                System.out.println(">>> notifyJarLoad url=" + jarAccess.getURL() + "\njar=" + jarAccess.getJarFile() + "\ncentralDirectoryHashString=" + Utils.encodeToStringOrNull(jarShortDigest.getCentralDirectoryHash()) + "\nmanifestHashString=" + Utils.encodeToStringOrNull(jarShortDigest.getManifestHash()));
            }
            return jarShortDigest;
        }
        catch (Exception exception) {
            this.logger.trace("Failed to calculate jar digest, due to exception=%s", exception);
            throw new RuntimeException(exception);
        }
    }
}

