/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.jars;

import com.azul.crs.client.util.ThrowingBiConsumer;
import com.azul.crs.client.util.ThrowingConsumer;
import java.util.concurrent.atomic.AtomicInteger;

public class CountdownRunnable<T, E extends Exception, E2 extends Exception> {
    private final ThrowingConsumer<T, E2> onSuccess;
    private final ThrowingBiConsumer<T, E, E2> onError;
    private final AtomicInteger countdown;
    private volatile E exception = null;

    public CountdownRunnable(int n, ThrowingConsumer<T, E2> throwingConsumer, ThrowingBiConsumer<T, E, E2> throwingBiConsumer) {
        this.onSuccess = throwingConsumer;
        this.onError = throwingBiConsumer;
        this.countdown = new AtomicInteger(n);
    }

    public void cancel(T t, E e) throws E2 {
        this.exception = e;
        this.runOrDecrement(t);
    }

    public void runOrDecrement(T t) throws E2 {
        if (this.exception != null) {
            this.onError.accept(t, this.exception);
            return;
        }
        if (this.countdown.decrementAndGet() == 0) {
            this.onSuccess.accept(t);
        }
    }

    public ThrowingBiConsumer<T, E, E2> getOnError() {
        return this.onError;
    }
}

