/*
 * Decompiled with CFR 0.152.
 */
package com.azul.tooling.in;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;

public final class Tooling {
    private static final ToolingHandler handler = AccessController.doPrivileged(new PrivilegedAction<ToolingHandler>(){

        @Override
        public ToolingHandler run() {
            ToolingHandler toolingHandler = null;
            try {
                Class<?> clazz = Class.forName("com.azul.tooling.Handler", true, Tooling.class.getClassLoader());
                Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                toolingHandler = (ToolingHandler)constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return toolingHandler;
        }
    });

    static boolean isEventTypeEnabled(Class<? extends ToolingEvent> clazz) {
        return handler != null && handler.isEventTypeEnabled(clazz);
    }

    public static void notifyEvent(ToolingEvent toolingEvent) {
        if (toolingEvent.isEventEnabled()) {
            handler.notifyEvent(toolingEvent);
        }
    }

    public static boolean isImplemented() {
        return handler != null;
    }

    public static interface ToolingHandler {
        public boolean isEventTypeEnabled(Class<? extends ToolingEvent> var1);

        public void notifyEvent(ToolingEvent var1);
    }

    public static interface ToolingEvent {
        public boolean isEventEnabled();
    }
}

