/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.util.logging;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;

public final class Logger {
    private static final String REGISTRY = "META-INF/crslog.channels.cfg";
    private static final Map<String, Logger> TAG_TO_LOGGER = new HashMap<String, Logger>();
    private static final Map<String, String> CLASS_TO_TAG = new HashMap<String, String>();
    private static boolean registryLoaded = false;
    private static final List<PrintWriter> writers = new CopyOnWriteArrayList<PrintWriter>();
    private static final long vmStartTime = System.currentTimeMillis() - ManagementFactory.getRuntimeMXBean().getUptime();
    private static Level globalLevel = Level.ERROR;
    private static boolean globalShowStacktrace = false;
    private static boolean globalShowTimestamp = false;
    private final String tag;
    private final Level lowestUpstreamLevel;
    private Level level = null;
    private Boolean showStacktrace = null;
    private static Logger defaultLogger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void readRegistry() {
        if (registryLoaded) {
            return;
        }
        String string = Logger.class.getName().replace(".util.logging.Logger", "");
        int n = string.length();
        boolean bl = n > 12;
        try {
            HashSet<URL> hashSet = new HashSet<URL>();
            ClassLoader classLoader = Logger.class.getClassLoader();
            if (classLoader != null) {
                hashSet.addAll(Collections.list(classLoader.getResources(REGISTRY)));
            }
            hashSet.addAll(Collections.list(ClassLoader.getSystemResources(REGISTRY)));
            for (URL uRL : hashSet) {
                Properties properties = new Properties();
                InputStream inputStream = uRL.openStream();
                Throwable throwable = null;
                try {
                    properties.load(inputStream);
                    Enumeration<?> enumeration = properties.propertyNames();
                    while (enumeration.hasMoreElements()) {
                        String string2;
                        String string3 = enumeration.nextElement().toString();
                        String string4 = properties.getProperty(string3);
                        Level level = Level.DEBUG;
                        int n2 = string4.lastIndexOf(58);
                        if (n2 > 0) {
                            string2 = string4.substring(0, n2);
                            level = Level.valueOf(string4.substring(n2 + 1));
                        } else {
                            string2 = string4;
                        }
                        TAG_TO_LOGGER.put(string2, new Logger(string2, level));
                        if (bl) {
                            string3 = string + string3.substring(12);
                        }
                        CLASS_TO_TAG.put(string3, string2);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
        }
        catch (Throwable throwable) {
            java.util.logging.Logger.getLogger(Logger.class.getName()).log(java.util.logging.Level.SEVERE, null, throwable);
        }
        finally {
            registryLoaded = true;
        }
    }

    static void reset() {
        CLASS_TO_TAG.clear();
        TAG_TO_LOGGER.clear();
        globalLevel = Level.ERROR;
        globalShowStacktrace = false;
        globalShowTimestamp = false;
        registryLoaded = false;
    }

    private Logger(String string, Level level) {
        this.tag = string;
        this.lowestUpstreamLevel = level;
    }

    private static Logger loggerForTag(String string) {
        return TAG_TO_LOGGER.get(string);
    }

    public static void addOutputStream(OutputStream outputStream) {
        writers.add(new PrintWriter(outputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Logger getDefaultLogger() {
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            if (defaultLogger == null) {
                defaultLogger = new Logger("default", Level.TRACE);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultLogger;
        }
    }

    public static Logger getLogger(Class clazz) {
        String string = clazz.getCanonicalName();
        String string2 = CLASS_TO_TAG.get(string);
        if (string2 == null) {
            Logger.readRegistry();
            string2 = CLASS_TO_TAG.get(string);
        }
        return string2 == null ? Logger.getDefaultLogger() : Logger.loggerForTag(string2);
    }

    public static void parseOption(String string, String string2) {
        Level level;
        Logger.readRegistry();
        boolean bl = false;
        boolean bl2 = false;
        while (true) {
            int n;
            if (string2.endsWith("+stack")) {
                bl = true;
                n = 6;
            } else {
                if (!string2.endsWith("+time")) break;
                bl2 = true;
                n = 5;
            }
            string2 = string2.substring(0, string2.length() - n);
        }
        try {
            level = Level.valueOf(string2.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("[CRS.log][error] unsupported log level '" + string2 + "'");
            return;
        }
        if (string.equals("log")) {
            globalLevel = level;
            globalShowStacktrace = bl;
        } else if (string.startsWith("log+")) {
            String string3 = string.substring(4);
            if (!"vm".equals(string3)) {
                Logger logger = Logger.loggerForTag(string3);
                if (logger != null) {
                    logger.setLevel(level).setShowStacktrace(bl);
                } else {
                    System.err.println("[CRS.log][error] unknown CRS log channel " + string.substring(4));
                }
            }
        } else {
            System.err.println("[CRS.log][error] unknown CRS log option " + string);
            return;
        }
        if (bl2 && !globalShowTimestamp) {
            globalShowTimestamp = true;
        }
    }

    private boolean isLogLevelEnabled(Level level) {
        return this.getLevel().ordinal() <= level.ordinal();
    }

    private boolean isUpsreamLevelEnabled(Level level) {
        return this.lowestUpstreamLevel.ordinal() <= level.ordinal();
    }

    public boolean isEnabled(Level level) {
        if (this.getLevel().equals((Object)Level.OFF)) {
            return false;
        }
        return !writers.isEmpty() || this.isLogLevelEnabled(level);
    }

    private Logger setLevel(Level level) {
        this.level = level;
        return this;
    }

    private Logger setShowStacktrace(boolean bl) {
        this.showStacktrace = bl;
        return this;
    }

    boolean showStacktrace() {
        return this.showStacktrace == null ? globalShowStacktrace : this.showStacktrace;
    }

    boolean showTimestamp() {
        return globalShowTimestamp;
    }

    public Level getLevel() {
        return this.level == null ? globalLevel : this.level;
    }

    public void trace(String string, Object ... objectArray) {
        this.log(Level.TRACE, string, objectArray);
    }

    public void debug(String string, Object ... objectArray) {
        this.log(Level.DEBUG, string, objectArray);
    }

    public void info(String string, Object ... objectArray) {
        this.log(Level.INFO, string, objectArray);
    }

    public void warning(String string, Object ... objectArray) {
        this.log(Level.WARNING, string, objectArray);
    }

    public void error(String string, Object ... objectArray) {
        this.log(Level.ERROR, string, objectArray);
    }

    public void log(Level level, String string, Object ... objectArray) {
        try {
            boolean bl = this.isLogLevelEnabled(level);
            boolean bl2 = this.isUpsreamLevelEnabled(level);
            if (!bl2 && !bl) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (this.showTimestamp()) {
                stringBuilder.append(this.elapsedTime());
            }
            stringBuilder.append("[CRS.").append(this.tag).append("][").append(level.n).append("] ");
            if (this.getLevel() == Level.TRACE) {
                Throwable throwable = new Throwable();
                StackTraceElement object = throwable.getStackTrace()[2];
                stringBuilder.append(object.getClassName()).append('.').append(object.getMethodName()).append(": ");
            }
            if (bl) {
                this.logDecoratedLines(new PrintWriter(System.err), stringBuilder, string, objectArray);
            }
            if (bl2) {
                if (!this.showTimestamp()) {
                    stringBuilder.insert(0, this.elapsedTime());
                }
                for (PrintWriter printWriter : writers) {
                    this.logDecoratedLines(printWriter, stringBuilder, string, objectArray);
                }
            }
        }
        catch (Throwable throwable) {
            java.util.logging.Logger.getLogger(Logger.class.getName()).log(java.util.logging.Level.SEVERE, null, throwable);
        }
    }

    private CharSequence elapsedTime() {
        long l = System.currentTimeMillis() - vmStartTime;
        long l2 = l / 1000L;
        long l3 = l % 1000L;
        CharSequence charSequence = Long.toString(1000L + l3).subSequence(1, 4);
        return l2 + "." + charSequence + ": ";
    }

    private void logDecoratedLines(PrintWriter printWriter, StringBuilder stringBuilder, String string, Object ... objectArray) {
        printWriter.append(stringBuilder);
        for (char c : String.format(string, objectArray).toCharArray()) {
            printWriter.append(c);
            if (c != '\n') continue;
            printWriter.append(stringBuilder);
        }
        printWriter.println();
        if (this.showStacktrace()) {
            for (Object object : objectArray) {
                if (!(object instanceof Throwable)) continue;
                ((Throwable)object).printStackTrace(printWriter);
            }
        }
        printWriter.flush();
    }

    public static enum Level {
        TRACE,
        DEBUG,
        INFO,
        WARNING,
        ERROR,
        OFF;

        private final String n = this.name().toLowerCase();
    }
}

