/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.jfr.access;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicReference;
import jdk.jfr.FlightRecorder;
import jdk.jfr.Recording;
import jdk.jfr.internal.FlightRecorderAssociate;
import jdk.jfr.internal.SecuritySupport;

public final class FlightRecorderAccess {
    private static final AccessException initException;
    private static final Method chunkUseMethod;
    private static final Method chunkReleaseMethod;
    private static final Method recorderSetAssociateMethod;

    private FlightRecorderAccess() {
    }

    public void useRepositoryChunk(Object object) throws AccessException {
        try {
            chunkUseMethod.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            throw new AccessException(exception);
        }
    }

    public void releaseRepositoryChunk(Object object) throws AccessException {
        try {
            chunkReleaseMethod.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            throw new AccessException(exception);
        }
    }

    public static FlightRecorderAccess getAccess(FlightRecorder flightRecorder, final FlightRecorderCallbacks flightRecorderCallbacks) throws AccessException {
        if (initException != null) {
            throw initException;
        }
        try {
            recorderSetAssociateMethod.invoke((Object)flightRecorder, new FlightRecorderAssociate(){

                public void nextChunk(Object object, SecuritySupport.SafePath safePath, Instant instant, Instant instant2, long l, Recording recording) {
                    flightRecorderCallbacks.nextChunk(object, safePath.toPath(), instant, instant2, l, recording);
                }

                public void finishJoin() {
                    flightRecorderCallbacks.finishJoin();
                }
            });
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            throw new AccessException(exception);
        }
        return new FlightRecorderAccess();
    }

    static {
        final AtomicReference atomicReference = new AtomicReference();
        final AtomicReference atomicReference2 = new AtomicReference();
        final AtomicReference atomicReference3 = new AtomicReference();
        final AtomicReference atomicReference4 = new AtomicReference();
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    Method method = FlightRecorder.class.getDeclaredMethod("setAssociate", FlightRecorderAssociate.class);
                    method.setAccessible(true);
                    atomicReference4.set(method);
                    Class<?> clazz = Class.forName("jdk.jfr.internal.RepositoryChunk");
                    method = clazz.getDeclaredMethod("use", new Class[0]);
                    method.setAccessible(true);
                    atomicReference2.set(method);
                    method = clazz.getDeclaredMethod("release", new Class[0]);
                    method.setAccessible(true);
                    atomicReference3.set(method);
                }
                catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
                    atomicReference.set(new AccessException(reflectiveOperationException));
                }
                return null;
            }
        });
        initException = (AccessException)atomicReference.get();
        chunkUseMethod = (Method)atomicReference2.get();
        chunkReleaseMethod = (Method)atomicReference3.get();
        recorderSetAssociateMethod = (Method)atomicReference4.get();
    }

    public static final class AccessException
    extends Exception {
        private static final long serialVersionUID = -3710493080622598156L;

        private AccessException(Throwable throwable) {
            super(throwable);
        }
    }

    public static interface FlightRecorderCallbacks {
        public void nextChunk(Object var1, Path var2, Instant var3, Instant var4, long var5, Recording var7);

        public void finishJoin();
    }
}

