/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.sysinfo;

import com.azul.crs.client.sysinfo.LinuxSystemInfoProvider;
import com.azul.crs.client.sysinfo.MacOSXSystemInfoProvider;
import com.azul.crs.util.logging.Logger;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class SystemInfoProvider {
    private static SoftReference<SystemInfoProviderImpl> providerRef = new SoftReference<Object>(null);
    private static final OS OS = SystemInfoProvider.getOS();
    private static final CPUID[] SKX102_AffectedCPUs = new CPUID[]{new CPUID(6, 78, 3, 212L), new CPUID(6, 85, 4, 33554532L), new CPUID(6, 85, 7, 83886123L), new CPUID(6, 94, 3, 212L), new CPUID(6, 142, 9, 198L), new CPUID(6, 142, 10, 198L), new CPUID(6, 142, 11, 198L), new CPUID(6, 142, 12, 198L), new CPUID(6, 158, 9, 198L), new CPUID(6, 158, 10, 198L), new CPUID(6, 158, 11, 198L), new CPUID(6, 158, 13, 198L), new CPUID(6, 166, 0, 198L)};

    private SystemInfoProvider() {
    }

    private static OS getOS() {
        String string = System.getProperty("os.name");
        if (string != null) {
            if ((string = string.toLowerCase()).startsWith("linux")) {
                return com.azul.crs.client.sysinfo.SystemInfoProvider$OS.Linux;
            }
            if (string.startsWith("mac")) {
                return com.azul.crs.client.sysinfo.SystemInfoProvider$OS.MacOSX;
            }
        }
        return null;
    }

    private static SystemInfoProviderImpl getInfoProvider() {
        if (OS == null) {
            return new DummyInfoProvider();
        }
        SystemInfoProviderImpl systemInfoProviderImpl = providerRef.get();
        if (systemInfoProviderImpl == null) {
            switch (OS) {
                case Linux: {
                    systemInfoProviderImpl = new LinuxSystemInfoProvider();
                    break;
                }
                case MacOSX: {
                    systemInfoProviderImpl = new MacOSXSystemInfoProvider();
                    break;
                }
                default: {
                    return new DummyInfoProvider();
                }
            }
            try {
                assert (systemInfoProviderImpl != null);
                systemInfoProviderImpl.initialize();
            }
            catch (IOException | InterruptedException exception) {
                Logger.getLogger(SystemInfoProvider.class).error("Cannot get provider: %s", exception);
            }
            providerRef = new SoftReference<SystemInfoProviderImpl>(systemInfoProviderImpl);
        }
        return systemInfoProviderImpl;
    }

    public static Map<String, Object> getAllProperties() {
        return Collections.unmodifiableMap(SystemInfoProvider.getInfoProvider().getRawProperties());
    }

    public static Map<String, Object> getCPUInfo() {
        return Collections.unmodifiableMap(SystemInfoProvider.getInfoProvider().cpuProps);
    }

    public static Map<String, Object> getMemInfo() {
        return Collections.unmodifiableMap(SystemInfoProvider.getInfoProvider().memProps);
    }

    public static Map<String, Object> getOSInfo() {
        return Collections.unmodifiableMap(SystemInfoProvider.getInfoProvider().osProps);
    }

    private static class DummyInfoProvider
    extends SystemInfoProviderImpl {
        private DummyInfoProvider() {
        }

        @Override
        protected void initProps() throws IOException, InterruptedException {
        }
    }

    static abstract class SystemInfoProviderImpl {
        protected final SystemProperties<String> machdepProps = new SystemProperties();
        protected final SystemProperties<CPUInfoKey> cpuProps = new SystemProperties();
        protected final SystemProperties<MemInfoKey> memProps = new SystemProperties();
        protected final SystemProperties<OSInfoKey> osProps = new SystemProperties();

        SystemInfoProviderImpl() {
        }

        private SystemProperties getRawProperties() {
            return this.machdepProps;
        }

        final void initialize() throws IOException, InterruptedException {
            this.initProps();
            this.cpuProps.set(CPUInfoKey.ASSIGNED_LOGICAL_CORE_COUNT, Runtime.getRuntime().availableProcessors());
        }

        protected abstract void initProps() throws IOException, InterruptedException;

        protected final int parseIntOrZero(String string) {
            return string.length() > 0 ? Integer.parseInt(string) : 0;
        }

        protected static class SystemProperties<T>
        extends HashMap<String, Object> {
            public void set(T t, Object object) {
                super.put(t.toString(), object);
            }

            @Override
            public Object put(String string, Object object) {
                throw new InternalError("Should not call");
            }

            @Override
            public Object get(Object object) {
                return super.getOrDefault(object.toString(), "");
            }

            public int intValue(T t) {
                Object object = this.get(t.toString());
                try {
                    return Integer.decode(object.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    return -1;
                }
            }

            public long longValue(T t) {
                Object object = this.get(t.toString());
                try {
                    return Long.decode(object.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    return -1L;
                }
            }

            public String strValue(T t) {
                return this.get(t.toString()).toString();
            }

            void filter(String ... stringArray) {
                Iterator iterator = super.keySet().iterator();
                block0: while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    for (String string2 : stringArray) {
                        if (string.startsWith(string2)) continue block0;
                    }
                    iterator.remove();
                }
            }
        }
    }

    private static final class CPUID {
        int cpu_family;
        int model;
        int stepping;
        long microcode;

        public CPUID(int n, int n2, int n3, long l) {
            this.cpu_family = n;
            this.model = n2;
            this.stepping = n3;
            this.microcode = l;
        }
    }

    public static enum OSInfoKey {
        NAME("OS Name"),
        VERSION("OS Version"),
        ARCH("OS Arch");

        private final String key;

        private OSInfoKey(String string2) {
            this.key = string2;
        }

        public String toString() {
            return this.key;
        }
    }

    public static enum MemInfoKey {
        SYSTEM_RAM_MAX_GB("System RAM max, GB");

        private final String key;

        private MemInfoKey(String string2) {
            this.key = string2;
        }

        public String toString() {
            return this.key;
        }
    }

    public static enum CPUInfoKey {
        PACKAGE_COUNT("Number of CPU Packages"),
        PHYSICAL_CORE_COUNT("Number of Physical Cores"),
        PROCESSOR_COUNT("Number of Processors"),
        ASSIGNED_LOGICAL_CORE_COUNT("Number of Assigned Logical Cores"),
        VENDOR("CPU Vendor"),
        MODEL_NAME("CPU Model Name"),
        FAMILY("CPU Family"),
        MODEL("CPU Model"),
        STEPPING("CPU Stepping"),
        MICROCODE("CPU Microcode"),
        CACHE_SIZE_L1I("Cache Size L1i"),
        CACHE_SIZE_L1D("Cache Size L1d"),
        CACHE_SIZE_L2("Cache Size L2"),
        CACHE_SIZE_L3("Cache Size L3"),
        FREQUENCY("Frequency, Hz"),
        FREQUENCY_MAX("Frequency Max, Hz"),
        FREQUENCY_MIN("Frequency Min, Hz"),
        TSC("Time Stamp Counter"),
        FLAGS("CPU flags"),
        SKX102_AFFECTED("Affected by MCU Erratum SKX102");

        private final String key;

        private CPUInfoKey(String string2) {
            this.key = string2;
        }

        public String toString() {
            return this.key;
        }
    }

    public static enum OS {
        Linux,
        MacOSX;

    }
}

