/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.service;

import com.azul.crs.client.PerformanceMetrics;
import com.azul.crs.client.Utils;
import com.azul.crs.client.service.ClientService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class QueueService<T>
implements ClientService {
    private static final int DEFAULT_MAX_SEND_DELAY = 5000;
    private static final int DEFAULT_MAX_QUEUE_SIZE = 5000;
    private static final int DEFAULT_MAX_WORKERS = 3;
    private static final int DEFAULT_MAX_BATCH_SIZE = 1000;
    private static final long DEFAULT_ADD_TIMEOUT = 500L;
    private final BlockingQueue<Object> queue;
    private final List<WorkerThread> workerThreads;
    private final AtomicReference<Utils.Deadline> stopDeadline = new AtomicReference();
    private volatile boolean stopAcceptingItems;
    private final int maxQueueSize;
    private final int maxWorkers;
    private final int maxBatchSize;
    private final long addTimeout;
    private final long maxSendDelay;
    private final ProcessBatch<T> processBatch;
    private final String name;
    private final AtomicInteger recursionCounter = new AtomicInteger();

    private QueueService(int n, int n2, int n3, long l, long l2, ProcessBatch<T> processBatch, String string) {
        this.maxQueueSize = n;
        this.maxWorkers = n2;
        this.maxBatchSize = n3;
        this.addTimeout = l;
        this.maxSendDelay = l2;
        this.processBatch = processBatch;
        this.queue = new LinkedBlockingDeque<Object>(n);
        this.workerThreads = new LinkedList<WorkerThread>();
        this.name = string;
    }

    @Override
    public String serviceName() {
        return ClientService.super.serviceName() + " [" + this.name + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        List<WorkerThread> list = this.workerThreads;
        synchronized (list) {
            if (this.stopDeadline.get() != null) {
                return;
            }
            if (!this.workerThreads.isEmpty()) {
                throw new IllegalStateException(this.serviceName() + " has been started already");
            }
            for (int i = 0; i < this.maxWorkers; ++i) {
                WorkerThread workerThread = new WorkerThread(String.valueOf(i));
                this.workerThreads.add(workerThread);
                workerThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(Utils.Deadline deadline) {
        if (deadline == null) {
            throw new NullPointerException();
        }
        if (this.stopDeadline.compareAndSet(null, deadline)) {
            int n;
            List list = this.workerThreads;
            synchronized (list) {
                this.sync(true);
                this.workerThreads.forEach(workerThread -> ((WorkerThread)workerThread).join(deadline));
            }
            this.stopAcceptingItems = true;
            list = this.workerThreads.stream().findAny().map(workerThread -> ((WorkerThread)workerThread).batch).orElseGet(ArrayList::new);
            while (!deadline.hasExpired() && !this.queue.isEmpty() && (n = this.queue.drainTo(list, this.maxBatchSize)) != 0) {
                this.processBatch.process("main", list);
                list.clear();
            }
            if (!this.queue.isEmpty()) {
                this.logger().debug("UNSENT DATA AFTER TERMINATION:  %d  items not send. You may want to increase delayTermination.", this.queue.size());
            }
        }
    }

    public void cancel() {
        this.stop(Utils.Deadline.in(0L, TimeUnit.MILLISECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(T t) {
        Utils.Deadline deadline = this.stopDeadline.get();
        if (deadline != null && this.stopAcceptingItems) {
            return false;
        }
        long l = deadline == null ? this.addTimeout : deadline.remainder(TimeUnit.MILLISECONDS);
        try {
            if (this.queue.offer(t, l, TimeUnit.MILLISECONDS)) {
                boolean bl = true;
                return bl;
            }
            try {
                if (this.recursionCounter.getAndIncrement() == 0) {
                    this.logger().error(String.format("QueueService %s: failed to enqueue an item. queueSize=%d, maxQueueSize=%d, timeout=%d, item=%s", this.name, this.queue.size(), this.maxQueueSize, l, t), new Object[0]);
                }
            }
            finally {
                this.recursionCounter.decrementAndGet();
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.interrupted();
        }
        finally {
            PerformanceMetrics.logEventQueueLength(this.queue.size());
        }
        PerformanceMetrics.logSkippedSendingEvent();
        return false;
    }

    public void sync() {
        this.sync(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sync(boolean bl) {
        List<WorkerThread> list = this.workerThreads;
        synchronized (list) {
            Marker marker = new Marker(this.workerThreads.size(), bl);
            try {
                for (WorkerThread workerThread : this.workerThreads) {
                    this.queue.put(marker);
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.interrupted();
            }
        }
    }

    private static final class Marker
    extends CountDownLatch {
        private final boolean stop;

        public Marker(int n, boolean bl) {
            super(n);
            this.stop = bl;
        }
    }

    private final class WorkerThread
    extends Thread {
        private final String id;
        private final List<T> batch;

        public WorkerThread(String string) {
            super("CRSQW-" + QueueService.this.name + string);
            this.batch = new ArrayList(QueueService.this.maxBatchSize);
            this.setDaemon(true);
            this.id = string;
        }

        @Override
        public void run() {
            Utils.Deadline deadline = Utils.Deadline.in(QueueService.this.maxSendDelay, TimeUnit.MILLISECONDS);
            block6: while (true) {
                try {
                    while (true) {
                        boolean bl;
                        Object e;
                        try {
                            e = QueueService.this.queue.poll(deadline.remainder(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.interrupted();
                            e = null;
                        }
                        if (e instanceof Marker) {
                            Marker marker = (Marker)e;
                            marker.countDown();
                            this.postBatch();
                            if (marker.stop) break block6;
                            try {
                                marker.await();
                                continue block6;
                            }
                            catch (InterruptedException interruptedException) {
                                Thread.interrupted();
                                continue;
                            }
                        }
                        if (e != null) {
                            this.batch.add(e);
                        }
                        if ((bl = deadline.hasExpired()) || this.batch.size() == QueueService.this.maxBatchSize) {
                            this.postBatch();
                        }
                        if (!bl) continue;
                        deadline = Utils.Deadline.in(QueueService.this.maxSendDelay, TimeUnit.MILLISECONDS);
                    }
                }
                catch (Throwable throwable) {
                    QueueService.this.logger().error("QueueService Worker [%s:%s] - internal error or unexpected problem. %s", QueueService.this.name, this.id, throwable);
                    continue;
                }
                break;
            }
            QueueService.this.logger().debug("QueueService Worker [%s:%s] has exited", QueueService.this.name, this.id);
        }

        private void postBatch() {
            if (!this.batch.isEmpty()) {
                QueueService.this.processBatch.process(this.id, this.batch);
                this.batch.clear();
            }
        }

        private void join(Utils.Deadline deadline) {
            try {
                this.join(Math.max(1L, deadline.remainder(TimeUnit.MILLISECONDS)));
            }
            catch (InterruptedException interruptedException) {
                Thread.interrupted();
            }
        }
    }

    public static class Builder<T> {
        private int maxQueueSize = 5000;
        private int maxWorkers = 3;
        private int maxBatchSize = 1000;
        private long addTimeout = 500L;
        private long maxSendDelay = 5000L;
        private ProcessBatch<T> processBatch;
        private String name = "<unnamed>";

        public Builder<T> maxQueueSize(int n) {
            this.maxQueueSize = n;
            return this;
        }

        public Builder<T> maxWorkers(int n) {
            this.maxWorkers = n;
            return this;
        }

        public Builder<T> maxBatchSize(int n) {
            this.maxBatchSize = n;
            return this;
        }

        public Builder<T> addTimeout(long l, TimeUnit timeUnit) {
            this.addTimeout = timeUnit.toMillis(l);
            return this;
        }

        public Builder<T> maxSendDelay(long l, TimeUnit timeUnit) {
            this.maxSendDelay = timeUnit.toMillis(l);
            return this;
        }

        public Builder<T> processBatch(ProcessBatch<T> processBatch) {
            this.processBatch = processBatch;
            return this;
        }

        public Builder<T> name(String string) {
            this.name = string;
            return this;
        }

        private void notNull(Object object) {
            object.getClass();
        }

        QueueService<T> build() {
            this.notNull(this.processBatch);
            return new QueueService(this.maxQueueSize, this.maxWorkers, this.maxBatchSize, this.addTimeout, this.maxSendDelay, this.processBatch, this.name);
        }
    }

    public static interface ProcessBatch<T> {
        public void process(String var1, Collection<T> var2);
    }
}

