/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.service;

import com.azul.crs.client.Client;
import com.azul.crs.client.ConnectionManager;
import com.azul.crs.client.Response;
import com.azul.crs.client.Tweaks;
import com.azul.crs.client.Utils;
import com.azul.crs.client.models.VMEvent;
import com.azul.crs.client.service.ClientService;
import com.azul.crs.client.service.QueueService;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Collectors;

public class EventService
implements ClientService {
    private final Client client;
    private final QueueService<VMEvent> queue;

    private EventService(Client client) {
        this.client = client;
        this.queue = new QueueService.Builder().maxQueueSize(Tweaks.MAX_QUEUE_SIZE).maxBatchSize(Tweaks.BATCH_SIZE).maxWorkers(Tweaks.MAX_WORKERS).processBatch(this::postWithRetries).name("EVENT").build();
    }

    public static EventService getInstance(Client client) {
        return new EventService(client);
    }

    public void add(VMEvent vMEvent) {
        VMEvent.Type type = vMEvent.getEventType();
        int n = type.incrementInFlightEventsCount();
        boolean bl = this.queue.add(vMEvent);
        if (!bl) {
            n = type.subtractInFlightEventsCount(1);
        }
        if (Tweaks.DEBUG_EVENT_SERVICE) {
            this.logger().trace("Queue %s: Event of type %s %s added. [InFlightEventsCount=%d]", new Object[]{this.queue.serviceName(), type, bl ? "was" : "was not", n});
        }
    }

    public void addAll(Collection<VMEvent> collection) {
        collection.forEach(this::add);
    }

    @Override
    public String serviceName() {
        return "client.service.Events";
    }

    @Override
    public void start() {
    }

    @Override
    public void stop(Utils.Deadline deadline) {
        this.queue.stop(deadline);
    }

    public void cancel() {
        this.queue.cancel();
    }

    public void connectionEstablished() {
        this.queue.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postWithRetries(String string, Collection<VMEvent> collection) {
        this.logger().trace("event worker tries to post batch of %,d VM events", collection.size());
        boolean bl = false;
        try {
            Iterator<VMEvent> iterator = this.client.getConnectionManager();
            bl = ((ConnectionManager)((Object)iterator)).requestWithRetries(() -> EventService.lambda$postWithRetries$0((ConnectionManager)((Object)iterator), collection), "postEventBatch", Tweaks.EVENT_MAX_RETRIES, Tweaks.EVENT_RETRY_SLEEP);
        }
        finally {
            collection.stream().collect(Collectors.groupingBy(vMEvent -> vMEvent.getEventType(), Collectors.counting())).forEach((type, l) -> type.subtractInFlightEventsCount(l.intValue()));
            if (bl) {
                for (VMEvent vMEvent2 : collection) {
                    vMEvent2.callOnSuccess();
                }
            } else {
                for (VMEvent vMEvent3 : collection) {
                    vMEvent3.callOnError();
                }
            }
        }
    }

    private static /* synthetic */ Response lambda$postWithRetries$0(ConnectionManager connectionManager, Collection collection) throws IOException {
        return connectionManager.sendVMEventBatch(collection);
    }
}

