/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.jars;

import com.azul.crs.util.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarFile;
import sun.net.www.protocol.jar.JarURLConnection;

public class JarFileFactory {
    private static final Logger logger = Logger.getLogger(JarFileFactory.class);

    private static boolean isLocalFile(URL uRL) {
        try {
            URL uRL2 = JarFileFactory.sanitizeURL(uRL);
            if (uRL2 == null) {
                return false;
            }
            File file = new File(uRL2.toURI());
            return file.isFile() && file.canRead();
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    public static JarFileDescriptor createJarFile(URL uRL) throws IOException {
        if (uRL.getProtocol().startsWith("http")) {
            return JarFileFactory.createJarFileFromHttp(uRL);
        }
        if (uRL.getProtocol().equals("jar")) {
            if (JarFileFactory.isLocalFile(uRL)) {
                return JarFileFactory.createJarFileFromFile(uRL);
            }
            return JarFileFactory.createJarFileFromJar(uRL);
        }
        return JarFileFactory.createJarFileFromFile(uRL);
    }

    private static JarFileDescriptor createJarFileFromJar(URL uRL) throws IOException {
        if (!uRL.getPath().endsWith(".jar!/")) {
            return null;
        }
        URLConnection uRLConnection = uRL.openConnection();
        if (uRLConnection instanceof java.net.JarURLConnection) {
            java.net.JarURLConnection jarURLConnection = (java.net.JarURLConnection)uRLConnection;
            JarFile jarFile = jarURLConnection.getJarFile();
            return new JarFileDescriptor(uRL, jarFile);
        }
        return null;
    }

    private static JarFileDescriptor createJarFileFromHttp(URL uRL) throws IOException {
        String string = "jar:" + uRL;
        if (!string.endsWith("!/")) {
            string = string + "!/";
        }
        URL uRL2 = new URL(string);
        JarURLConnection jarURLConnection = (JarURLConnection)uRL2.openConnection();
        return new JarFileDescriptor(uRL2, jarURLConnection.getJarFile());
    }

    private static JarFileDescriptor createJarFileFromFile(URL uRL) throws IOException {
        File file;
        URL uRL2 = JarFileFactory.sanitizeURL(uRL);
        if (uRL2 == null) {
            logger.trace("Can not sanitize URL %s", uRL);
            return null;
        }
        try {
            file = new File(uRL2.toURI());
        }
        catch (IllegalArgumentException | URISyntaxException exception) {
            logger.debug("Cannot create file from URL %s", uRL);
            return null;
        }
        if (file.isFile() && file.canRead()) {
            JarFile jarFile = new JarFile(file, false);
            return new JarFileDescriptor(uRL2, jarFile);
        }
        logger.trace("Expected jar on URL " + uRL + ": but it is not normal file.", new Object[0]);
        return null;
    }

    public static URL getURLbySource(String string) {
        Exception exception = null;
        Exception exception2 = null;
        try {
            return new URL(string);
        }
        catch (Exception exception3) {
            exception = exception3;
            try {
                File file = new File(string);
                return file.toURI().toURL();
            }
            catch (Exception exception4) {
                exception2 = exception4;
                logger.trace("Source '%s', is not valid file or URL: %s ; %s", string, exception, exception2);
                return null;
            }
        }
    }

    private static URL sanitizeURL(URL uRL) {
        if (!uRL.getProtocol().equals("jar")) {
            return uRL;
        }
        String string = uRL.getPath();
        if (!string.endsWith("!/")) {
            logger.warning("unsupported URL with jar: scheme: %s", string);
            return null;
        }
        string = string.substring(0, string.length() - 2);
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            logger.warning("malformed URL with jar: scheme: %s", string);
            return null;
        }
    }

    public static class JarFileDescriptor {
        private final URL url;
        private final JarFile jarFile;

        public JarFileDescriptor(URL uRL, JarFile jarFile) {
            this.url = uRL;
            this.jarFile = jarFile;
        }

        public URL getUrl() {
            return this.url;
        }

        public JarFile getJarFile() {
            return this.jarFile;
        }
    }
}

