/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client;

import com.azul.crs.client.JDKAccessor;
import com.azul.crs.util.logging.Logger;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.HttpsURLConnection;

public class PerformanceMetrics {
    private static final Logger logger = Logger.getLogger(PerformanceMetrics.class);
    private static JDKAccessor jdkAccessor;
    private final AtomicLong communicationMillis = new AtomicLong();
    private final AtomicLong numBytesOut = new AtomicLong();
    private final AtomicLong numBytesIn = new AtomicLong();
    private long shutdownMillis;
    private final AtomicLong preShutdownMillis = new AtomicLong();
    private final AtomicLong numEvents = new AtomicLong();
    private final AtomicLong numEventBatches = new AtomicLong();
    private final AtomicLong[] numEventHistogram = new AtomicLong[20];
    private final AtomicLong numConnections = new AtomicLong();
    private final AtomicLong numRequests = new AtomicLong();
    private final AtomicLong handshakeMillis = new AtomicLong();
    private final AtomicInteger maxQueueLength = new AtomicInteger();
    private final AtomicLong numBytesInArtifacts = new AtomicLong();
    private final AtomicLong numClassLoads = new AtomicLong();
    private final AtomicLong numJarLoads = new AtomicLong();
    private final AtomicLong numMethodEntries = new AtomicLong();
    private final AtomicLong numJarCacheFilesCreated = new AtomicLong();
    private final transient AtomicLong currentJarCacheTotalSize = new AtomicLong();
    private final AtomicLong numBytesJarCacheTotal = new AtomicLong();
    private final AtomicLong numBytesJarCacheMaxOnFS = new AtomicLong();
    private final AtomicLong numNotConfirmedJarLoads = new AtomicLong();
    private final AtomicLong numPostponedNoSpaceJarLoads = new AtomicLong();
    private final AtomicLong jarsWaitingMillis = new AtomicLong();
    private final AtomicLong numSkippedClassLoadEvents = new AtomicLong();
    private final AtomicLong numSkippedSendingEvents = new AtomicLong();
    private static final Map<String, Number> fieldDesc;
    private static PerformanceMetrics instance;

    static void init(JDKAccessor jDKAccessor) {
        jdkAccessor = jDKAccessor;
        instance = new PerformanceMetrics();
        for (int i = 0; i < PerformanceMetrics.instance.numEventHistogram.length; ++i) {
            PerformanceMetrics.instance.numEventHistogram[i] = new AtomicLong();
        }
        for (Field field : PerformanceMetrics.class.getDeclaredFields()) {
            if (!Number.class.isAssignableFrom(field.getType()) || Modifier.isTransient(field.getModifiers())) continue;
            try {
                fieldDesc.put(field.getName(), (Number)field.get(instance));
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
    }

    static void logNetworkTime(long l) {
        PerformanceMetrics.instance.communicationMillis.addAndGet(l);
    }

    static void logHandshakeTime(long l, HttpsURLConnection httpsURLConnection) {
        PerformanceMetrics.instance.handshakeMillis.addAndGet(l);
        PerformanceMetrics.instance.numRequests.incrementAndGet();
        if (jdkAccessor != null && jdkAccessor.isNotCachedHttpsURLConnection(httpsURLConnection)) {
            PerformanceMetrics.instance.numConnections.incrementAndGet();
        } else if (jdkAccessor == null) {
            logger.trace("Number of established connection is not increased: no jdkAccessor is available", new Object[0]);
        } else {
            logger.trace("Number of established connection is not increased: used connection form internal pool", new Object[0]);
        }
    }

    static void logBytes(long l, long l2) {
        PerformanceMetrics.instance.numBytesIn.addAndGet(l);
        PerformanceMetrics.instance.numBytesOut.addAndGet(l2);
    }

    static void logShutdown(long l) {
        PerformanceMetrics.instance.shutdownMillis = l;
    }

    public static void logEventBatch(long l) {
        PerformanceMetrics.instance.numEvents.addAndGet(l);
        PerformanceMetrics.instance.numEventBatches.incrementAndGet();
        PerformanceMetrics.instance.numEventHistogram[(int)(Math.log(l) / Math.log(2.0))].incrementAndGet();
    }

    public static void logClassLoads(long l) {
        PerformanceMetrics.instance.numClassLoads.addAndGet(l);
    }

    public static void logJarLoads(long l) {
        PerformanceMetrics.instance.numJarLoads.addAndGet(l);
    }

    public static void logMethodEntries(long l) {
        PerformanceMetrics.instance.numMethodEntries.addAndGet(l);
    }

    public static void logEventQueueLength(int n) {
        int n2;
        AtomicInteger atomicInteger = PerformanceMetrics.instance.maxQueueLength;
        while ((n2 = atomicInteger.get()) < n && !atomicInteger.compareAndSet(n2, n)) {
        }
    }

    public static Map logPreShutdown(long l) {
        PerformanceMetrics.instance.preShutdownMillis.set(l);
        return instance.toEventPayload();
    }

    public static void logArtifactBytes(long l) {
        PerformanceMetrics.instance.numBytesInArtifacts.addAndGet(l);
    }

    public static void logJarCacheCreated(long l) {
        long l2;
        long l3;
        PerformanceMetrics.instance.currentJarCacheTotalSize.addAndGet(l);
        PerformanceMetrics.instance.numBytesJarCacheTotal.addAndGet(l);
        PerformanceMetrics.instance.numJarCacheFilesCreated.incrementAndGet();
        AtomicLong atomicLong = PerformanceMetrics.instance.currentJarCacheTotalSize;
        AtomicLong atomicLong2 = PerformanceMetrics.instance.numBytesJarCacheMaxOnFS;
        while ((l3 = atomicLong.get()) > (l2 = atomicLong2.get()) && !atomicLong2.compareAndSet(l2, l3)) {
        }
    }

    public static void logJarCacheDeleted(long l) {
        PerformanceMetrics.instance.currentJarCacheTotalSize.addAndGet(-l);
    }

    public static void logJarLoadEventReported() {
        PerformanceMetrics.instance.numNotConfirmedJarLoads.getAndIncrement();
    }

    public static void logJarLoadNoSpace() {
        PerformanceMetrics.instance.numPostponedNoSpaceJarLoads.getAndIncrement();
    }

    public static void logSkippedClassLoadEvent() {
        PerformanceMetrics.instance.numSkippedClassLoadEvents.getAndIncrement();
    }

    public static void logSkippedSendingEvent() {
        PerformanceMetrics.instance.numSkippedSendingEvents.getAndIncrement();
    }

    public static void logJarWaitingTime(long l) {
        PerformanceMetrics.instance.jarsWaitingMillis.getAndAdd(l);
    }

    public static void logJarLoadEventConfirmed() {
        PerformanceMetrics.instance.numNotConfirmedJarLoads.getAndDecrement();
    }

    private Map toEventPayload() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, Number> entry : fieldDesc.entrySet()) {
            hashMap.put(entry.getKey(), entry.getValue().toString());
        }
        return hashMap;
    }

    static void report() {
        if (logger.isEnabled(Logger.Level.INFO)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (AtomicLong atomicLong : PerformanceMetrics.instance.numEventHistogram) {
                stringBuilder.append(atomicLong.get()).append(' ');
            }
            logger.info("total communication duration %.3fs\nnumber of executed requests is %d using %d established connections, %.3fs spent in handshake\ntotal bytes in %.3fM\ntotal event data bytes out %.3fM\ntotal artifacts bytes %.3fM\nmaximum queue length %d\nshutdown delay %.3fs (pre %.3fs)\nclasses loaded %d\nskipped class load events %d\nskipped sending events %d\njars loaded %d\nnumber of postponed jars %d\ntotal jars load waiting time (in millis) %d\nnumber of unconfirmed jar load events %d\nmethods invoked %d\nevents sent %d batches %d [%s]\ntemp jars created %d\ntemp jars created total size %.3fM\ntemp jars max fs size consumed %.3fM", (double)PerformanceMetrics.instance.communicationMillis.get() / 1000.0, PerformanceMetrics.instance.numRequests.get(), PerformanceMetrics.instance.numConnections.get(), (double)PerformanceMetrics.instance.handshakeMillis.get() / 1000.0, (double)PerformanceMetrics.instance.numBytesIn.get() / 1024.0 / 1024.0, (double)PerformanceMetrics.instance.numBytesOut.get() / 1024.0 / 1024.0, (double)PerformanceMetrics.instance.numBytesInArtifacts.get() / 1024.0 / 1024.0, PerformanceMetrics.instance.maxQueueLength.get(), (double)PerformanceMetrics.instance.shutdownMillis / 1000.0, (double)PerformanceMetrics.instance.preShutdownMillis.get() / 1000.0, PerformanceMetrics.instance.numClassLoads.get(), PerformanceMetrics.instance.numSkippedClassLoadEvents.get(), PerformanceMetrics.instance.numSkippedSendingEvents.get(), PerformanceMetrics.instance.numJarLoads.get(), PerformanceMetrics.instance.numPostponedNoSpaceJarLoads.get(), PerformanceMetrics.instance.jarsWaitingMillis.get(), PerformanceMetrics.instance.numNotConfirmedJarLoads.get(), PerformanceMetrics.instance.numMethodEntries.get(), PerformanceMetrics.instance.numEvents.get(), PerformanceMetrics.instance.numEventBatches.get(), stringBuilder.toString(), PerformanceMetrics.instance.numJarCacheFilesCreated.get(), (double)PerformanceMetrics.instance.numBytesJarCacheTotal.get() / 1024.0 / 1024.0, (double)PerformanceMetrics.instance.numBytesJarCacheMaxOnFS.get() / 1024.0 / 1024.0);
        }
    }

    static {
        fieldDesc = new HashMap<String, Number>();
    }
}

