/*
 * Copyright (c) 2009, 2013, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

// -- This file was mechanically generated: Do not edit! -- //

package sun.nio.cs.ext;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Arrays;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.ext.DoubleByte;

public class EUC_CN extends Charset
                        implements HistoricallyNamedCharset
{
    public EUC_CN() {
        super("GB2312", ExtendedCharsets.aliasesFor("GB2312"));
    }

        public String historicalName() { return "EUC_CN"; }

    public boolean contains(Charset cs) {
        return ((cs.name().equals("US-ASCII")) || (cs instanceof EUC_CN));
    }

    public CharsetDecoder newDecoder() {
        initb2c();
        return new  DoubleByte.Decoder(this, b2c, b2cSB, 0xa1, 0xfe, true);
    }

    public CharsetEncoder newEncoder() {
        initc2b();
        return new DoubleByte.Encoder(this,  c2b, c2bIndex, true); 
    }

    
    static final String b2cSBStr =
        "\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007" + 
        "\b\t\n\u000B\f\r\u000E\u000F" + 
        "\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017" + 
        "\u0018\u0019\u001A\u001B\u001C\u001D\u001E\u001F" + 
        "\u0020\u0021\"\u0023\u0024\u0025\u0026\'" + 
        "\u0028\u0029\u002A\u002B\u002C\u002D\u002E\u002F" + 
        "\u0030\u0031\u0032\u0033\u0034\u0035\u0036\u0037" + 
        "\u0038\u0039\u003A\u003B\u003C\u003D\u003E\u003F" + 
        "\u0040\u0041\u0042\u0043\u0044\u0045\u0046\u0047" + 
        "\u0048\u0049\u004A\u004B\u004C\u004D\u004E\u004F" + 
        "\u0050\u0051\u0052\u0053\u0054\u0055\u0056\u0057" + 
        "\u0058\u0059\u005A\u005B\\\u005D\u005E\u005F" + 
        "\u0060\u0061\u0062\u0063\u0064\u0065\u0066\u0067" + 
        "\u0068\u0069\u006A\u006B\u006C\u006D\u006E\u006F" + 
        "\u0070\u0071\u0072\u0073\u0074\u0075\u0076\u0077" + 
        "\u0078\u0079\u007A\u007B\u007C\u007D\u007E\u007F" + 
        "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" + 
        "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" + 
        "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" + 
        "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" + 
        "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" + 
        "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" + 
        "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" + 
        "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" + 
        "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" + 
        "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" + 
        "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" + 
        "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" + 
        "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" + 
        "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" + 
        "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" + 
        "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" ;

        static final String[] b2cStr = {
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
        "\u3000\u3001\u3002\u30FB\u02C9\u02C7\u00A8\u3003" + 
        "\u3005\u2015\uFF5E\u2016\u2026\u2018\u2019\u201C" + 
        "\u201D\u3014\u3015\u3008\u3009\u300A\u300B\u300C" + 
        "\u300D\u300E\u300F\u3016\u3017\u3010\u3011\u00B1" + 
        "\u00D7\u00F7\u2236\u2227\u2228\u2211\u220F\u222A" + 
        "\u2229\u2208\u2237\u221A\u22A5\u2225\u2220\u2312" + 
        "\u2299\u222B\u222E\u2261\u224C\u2248\u223D\u221D" + 
        "\u2260\u226E\u226F\u2264\u2265\u221E\u2235\u2234" + 
        "\u2642\u2640\u00B0\u2032\u2033\u2103\uFF04\u00A4" + 
        "\uFFE0\uFFE1\u2030\u00A7\u2116\u2606\u2605\u25CB" + 
        "\u25CF\u25CE\u25C7\u25C6\u25A1\u25A0\u25B3\u25B2" + 
        "\u203B\u2192\u2190\u2191\u2193\u3013" ,
        "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" + 
        "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" + 
        "\u2488\u2489\u248A\u248B\u248C\u248D\u248E\u248F" + 
        "\u2490\u2491\u2492\u2493\u2494\u2495\u2496\u2497" + 
        "\u2498\u2499\u249A\u249B\u2474\u2475\u2476\u2477" + 
        "\u2478\u2479\u247A\u247B\u247C\u247D\u247E\u247F" + 
        "\u2480\u2481\u2482\u2483\u2484\u2485\u2486\u2487" + 
        "\u2460\u2461\u2462\u2463\u2464\u2465\u2466\u2467" + 
        "\u2468\u2469\uFFFD\uFFFD\u3220\u3221\u3222\u3223" + 
        "\u3224\u3225\u3226\u3227\u3228\u3229\uFFFD\uFFFD" + 
        "\u2160\u2161\u2162\u2163\u2164\u2165\u2166\u2167" + 
        "\u2168\u2169\u216A\u216B\uFFFD\uFFFD" ,
        "\uFF01\uFF02\uFF03\uFFE5\uFF05\uFF06\uFF07\uFF08" + 
        "\uFF09\uFF0A\uFF0B\uFF0C\uFF0D\uFF0E\uFF0F\uFF10" + 
        "\uFF11\uFF12\uFF13\uFF14\uFF15\uFF16\uFF17\uFF18" + 
        "\uFF19\uFF1A\uFF1B\uFF1C\uFF1D\uFF1E\uFF1F\uFF20" + 
        "\uFF21\uFF22\uFF23\uFF24\uFF25\uFF26\uFF27\uFF28" + 
        "\uFF29\uFF2A\uFF2B\uFF2C\uFF2D\uFF2E\uFF2F\uFF30" + 
        "\uFF31\uFF32\uFF33\uFF34\uFF35\uFF36\uFF37\uFF38" + 
        "\uFF39\uFF3A\uFF3B\uFF3C\uFF3D\uFF3E\uFF3F\uFF40" + 
        "\uFF41\uFF42\uFF43\uFF44\uFF45\uFF46\uFF47\uFF48" + 
        "\uFF49\uFF4A\uFF4B\uFF4C\uFF4D\uFF4E\uFF4F\uFF50" + 
        "\uFF51\uFF52\uFF53\uFF54\uFF55\uFF56\uFF57\uFF58" + 
        "\uFF59\uFF5A\uFF5B\uFF5C\uFF5D\uFFE3" ,
        "\u3041\u3042\u3043\u3044\u3045\u3046\u3047\u3048" + 
        "\u3049\u304A\u304B\u304C\u304D\u304E\u304F\u3050" + 
        "\u3051\u3052\u3053\u3054\u3055\u3056\u3057\u3058" + 
        "\u3059\u305A\u305B\u305C\u305D\u305E\u305F\u3060" + 
        "\u3061\u3062\u3063\u3064\u3065\u3066\u3067\u3068" + 
        "\u3069\u306A\u306B\u306C\u306D\u306E\u306F\u3070" + 
        "\u3071\u3072\u3073\u3074\u3075\u3076\u3077\u3078" + 
        "\u3079\u307A\u307B\u307C\u307D\u307E\u307F\u3080" + 
        "\u3081\u3082\u3083\u3084\u3085\u3086\u3087\u3088" + 
        "\u3089\u308A\u308B\u308C\u308D\u308E\u308F\u3090" + 
        "\u3091\u3092\u3093\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" + 
        "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" ,
        "\u30A1\u30A2\u30A3\u30A4\u30A5\u30A6\u30A7\u30A8" + 
        "\u30A9\u30AA\u30AB\u30AC\u30AD\u30AE\u30AF\u30B0" + 
        "\u30B1\u30B2\u30B3\u30B4\u30B5\u30B6\u30B7\u30B8" + 
        "\u30B9\u30BA\u30BB\u30BC\u30BD\u30BE\u30BF\u30C0" + 
        "\u30C1\u30C2\u30C3\u30C4\u30C5\u30C6\u30C7\u30C8" + 
        "\u30C9\u30CA\u30CB\u30CC\u30CD\u30CE\u30CF\u30D0" + 
        "\u30D1\u30D2\u30D3\u30D4\u30D5\u30D6\u30D7\u30D8" + 
        "\u30D9\u30DA\u30DB\u30DC\u30DD\u30DE\u30DF\u30E0" + 
        "\u30E1\u30E2\u30E3\u30E4\u30E5\u30E6\u30E7\u30E8" + 
        "\u30E9\u30EA\u30EB\u30EC\u30ED\u30EE\u30EF\u30F0" + 
        "\u30F1\u30F2\u30F3\u30F4\u30F5\u30F6\uFFFD\uFFFD" + 
        "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" ,
        "\u0391\u0392\u0393\u0394\u0395\u0396\u0397\u0398" + 
        "\u0399\u039A\u039B\u039C\u039D\u039E\u039F\u03A0" + 
        "\u03A1\u03A3\u03A4\u03A5\u03A6\u03A7\u03A8\u03A9" + 
        "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" + 
        "\u03B1\u03B2\u03B3\u03B4\u03B5\u03B6\u03B7\u03B8" + 
        "\u03B9\u03BA\u03BB\u03BC\u03BD\u03BE\u03BF\u03C0" + 
        "\u03C1\u03C3\u03C4\u03C5\u03C6\u03C7\u03C8\u03C9" + 
        "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" + 
        "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" + 
        "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" + 
        "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" + 
        "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" ,
        "\u0410\u0411\u0412\u0413\u0414\u0415\u0401\u0416" + 
        "\u0417\u0418\u0419\u041A\u041B\u041C\u041D\u041E" + 
        "\u041F\u0420\u0421\u0422\u0423\u0424\u0425\u0426" + 
        "\u0427\u0428\u0429\u042A\u042B\u042C\u042D\u042E" + 
        "\u042F\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" + 
        "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" + 
        "\u0430\u0431\u0432\u0433\u0434\u0435\u0451\u0436" + 
        "\u0437\u0438\u0439\u043A\u043B\u043C\u043D\u043E" + 
        "\u043F\u0440\u0441\u0442\u0443\u0444\u0445\u0446" + 
        "\u0447\u0448\u0449\u044A\u044B\u044C\u044D\u044E" + 
        "\u044F\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" + 
        "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" ,
        "\u0101\u00E1\u01CE\u00E0\u0113\u00E9\u011B\u00E8" + 
        "\u012B\u00ED\u01D0\u00EC\u014D\u00F3\u01D2\u00F2" + 
        "\u016B\u00FA\u01D4\u00F9\u01D6\u01D8\u01DA\u01DC" + 
        "\u00FC\u00EA\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" + 
        "\uFFFD\uFFFD\uFFFD\uFFFD\u3105\u3106\u3107\u3108" + 
        "\u3109\u310A\u310B\u310C\u310D\u310E\u310F\u3110" + 
        "\u3111\u3112\u3113\u3114\u3115\u3116\u3117\u3118" + 
        "\u3119\u311A\u311B\u311C\u311D\u311E\u311F\u3120" + 
        "\u3121\u3122\u3123\u3124\u3125\u3126\u3127\u3128" + 
        "\u3129\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" + 
        "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" + 
        "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" ,
        "\uFFFD\uFFFD\uFFFD\u2500\u2501\u2502\u2503\u2504" + 
        "\u2505\u2506\u2507\u2508\u2509\u250A\u250B\u250C" + 
        "\u250D\u250E\u250F\u2510\u2511\u2512\u2513\u2514" + 
        "\u2515\u2516\u2517\u2518\u2519\u251A\u251B\u251C" + 
        "\u251D\u251E\u251F\u2520\u2521\u2522\u2523\u2524" + 
        "\u2525\u2526\u2527\u2528\u2529\u252A\u252B\u252C" + 
        "\u252D\u252E\u252F\u2530\u2531\u2532\u2533\u2534" + 
        "\u2535\u2536\u2537\u2538\u2539\u253A\u253B\u253C" + 
        "\u253D\u253E\u253F\u2540\u2541\u2542\u2543\u2544" + 
        "\u2545\u2546\u2547\u2548\u2549\u254A\u254B\uFFFD" + 
        "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" + 
        "\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" ,
            null,
            null,
            null,
            null,
            null,
            null,
        "\u554A\u963F\u57C3\u6328\u54CE\u5509\u54C0\u7691" + 
        "\u764C\u853C\u77EE\u827E\u788D\u7231\u9698\u978D" + 
        "\u6C28\u5B89\u4FFA\u6309\u6697\u5CB8\u80FA\u6848" + 
        "\u80AE\u6602\u76CE\u51F9\u6556\u71AC\u7FF1\u8884" + 
        "\u50B2\u5965\u61CA\u6FB3\u82AD\u634C\u6252\u53ED" + 
        "\u5427\u7B06\u516B\u75A4\u5DF4\u62D4\u8DCB\u9776" + 
        "\u628A\u8019\u575D\u9738\u7F62\u7238\u767D\u67CF" + 
        "\u767E\u6446\u4F70\u8D25\u62DC\u7A17\u6591\u73ED" + 
        "\u642C\u6273\u822C\u9881\u677F\u7248\u626E\u62CC" + 
        "\u4F34\u74E3\u534A\u529E\u7ECA\u90A6\u5E2E\u6886" + 
        "\u699C\u8180\u7ED1\u68D2\u78C5\u868C\u9551\u508D" + 
        "\u8C24\u82DE\u80DE\u5305\u8912\u5265" ,
        "\u8584\u96F9\u4FDD\u5821\u9971\u5B9D\u62B1\u62A5" + 
        "\u66B4\u8C79\u9C8D\u7206\u676F\u7891\u60B2\u5351" + 
        "\u5317\u8F88\u80CC\u8D1D\u94A1\u500D\u72C8\u5907" + 
        "\u60EB\u7119\u88AB\u5954\u82EF\u672C\u7B28\u5D29" + 
        "\u7EF7\u752D\u6CF5\u8E66\u8FF8\u903C\u9F3B\u6BD4" + 
        "\u9119\u7B14\u5F7C\u78A7\u84D6\u853D\u6BD5\u6BD9" + 
        "\u6BD6\u5E01\u5E87\u75F9\u95ED\u655D\u5F0A\u5FC5" + 
        "\u8F9F\u58C1\u81C2\u907F\u965B\u97AD\u8FB9\u7F16" + 
        "\u8D2C\u6241\u4FBF\u53D8\u535E\u8FA8\u8FA9\u8FAB" + 
        "\u904D\u6807\u5F6A\u8198\u8868\u9CD6\u618B\u522B" + 
        "\u762A\u5F6C\u658C\u6FD2\u6EE8\u5BBE\u6448\u5175" + 
        "\u51B0\u67C4\u4E19\u79C9\u997C\u70B3" ,
        "\u75C5\u5E76\u73BB\u83E0\u64AD\u62E8\u94B5\u6CE2" + 
        "\u535A\u52C3\u640F\u94C2\u7B94\u4F2F\u5E1B\u8236" + 
        "\u8116\u818A\u6E24\u6CCA\u9A73\u6355\u535C\u54FA" + 
        "\u8865\u57E0\u4E0D\u5E03\u6B65\u7C3F\u90E8\u6016" + 
        "\u64E6\u731C\u88C1\u6750\u624D\u8D22\u776C\u8E29" + 
        "\u91C7\u5F69\u83DC\u8521\u9910\u53C2\u8695\u6B8B" + 
        "\u60ED\u60E8\u707F\u82CD\u8231\u4ED3\u6CA7\u85CF" + 
        "\u64CD\u7CD9\u69FD\u66F9\u8349\u5395\u7B56\u4FA7" + 
        "\u518C\u6D4B\u5C42\u8E6D\u63D2\u53C9\u832C\u8336" + 
        "\u67E5\u78B4\u643D\u5BDF\u5C94\u5DEE\u8BE7\u62C6" + 
        "\u67F4\u8C7A\u6400\u63BA\u8749\u998B\u8C17\u7F20" + 
        "\u94F2\u4EA7\u9610\u98A4\u660C\u7316" ,
        "\u573A\u5C1D\u5E38\u957F\u507F\u80A0\u5382\u655E" + 
        "\u7545\u5531\u5021\u8D85\u6284\u949E\u671D\u5632" + 
        "\u6F6E\u5DE2\u5435\u7092\u8F66\u626F\u64A4\u63A3" + 
        "\u5F7B\u6F88\u90F4\u81E3\u8FB0\u5C18\u6668\u5FF1" + 
        "\u6C89\u9648\u8D81\u886C\u6491\u79F0\u57CE\u6A59" + 
        "\u6210\u5448\u4E58\u7A0B\u60E9\u6F84\u8BDA\u627F" + 
        "\u901E\u9A8B\u79E4\u5403\u75F4\u6301\u5319\u6C60" + 
        "\u8FDF\u5F1B\u9A70\u803B\u9F7F\u4F88\u5C3A\u8D64" + 
        "\u7FC5\u65A5\u70BD\u5145\u51B2\u866B\u5D07\u5BA0" + 
        "\u62BD\u916C\u7574\u8E0C\u7A20\u6101\u7B79\u4EC7" + 
        "\u7EF8\u7785\u4E11\u81ED\u521D\u51FA\u6A71\u53A8" + 
        "\u8E87\u9504\u96CF\u6EC1\u9664\u695A" ,
        "\u7840\u50A8\u77D7\u6410\u89E6\u5904\u63E3\u5DDD" + 
        "\u7A7F\u693D\u4F20\u8239\u5598\u4E32\u75AE\u7A97" + 
        "\u5E62\u5E8A\u95EF\u521B\u5439\u708A\u6376\u9524" + 
        "\u5782\u6625\u693F\u9187\u5507\u6DF3\u7EAF\u8822" + 
        "\u6233\u7EF0\u75B5\u8328\u78C1\u96CC\u8F9E\u6148" + 
        "\u74F7\u8BCD\u6B64\u523A\u8D50\u6B21\u806A\u8471" + 
        "\u56F1\u5306\u4ECE\u4E1B\u51D1\u7C97\u918B\u7C07" + 
        "\u4FC3\u8E7F\u7BE1\u7A9C\u6467\u5D14\u50AC\u8106" + 
        "\u7601\u7CB9\u6DEC\u7FE0\u6751\u5B58\u5BF8\u78CB" + 
        "\u64AE\u6413\u63AA\u632B\u9519\u642D\u8FBE\u7B54" + 
        "\u7629\u6253\u5927\u5446\u6B79\u50A3\u6234\u5E26" + 
        "\u6B86\u4EE3\u8D37\u888B\u5F85\u902E" ,
        "\u6020\u803D\u62C5\u4E39\u5355\u90F8\u63B8\u80C6" + 
        "\u65E6\u6C2E\u4F46\u60EE\u6DE1\u8BDE\u5F39\u86CB" + 
        "\u5F53\u6321\u515A\u8361\u6863\u5200\u6363\u8E48" + 
        "\u5012\u5C9B\u7977\u5BFC\u5230\u7A3B\u60BC\u9053" + 
        "\u76D7\u5FB7\u5F97\u7684\u8E6C\u706F\u767B\u7B49" + 
        "\u77AA\u51F3\u9093\u5824\u4F4E\u6EF4\u8FEA\u654C" + 
        "\u7B1B\u72C4\u6DA4\u7FDF\u5AE1\u62B5\u5E95\u5730" + 
        "\u8482\u7B2C\u5E1D\u5F1F\u9012\u7F14\u98A0\u6382" + 
        "\u6EC7\u7898\u70B9\u5178\u975B\u57AB\u7535\u4F43" + 
        "\u7538\u5E97\u60E6\u5960\u6DC0\u6BBF\u7889\u53FC" + 
        "\u96D5\u51CB\u5201\u6389\u540A\u9493\u8C03\u8DCC" + 
        "\u7239\u789F\u8776\u8FED\u8C0D\u53E0" ,
        "\u4E01\u76EF\u53EE\u9489\u9876\u9F0E\u952D\u5B9A" + 
        "\u8BA2\u4E22\u4E1C\u51AC\u8463\u61C2\u52A8\u680B" + 
        "\u4F97\u606B\u51BB\u6D1E\u515C\u6296\u6597\u9661" + 
        "\u8C46\u9017\u75D8\u90FD\u7763\u6BD2\u728A\u72EC" + 
        "\u8BFB\u5835\u7779\u8D4C\u675C\u9540\u809A\u5EA6" + 
        "\u6E21\u5992\u7AEF\u77ED\u953B\u6BB5\u65AD\u7F0E" + 
        "\u5806\u5151\u961F\u5BF9\u58A9\u5428\u8E72\u6566" + 
        "\u987F\u56E4\u949D\u76FE\u9041\u6387\u54C6\u591A" + 
        "\u593A\u579B\u8EB2\u6735\u8DFA\u8235\u5241\u60F0" + 
        "\u5815\u86FE\u5CE8\u9E45\u4FC4\u989D\u8BB9\u5A25" + 
        "\u6076\u5384\u627C\u904F\u9102\u997F\u6069\u800C" + 
        "\u513F\u8033\u5C14\u9975\u6D31\u4E8C" ,
        "\u8D30\u53D1\u7F5A\u7B4F\u4F10\u4E4F\u9600\u6CD5" + 
        "\u73D0\u85E9\u5E06\u756A\u7FFB\u6A0A\u77FE\u9492" + 
        "\u7E41\u51E1\u70E6\u53CD\u8FD4\u8303\u8D29\u72AF" + 
        "\u996D\u6CDB\u574A\u82B3\u65B9\u80AA\u623F\u9632" + 
        "\u59A8\u4EFF\u8BBF\u7EBA\u653E\u83F2\u975E\u5561" + 
        "\u98DE\u80A5\u532A\u8BFD\u5420\u80BA\u5E9F\u6CB8" + 
        "\u8D39\u82AC\u915A\u5429\u6C1B\u5206\u7EB7\u575F" + 
        "\u711A\u6C7E\u7C89\u594B\u4EFD\u5FFF\u6124\u7CAA" + 
        "\u4E30\u5C01\u67AB\u8702\u5CF0\u950B\u98CE\u75AF" + 
        "\u70FD\u9022\u51AF\u7F1D\u8BBD\u5949\u51E4\u4F5B" + 
        "\u5426\u592B\u6577\u80A4\u5B75\u6276\u62C2\u8F90" + 
        "\u5E45\u6C1F\u7B26\u4F0F\u4FD8\u670D" ,
        "\u6D6E\u6DAA\u798F\u88B1\u5F17\u752B\u629A\u8F85" + 
        "\u4FEF\u91DC\u65A7\u812F\u8151\u5E9C\u8150\u8D74" + 
        "\u526F\u8986\u8D4B\u590D\u5085\u4ED8\u961C\u7236" + 
        "\u8179\u8D1F\u5BCC\u8BA3\u9644\u5987\u7F1A\u5490" + 
        "\u5676\u560E\u8BE5\u6539\u6982\u9499\u76D6\u6E89" + 
        "\u5E72\u7518\u6746\u67D1\u7AFF\u809D\u8D76\u611F" + 
        "\u79C6\u6562\u8D63\u5188\u521A\u94A2\u7F38\u809B" + 
        "\u7EB2\u5C97\u6E2F\u6760\u7BD9\u768B\u9AD8\u818F" + 
        "\u7F94\u7CD5\u641E\u9550\u7A3F\u544A\u54E5\u6B4C" + 
        "\u6401\u6208\u9E3D\u80F3\u7599\u5272\u9769\u845B" + 
        "\u683C\u86E4\u9601\u9694\u94EC\u4E2A\u5404\u7ED9" + 
        "\u6839\u8DDF\u8015\u66F4\u5E9A\u7FB9" ,
        "\u57C2\u803F\u6897\u5DE5\u653B\u529F\u606D\u9F9A" + 
        "\u4F9B\u8EAC\u516C\u5BAB\u5F13\u5DE9\u6C5E\u62F1" + 
        "\u8D21\u5171\u94A9\u52FE\u6C9F\u82DF\u72D7\u57A2" + 
        "\u6784\u8D2D\u591F\u8F9C\u83C7\u5495\u7B8D\u4F30" + 
        "\u6CBD\u5B64\u59D1\u9F13\u53E4\u86CA\u9AA8\u8C37" + 
        "\u80A1\u6545\u987E\u56FA\u96C7\u522E\u74DC\u5250" + 
        "\u5BE1\u6302\u8902\u4E56\u62D0\u602A\u68FA\u5173" + 
        "\u5B98\u51A0\u89C2\u7BA1\u9986\u7F50\u60EF\u704C" + 
        "\u8D2F\u5149\u5E7F\u901B\u7470\u89C4\u572D\u7845" + 
        "\u5F52\u9F9F\u95FA\u8F68\u9B3C\u8BE1\u7678\u6842" + 
        "\u67DC\u8DEA\u8D35\u523D\u8F8A\u6EDA\u68CD\u9505" + 
        "\u90ED\u56FD\u679C\u88F9\u8FC7\u54C8" ,
        "\u9AB8\u5B69\u6D77\u6C26\u4EA5\u5BB3\u9A87\u9163" + 
        "\u61A8\u90AF\u97E9\u542B\u6DB5\u5BD2\u51FD\u558A" + 
        "\u7F55\u7FF0\u64BC\u634D\u65F1\u61BE\u608D\u710A" + 
        "\u6C57\u6C49\u592F\u676D\u822A\u58D5\u568E\u8C6A" + 
        "\u6BEB\u90DD\u597D\u8017\u53F7\u6D69\u5475\u559D" + 
        "\u8377\u83CF\u6838\u79BE\u548C\u4F55\u5408\u76D2" + 
        "\u8C89\u9602\u6CB3\u6DB8\u8D6B\u8910\u9E64\u8D3A" + 
        "\u563F\u9ED1\u75D5\u5F88\u72E0\u6068\u54FC\u4EA8" + 
        "\u6A2A\u8861\u6052\u8F70\u54C4\u70D8\u8679\u9E3F" + 
        "\u6D2A\u5B8F\u5F18\u7EA2\u5589\u4FAF\u7334\u543C" + 
        "\u539A\u5019\u540E\u547C\u4E4E\u5FFD\u745A\u58F6" + 
        "\u846B\u80E1\u8774\u72D0\u7CCA\u6E56" ,
        "\u5F27\u864E\u552C\u62A4\u4E92\u6CAA\u6237\u82B1" + 
        "\u54D7\u534E\u733E\u6ED1\u753B\u5212\u5316\u8BDD" + 
        "\u69D0\u5F8A\u6000\u6DEE\u574F\u6B22\u73AF\u6853" + 
        "\u8FD8\u7F13\u6362\u60A3\u5524\u75EA\u8C62\u7115" + 
        "\u6DA3\u5BA6\u5E7B\u8352\u614C\u9EC4\u78FA\u8757" + 
        "\u7C27\u7687\u51F0\u60F6\u714C\u6643\u5E4C\u604D" + 
        "\u8C0E\u7070\u6325\u8F89\u5FBD\u6062\u86D4\u56DE" + 
        "\u6BC1\u6094\u6167\u5349\u60E0\u6666\u8D3F\u79FD" + 
        "\u4F1A\u70E9\u6C47\u8BB3\u8BF2\u7ED8\u8364\u660F" + 
        "\u5A5A\u9B42\u6D51\u6DF7\u8C41\u6D3B\u4F19\u706B" + 
        "\u83B7\u6216\u60D1\u970D\u8D27\u7978\u51FB\u573E" + 
        "\u57FA\u673A\u7578\u7A3D\u79EF\u7B95" ,
        "\u808C\u9965\u8FF9\u6FC0\u8BA5\u9E21\u59EC\u7EE9" + 
        "\u7F09\u5409\u6781\u68D8\u8F91\u7C4D\u96C6\u53CA" + 
        "\u6025\u75BE\u6C72\u5373\u5AC9\u7EA7\u6324\u51E0" + 
        "\u810A\u5DF1\u84DF\u6280\u5180\u5B63\u4F0E\u796D" + 
        "\u5242\u60B8\u6D4E\u5BC4\u5BC2\u8BA1\u8BB0\u65E2" + 
        "\u5FCC\u9645\u5993\u7EE7\u7EAA\u5609\u67B7\u5939" + 
        "\u4F73\u5BB6\u52A0\u835A\u988A\u8D3E\u7532\u94BE" + 
        "\u5047\u7A3C\u4EF7\u67B6\u9A7E\u5AC1\u6B7C\u76D1" + 
        "\u575A\u5C16\u7B3A\u95F4\u714E\u517C\u80A9\u8270" + 
        "\u5978\u7F04\u8327\u68C0\u67EC\u78B1\u7877\u62E3" + 
        "\u6361\u7B80\u4FED\u526A\u51CF\u8350\u69DB\u9274" + 
        "\u8DF5\u8D31\u89C1\u952E\u7BAD\u4EF6" ,
        "\u5065\u8230\u5251\u996F\u6E10\u6E85\u6DA7\u5EFA" + 
        "\u50F5\u59DC\u5C06\u6D46\u6C5F\u7586\u848B\u6868" + 
        "\u5956\u8BB2\u5320\u9171\u964D\u8549\u6912\u7901" + 
        "\u7126\u80F6\u4EA4\u90CA\u6D47\u9A84\u5A07\u56BC" + 
        "\u6405\u94F0\u77EB\u4FA5\u811A\u72E1\u89D2\u997A" + 
        "\u7F34\u7EDE\u527F\u6559\u9175\u8F7F\u8F83\u53EB" + 
        "\u7A96\u63ED\u63A5\u7686\u79F8\u8857\u9636\u622A" + 
        "\u52AB\u8282\u6854\u6770\u6377\u776B\u7AED\u6D01" + 
        "\u7ED3\u89E3\u59D0\u6212\u85C9\u82A5\u754C\u501F" + 
        "\u4ECB\u75A5\u8BEB\u5C4A\u5DFE\u7B4B\u65A4\u91D1" + 
        "\u4ECA\u6D25\u895F\u7D27\u9526\u4EC5\u8C28\u8FDB" + 
        "\u9773\u664B\u7981\u8FD1\u70EC\u6D78" ,
        "\u5C3D\u52B2\u8346\u5162\u830E\u775B\u6676\u9CB8" + 
        "\u4EAC\u60CA\u7CBE\u7CB3\u7ECF\u4E95\u8B66\u666F" + 
        "\u9888\u9759\u5883\u656C\u955C\u5F84\u75C9\u9756" + 
        "\u7ADF\u7ADE\u51C0\u70AF\u7A98\u63EA\u7A76\u7EA0" + 
        "\u7396\u97ED\u4E45\u7078\u4E5D\u9152\u53A9\u6551" + 
        "\u65E7\u81FC\u8205\u548E\u5C31\u759A\u97A0\u62D8" + 
        "\u72D9\u75BD\u5C45\u9A79\u83CA\u5C40\u5480\u77E9" + 
        "\u4E3E\u6CAE\u805A\u62D2\u636E\u5DE8\u5177\u8DDD" + 
        "\u8E1E\u952F\u4FF1\u53E5\u60E7\u70AC\u5267\u6350" + 
        "\u9E43\u5A1F\u5026\u7737\u5377\u7EE2\u6485\u652B" + 
        "\u6289\u6398\u5014\u7235\u89C9\u51B3\u8BC0\u7EDD" + 
        "\u5747\u83CC\u94A7\u519B\u541B\u5CFB" ,
        "\u4FCA\u7AE3\u6D5A\u90E1\u9A8F\u5580\u5496\u5361" + 
        "\u54AF\u5F00\u63E9\u6977\u51EF\u6168\u520A\u582A" + 
        "\u52D8\u574E\u780D\u770B\u5EB7\u6177\u7CE0\u625B" + 
        "\u6297\u4EA2\u7095\u8003\u62F7\u70E4\u9760\u5777" + 
        "\u82DB\u67EF\u68F5\u78D5\u9897\u79D1\u58F3\u54B3" + 
        "\u53EF\u6E34\u514B\u523B\u5BA2\u8BFE\u80AF\u5543" + 
        "\u57A6\u6073\u5751\u542D\u7A7A\u6050\u5B54\u63A7" + 
        "\u62A0\u53E3\u6263\u5BC7\u67AF\u54ED\u7A9F\u82E6" + 
        "\u9177\u5E93\u88E4\u5938\u57AE\u630E\u8DE8\u80EF" + 
        "\u5757\u7B77\u4FA9\u5FEB\u5BBD\u6B3E\u5321\u7B50" + 
        "\u72C2\u6846\u77FF\u7736\u65F7\u51B5\u4E8F\u76D4" + 
        "\u5CBF\u7AA5\u8475\u594E\u9B41\u5080" ,
        "\u9988\u6127\u6E83\u5764\u6606\u6346\u56F0\u62EC" + 
        "\u6269\u5ED3\u9614\u5783\u62C9\u5587\u8721\u814A" + 
        "\u8FA3\u5566\u83B1\u6765\u8D56\u84DD\u5A6A\u680F" + 
        "\u62E6\u7BEE\u9611\u5170\u6F9C\u8C30\u63FD\u89C8" + 
        "\u61D2\u7F06\u70C2\u6EE5\u7405\u6994\u72FC\u5ECA" + 
        "\u90CE\u6717\u6D6A\u635E\u52B3\u7262\u8001\u4F6C" + 
        "\u59E5\u916A\u70D9\u6D9D\u52D2\u4E50\u96F7\u956D" + 
        "\u857E\u78CA\u7D2F\u5121\u5792\u64C2\u808B\u7C7B" + 
        "\u6CEA\u68F1\u695E\u51B7\u5398\u68A8\u7281\u9ECE" + 
        "\u7BF1\u72F8\u79BB\u6F13\u7406\u674E\u91CC\u9CA4" + 
        "\u793C\u8389\u8354\u540F\u6817\u4E3D\u5389\u52B1" + 
        "\u783E\u5386\u5229\u5088\u4F8B\u4FD0" ,
        "\u75E2\u7ACB\u7C92\u6CA5\u96B6\u529B\u7483\u54E9" + 
        "\u4FE9\u8054\u83B2\u8FDE\u9570\u5EC9\u601C\u6D9F" + 
        "\u5E18\u655B\u8138\u94FE\u604B\u70BC\u7EC3\u7CAE" + 
        "\u51C9\u6881\u7CB1\u826F\u4E24\u8F86\u91CF\u667E" + 
        "\u4EAE\u8C05\u64A9\u804A\u50DA\u7597\u71CE\u5BE5" + 
        "\u8FBD\u6F66\u4E86\u6482\u9563\u5ED6\u6599\u5217" + 
        "\u88C2\u70C8\u52A3\u730E\u7433\u6797\u78F7\u9716" + 
        "\u4E34\u90BB\u9CDE\u6DCB\u51DB\u8D41\u541D\u62CE" + 
        "\u73B2\u83F1\u96F6\u9F84\u94C3\u4F36\u7F9A\u51CC" + 
        "\u7075\u9675\u5CAD\u9886\u53E6\u4EE4\u6E9C\u7409" + 
        "\u69B4\u786B\u998F\u7559\u5218\u7624\u6D41\u67F3" + 
        "\u516D\u9F99\u804B\u5499\u7B3C\u7ABF" ,
        "\u9686\u5784\u62E2\u9647\u697C\u5A04\u6402\u7BD3" + 
        "\u6F0F\u964B\u82A6\u5362\u9885\u5E90\u7089\u63B3" + 
        "\u5364\u864F\u9C81\u9E93\u788C\u9732\u8DEF\u8D42" + 
        "\u9E7F\u6F5E\u7984\u5F55\u9646\u622E\u9A74\u5415" + 
        "\u94DD\u4FA3\u65C5\u5C65\u5C61\u7F15\u8651\u6C2F" + 
        "\u5F8B\u7387\u6EE4\u7EFF\u5CE6\u631B\u5B6A\u6EE6" + 
        "\u5375\u4E71\u63A0\u7565\u62A1\u8F6E\u4F26\u4ED1" + 
        "\u6CA6\u7EB6\u8BBA\u841D\u87BA\u7F57\u903B\u9523" + 
        "\u7BA9\u9AA1\u88F8\u843D\u6D1B\u9A86\u7EDC\u5988" + 
        "\u9EBB\u739B\u7801\u8682\u9A6C\u9A82\u561B\u5417" + 
        "\u57CB\u4E70\u9EA6\u5356\u8FC8\u8109\u7792\u9992" + 
        "\u86EE\u6EE1\u8513\u66FC\u6162\u6F2B" ,
        "\u8C29\u8292\u832B\u76F2\u6C13\u5FD9\u83BD\u732B" + 
        "\u8305\u951A\u6BDB\u77DB\u94C6\u536F\u8302\u5192" + 
        "\u5E3D\u8C8C\u8D38\u4E48\u73AB\u679A\u6885\u9176" + 
        "\u9709\u7164\u6CA1\u7709\u5A92\u9541\u6BCF\u7F8E" + 
        "\u6627\u5BD0\u59B9\u5A9A\u95E8\u95F7\u4EEC\u840C" + 
        "\u8499\u6AAC\u76DF\u9530\u731B\u68A6\u5B5F\u772F" + 
        "\u919A\u9761\u7CDC\u8FF7\u8C1C\u5F25\u7C73\u79D8" + 
        "\u89C5\u6CCC\u871C\u5BC6\u5E42\u68C9\u7720\u7EF5" + 
        "\u5195\u514D\u52C9\u5A29\u7F05\u9762\u82D7\u63CF" + 
        "\u7784\u85D0\u79D2\u6E3A\u5E99\u5999\u8511\u706D" + 
        "\u6C11\u62BF\u76BF\u654F\u60AF\u95FD\u660E\u879F" + 
        "\u9E23\u94ED\u540D\u547D\u8C2C\u6478" ,
        "\u6479\u8611\u6A21\u819C\u78E8\u6469\u9B54\u62B9" + 
        "\u672B\u83AB\u58A8\u9ED8\u6CAB\u6F20\u5BDE\u964C" + 
        "\u8C0B\u725F\u67D0\u62C7\u7261\u4EA9\u59C6\u6BCD" + 
        "\u5893\u66AE\u5E55\u52DF\u6155\u6728\u76EE\u7766" + 
        "\u7267\u7A46\u62FF\u54EA\u5450\u94A0\u90A3\u5A1C" + 
        "\u7EB3\u6C16\u4E43\u5976\u8010\u5948\u5357\u7537" + 
        "\u96BE\u56CA\u6320\u8111\u607C\u95F9\u6DD6\u5462" + 
        "\u9981\u5185\u5AE9\u80FD\u59AE\u9713\u502A\u6CE5" + 
        "\u5C3C\u62DF\u4F60\u533F\u817B\u9006\u6EBA\u852B" + 
        "\u62C8\u5E74\u78BE\u64B5\u637B\u5FF5\u5A18\u917F" + 
        "\u9E1F\u5C3F\u634F\u8042\u5B7D\u556E\u954A\u954D" + 
        "\u6D85\u60A8\u67E0\u72DE\u51DD\u5B81" ,
        "\u62E7\u6CDE\u725B\u626D\u94AE\u7EBD\u8113\u6D53" + 
        "\u519C\u5F04\u5974\u52AA\u6012\u5973\u6696\u8650" + 
        "\u759F\u632A\u61E6\u7CEF\u8BFA\u54E6\u6B27\u9E25" + 
        "\u6BB4\u85D5\u5455\u5076\u6CA4\u556A\u8DB4\u722C" + 
        "\u5E15\u6015\u7436\u62CD\u6392\u724C\u5F98\u6E43" + 
        "\u6D3E\u6500\u6F58\u76D8\u78D0\u76FC\u7554\u5224" + 
        "\u53DB\u4E53\u5E9E\u65C1\u802A\u80D6\u629B\u5486" + 
        "\u5228\u70AE\u888D\u8DD1\u6CE1\u5478\u80DA\u57F9" + 
        "\u88F4\u8D54\u966A\u914D\u4F69\u6C9B\u55B7\u76C6" + 
        "\u7830\u62A8\u70F9\u6F8E\u5F6D\u84EC\u68DA\u787C" + 
        "\u7BF7\u81A8\u670B\u9E4F\u6367\u78B0\u576F\u7812" + 
        "\u9739\u6279\u62AB\u5288\u7435\u6BD7" ,
        "\u5564\u813E\u75B2\u76AE\u5339\u75DE\u50FB\u5C41" + 
        "\u8B6C\u7BC7\u504F\u7247\u9A97\u98D8\u6F02\u74E2" + 
        "\u7968\u6487\u77A5\u62FC\u9891\u8D2B\u54C1\u8058" + 
        "\u4E52\u576A\u82F9\u840D\u5E73\u51ED\u74F6\u8BC4" + 
        "\u5C4F\u5761\u6CFC\u9887\u5A46\u7834\u9B44\u8FEB" + 
        "\u7C95\u5256\u6251\u94FA\u4EC6\u8386\u8461\u83E9" + 
        "\u84B2\u57D4\u6734\u5703\u666E\u6D66\u8C31\u66DD" + 
        "\u7011\u671F\u6B3A\u6816\u621A\u59BB\u4E03\u51C4" + 
        "\u6F06\u67D2\u6C8F\u5176\u68CB\u5947\u6B67\u7566" + 
        "\u5D0E\u8110\u9F50\u65D7\u7948\u7941\u9A91\u8D77" + 
        "\u5C82\u4E5E\u4F01\u542F\u5951\u780C\u5668\u6C14" + 
        "\u8FC4\u5F03\u6C7D\u6CE3\u8BAB\u6390" ,
        "\u6070\u6D3D\u7275\u6266\u948E\u94C5\u5343\u8FC1" + 
        "\u7B7E\u4EDF\u8C26\u4E7E\u9ED4\u94B1\u94B3\u524D" + 
        "\u6F5C\u9063\u6D45\u8C34\u5811\u5D4C\u6B20\u6B49" + 
        "\u67AA\u545B\u8154\u7F8C\u5899\u8537\u5F3A\u62A2" + 
        "\u6A47\u9539\u6572\u6084\u6865\u77A7\u4E54\u4FA8" + 
        "\u5DE7\u9798\u64AC\u7FD8\u5CED\u4FCF\u7A8D\u5207" + 
        "\u8304\u4E14\u602F\u7A83\u94A6\u4FB5\u4EB2\u79E6" + 
        "\u7434\u52E4\u82B9\u64D2\u79BD\u5BDD\u6C81\u9752" + 
        "\u8F7B\u6C22\u503E\u537F\u6E05\u64CE\u6674\u6C30" + 
        "\u60C5\u9877\u8BF7\u5E86\u743C\u7A77\u79CB\u4E18" + 
        "\u90B1\u7403\u6C42\u56DA\u914B\u6CC5\u8D8B\u533A" + 
        "\u86C6\u66F2\u8EAF\u5C48\u9A71\u6E20" ,
        "\u53D6\u5A36\u9F8B\u8DA3\u53BB\u5708\u98A7\u6743" + 
        "\u919B\u6CC9\u5168\u75CA\u62F3\u72AC\u5238\u529D" + 
        "\u7F3A\u7094\u7638\u5374\u9E4A\u69B7\u786E\u96C0" + 
        "\u88D9\u7FA4\u7136\u71C3\u5189\u67D3\u74E4\u58E4" + 
        "\u6518\u56B7\u8BA9\u9976\u6270\u7ED5\u60F9\u70ED" + 
        "\u58EC\u4EC1\u4EBA\u5FCD\u97E7\u4EFB\u8BA4\u5203" + 
        "\u598A\u7EAB\u6254\u4ECD\u65E5\u620E\u8338\u84C9" + 
        "\u8363\u878D\u7194\u6EB6\u5BB9\u7ED2\u5197\u63C9" + 
        "\u67D4\u8089\u8339\u8815\u5112\u5B7A\u5982\u8FB1" + 
        "\u4E73\u6C5D\u5165\u8925\u8F6F\u962E\u854A\u745E" + 
        "\u9510\u95F0\u6DA6\u82E5\u5F31\u6492\u6D12\u8428" + 
        "\u816E\u9CC3\u585E\u8D5B\u4E09\u53C1" ,
        "\u4F1E\u6563\u6851\u55D3\u4E27\u6414\u9A9A\u626B" + 
        "\u5AC2\u745F\u8272\u6DA9\u68EE\u50E7\u838E\u7802" + 
        "\u6740\u5239\u6C99\u7EB1\u50BB\u5565\u715E\u7B5B" + 
        "\u6652\u73CA\u82EB\u6749\u5C71\u5220\u717D\u886B" + 
        "\u95EA\u9655\u64C5\u8D61\u81B3\u5584\u6C55\u6247" + 
        "\u7F2E\u5892\u4F24\u5546\u8D4F\u664C\u4E0A\u5C1A" + 
        "\u88F3\u68A2\u634E\u7A0D\u70E7\u828D\u52FA\u97F6" + 
        "\u5C11\u54E8\u90B5\u7ECD\u5962\u8D4A\u86C7\u820C" + 
        "\u820D\u8D66\u6444\u5C04\u6151\u6D89\u793E\u8BBE" + 
        "\u7837\u7533\u547B\u4F38\u8EAB\u6DF1\u5A20\u7EC5" + 
        "\u795E\u6C88\u5BA1\u5A76\u751A\u80BE\u614E\u6E17" + 
        "\u58F0\u751F\u7525\u7272\u5347\u7EF3" ,
        "\u7701\u76DB\u5269\u80DC\u5723\u5E08\u5931\u72EE" + 
        "\u65BD\u6E7F\u8BD7\u5C38\u8671\u5341\u77F3\u62FE" + 
        "\u65F6\u4EC0\u98DF\u8680\u5B9E\u8BC6\u53F2\u77E2" + 
        "\u4F7F\u5C4E\u9A76\u59CB\u5F0F\u793A\u58EB\u4E16" + 
        "\u67FF\u4E8B\u62ED\u8A93\u901D\u52BF\u662F\u55DC" + 
        "\u566C\u9002\u4ED5\u4F8D\u91CA\u9970\u6C0F\u5E02" + 
        "\u6043\u5BA4\u89C6\u8BD5\u6536\u624B\u9996\u5B88" + 
        "\u5BFF\u6388\u552E\u53D7\u7626\u517D\u852C\u67A2" + 
        "\u68B3\u6B8A\u6292\u8F93\u53D4\u8212\u6DD1\u758F" + 
        "\u4E66\u8D4E\u5B70\u719F\u85AF\u6691\u66D9\u7F72" + 
        "\u8700\u9ECD\u9F20\u5C5E\u672F\u8FF0\u6811\u675F" + 
        "\u620D\u7AD6\u5885\u5EB6\u6570\u6F31" ,
        "\u6055\u5237\u800D\u6454\u8870\u7529\u5E05\u6813" + 
        "\u62F4\u971C\u53CC\u723D\u8C01\u6C34\u7761\u7A0E" + 
        "\u542E\u77AC\u987A\u821C\u8BF4\u7855\u6714\u70C1" + 
        "\u65AF\u6495\u5636\u601D\u79C1\u53F8\u4E1D\u6B7B" + 
        "\u8086\u5BFA\u55E3\u56DB\u4F3A\u4F3C\u9972\u5DF3" + 
        "\u677E\u8038\u6002\u9882\u9001\u5B8B\u8BBC\u8BF5" + 
        "\u641C\u8258\u64DE\u55FD\u82CF\u9165\u4FD7\u7D20" + 
        "\u901F\u7C9F\u50F3\u5851\u6EAF\u5BBF\u8BC9\u8083" + 
        "\u9178\u849C\u7B97\u867D\u968B\u968F\u7EE5\u9AD3" + 
        "\u788E\u5C81\u7A57\u9042\u96A7\u795F\u5B59\u635F" + 
        "\u7B0B\u84D1\u68AD\u5506\u7F29\u7410\u7D22\u9501" + 
        "\u6240\u584C\u4ED6\u5B83\u5979\u5854" ,
        "\u736D\u631E\u8E4B\u8E0F\u80CE\u82D4\u62AC\u53F0" + 
        "\u6CF0\u915E\u592A\u6001\u6C70\u574D\u644A\u8D2A" + 
        "\u762B\u6EE9\u575B\u6A80\u75F0\u6F6D\u8C2D\u8C08" + 
        "\u5766\u6BEF\u8892\u78B3\u63A2\u53F9\u70AD\u6C64" + 
        "\u5858\u642A\u5802\u68E0\u819B\u5510\u7CD6\u5018" + 
        "\u8EBA\u6DCC\u8D9F\u70EB\u638F\u6D9B\u6ED4\u7EE6" + 
        "\u8404\u6843\u9003\u6DD8\u9676\u8BA8\u5957\u7279" + 
        "\u85E4\u817E\u75BC\u8A8A\u68AF\u5254\u8E22\u9511" + 
        "\u63D0\u9898\u8E44\u557C\u4F53\u66FF\u568F\u60D5" + 
        "\u6D95\u5243\u5C49\u5929\u6DFB\u586B\u7530\u751C" + 
        "\u606C\u8214\u8146\u6311\u6761\u8FE2\u773A\u8DF3" + 
        "\u8D34\u94C1\u5E16\u5385\u542C\u70C3" ,
        "\u6C40\u5EF7\u505C\u4EAD\u5EAD\u633A\u8247\u901A" + 
        "\u6850\u916E\u77B3\u540C\u94DC\u5F64\u7AE5\u6876" + 
        "\u6345\u7B52\u7EDF\u75DB\u5077\u6295\u5934\u900F" + 
        "\u51F8\u79C3\u7A81\u56FE\u5F92\u9014\u6D82\u5C60" + 
        "\u571F\u5410\u5154\u6E4D\u56E2\u63A8\u9893\u817F" + 
        "\u8715\u892A\u9000\u541E\u5C6F\u81C0\u62D6\u6258" + 
        "\u8131\u9E35\u9640\u9A6E\u9A7C\u692D\u59A5\u62D3" + 
        "\u553E\u6316\u54C7\u86D9\u6D3C\u5A03\u74E6\u889C" + 
        "\u6B6A\u5916\u8C4C\u5F2F\u6E7E\u73A9\u987D\u4E38" + 
        "\u70F7\u5B8C\u7897\u633D\u665A\u7696\u60CB\u5B9B" + 
        "\u5A49\u4E07\u8155\u6C6A\u738B\u4EA1\u6789\u7F51" + 
        "\u5F80\u65FA\u671B\u5FD8\u5984\u5A01" ,
        "\u5DCD\u5FAE\u5371\u97E6\u8FDD\u6845\u56F4\u552F" + 
        "\u60DF\u4E3A\u6F4D\u7EF4\u82C7\u840E\u59D4\u4F1F" + 
        "\u4F2A\u5C3E\u7EAC\u672A\u851A\u5473\u754F\u80C3" + 
        "\u5582\u9B4F\u4F4D\u6E2D\u8C13\u5C09\u6170\u536B" + 
        "\u761F\u6E29\u868A\u6587\u95FB\u7EB9\u543B\u7A33" + 
        "\u7D0A\u95EE\u55E1\u7FC1\u74EE\u631D\u8717\u6DA1" + 
        "\u7A9D\u6211\u65A1\u5367\u63E1\u6C83\u5DEB\u545C" + 
        "\u94A8\u4E4C\u6C61\u8BEC\u5C4B\u65E0\u829C\u68A7" + 
        "\u543E\u5434\u6BCB\u6B66\u4E94\u6342\u5348\u821E" + 
        "\u4F0D\u4FAE\u575E\u620A\u96FE\u6664\u7269\u52FF" + 
        "\u52A1\u609F\u8BEF\u6614\u7199\u6790\u897F\u7852" + 
        "\u77FD\u6670\u563B\u5438\u9521\u727A" ,
        "\u7A00\u606F\u5E0C\u6089\u819D\u5915\u60DC\u7184" + 
        "\u70EF\u6EAA\u6C50\u7280\u6A84\u88AD\u5E2D\u4E60" + 
        "\u5AB3\u559C\u94E3\u6D17\u7CFB\u9699\u620F\u7EC6" + 
        "\u778E\u867E\u5323\u971E\u8F96\u6687\u5CE1\u4FA0" + 
        "\u72ED\u4E0B\u53A6\u590F\u5413\u6380\u9528\u5148" + 
        "\u4ED9\u9C9C\u7EA4\u54B8\u8D24\u8854\u8237\u95F2" + 
        "\u6D8E\u5F26\u5ACC\u663E\u9669\u73B0\u732E\u53BF" + 
        "\u817A\u9985\u7FA1\u5BAA\u9677\u9650\u7EBF\u76F8" + 
        "\u53A2\u9576\u9999\u7BB1\u8944\u6E58\u4E61\u7FD4" + 
        "\u7965\u8BE6\u60F3\u54CD\u4EAB\u9879\u5DF7\u6A61" + 
        "\u50CF\u5411\u8C61\u8427\u785D\u9704\u524A\u54EE" + 
        "\u56A3\u9500\u6D88\u5BB5\u6DC6\u6653" ,
        "\u5C0F\u5B5D\u6821\u8096\u5578\u7B11\u6548\u6954" + 
        "\u4E9B\u6B47\u874E\u978B\u534F\u631F\u643A\u90AA" + 
        "\u659C\u80C1\u8C10\u5199\u68B0\u5378\u87F9\u61C8" + 
        "\u6CC4\u6CFB\u8C22\u5C51\u85AA\u82AF\u950C\u6B23" + 
        "\u8F9B\u65B0\u5FFB\u5FC3\u4FE1\u8845\u661F\u8165" + 
        "\u7329\u60FA\u5174\u5211\u578B\u5F62\u90A2\u884C" + 
        "\u9192\u5E78\u674F\u6027\u59D3\u5144\u51F6\u80F8" + 
        "\u5308\u6C79\u96C4\u718A\u4F11\u4FEE\u7F9E\u673D" + 
        "\u55C5\u9508\u79C0\u8896\u7EE3\u589F\u620C\u9700" + 
        "\u865A\u5618\u987B\u5F90\u8BB8\u84C4\u9157\u53D9" + 
        "\u65ED\u5E8F\u755C\u6064\u7D6E\u5A7F\u7EEA\u7EED" + 
        "\u8F69\u55A7\u5BA3\u60AC\u65CB\u7384" ,
        "\u9009\u7663\u7729\u7EDA\u9774\u859B\u5B66\u7A74" + 
        "\u96EA\u8840\u52CB\u718F\u5FAA\u65EC\u8BE2\u5BFB" + 
        "\u9A6F\u5DE1\u6B89\u6C5B\u8BAD\u8BAF\u900A\u8FC5" + 
        "\u538B\u62BC\u9E26\u9E2D\u5440\u4E2B\u82BD\u7259" + 
        "\u869C\u5D16\u8859\u6DAF\u96C5\u54D1\u4E9A\u8BB6" + 
        "\u7109\u54BD\u9609\u70DF\u6DF9\u76D0\u4E25\u7814" + 
        "\u8712\u5CA9\u5EF6\u8A00\u989C\u960E\u708E\u6CBF" + 
        "\u5944\u63A9\u773C\u884D\u6F14\u8273\u5830\u71D5" + 
        "\u538C\u781A\u96C1\u5501\u5F66\u7130\u5BB4\u8C1A" + 
        "\u9A8C\u6B83\u592E\u9E2F\u79E7\u6768\u626C\u4F6F" + 
        "\u75A1\u7F8A\u6D0B\u9633\u6C27\u4EF0\u75D2\u517B" + 
        "\u6837\u6F3E\u9080\u8170\u5996\u7476" ,
        "\u6447\u5C27\u9065\u7A91\u8C23\u59DA\u54AC\u8200" + 
        "\u836F\u8981\u8000\u6930\u564E\u8036\u7237\u91CE" + 
        "\u51B6\u4E5F\u9875\u6396\u4E1A\u53F6\u66F3\u814B" + 
        "\u591C\u6DB2\u4E00\u58F9\u533B\u63D6\u94F1\u4F9D" + 
        "\u4F0A\u8863\u9890\u5937\u9057\u79FB\u4EEA\u80F0" + 
        "\u7591\u6C82\u5B9C\u59E8\u5F5D\u6905\u8681\u501A" + 
        "\u5DF2\u4E59\u77E3\u4EE5\u827A\u6291\u6613\u9091" + 
        "\u5C79\u4EBF\u5F79\u81C6\u9038\u8084\u75AB\u4EA6" + 
        "\u88D4\u610F\u6BC5\u5FC6\u4E49\u76CA\u6EA2\u8BE3" + 
        "\u8BAE\u8C0A\u8BD1\u5F02\u7FFC\u7FCC\u7ECE\u8335" + 
        "\u836B\u56E0\u6BB7\u97F3\u9634\u59FB\u541F\u94F6" + 
        "\u6DEB\u5BC5\u996E\u5C39\u5F15\u9690" ,
        "\u5370\u82F1\u6A31\u5A74\u9E70\u5E94\u7F28\u83B9" + 
        "\u8424\u8425\u8367\u8747\u8FCE\u8D62\u76C8\u5F71" + 
        "\u9896\u786C\u6620\u54DF\u62E5\u4F63\u81C3\u75C8" + 
        "\u5EB8\u96CD\u8E0A\u86F9\u548F\u6CF3\u6D8C\u6C38" + 
        "\u607F\u52C7\u7528\u5E7D\u4F18\u60A0\u5FE7\u5C24" + 
        "\u7531\u90AE\u94C0\u72B9\u6CB9\u6E38\u9149\u6709" + 
        "\u53CB\u53F3\u4F51\u91C9\u8BF1\u53C8\u5E7C\u8FC2" + 
        "\u6DE4\u4E8E\u76C2\u6986\u865E\u611A\u8206\u4F59" + 
        "\u4FDE\u903E\u9C7C\u6109\u6E1D\u6E14\u9685\u4E88" + 
        "\u5A31\u96E8\u4E0E\u5C7F\u79B9\u5B87\u8BED\u7FBD" + 
        "\u7389\u57DF\u828B\u90C1\u5401\u9047\u55BB\u5CEA" + 
        "\u5FA1\u6108\u6B32\u72F1\u80B2\u8A89" ,
        "\u6D74\u5BD3\u88D5\u9884\u8C6B\u9A6D\u9E33\u6E0A" + 
        "\u51A4\u5143\u57A3\u8881\u539F\u63F4\u8F95\u56ED" + 
        "\u5458\u5706\u733F\u6E90\u7F18\u8FDC\u82D1\u613F" + 
        "\u6028\u9662\u66F0\u7EA6\u8D8A\u8DC3\u94A5\u5CB3" + 
        "\u7CA4\u6708\u60A6\u9605\u8018\u4E91\u90E7\u5300" + 
        "\u9668\u5141\u8FD0\u8574\u915D\u6655\u97F5\u5B55" + 
        "\u531D\u7838\u6742\u683D\u54C9\u707E\u5BB0\u8F7D" + 
        "\u518D\u5728\u54B1\u6512\u6682\u8D5E\u8D43\u810F" + 
        "\u846C\u906D\u7CDF\u51FF\u85FB\u67A3\u65E9\u6FA1" + 
        "\u86A4\u8E81\u566A\u9020\u7682\u7076\u71E5\u8D23" + 
        "\u62E9\u5219\u6CFD\u8D3C\u600E\u589E\u618E\u66FE" + 
        "\u8D60\u624E\u55B3\u6E23\u672D\u8F67" ,
        "\u94E1\u95F8\u7728\u6805\u69A8\u548B\u4E4D\u70B8" + 
        "\u8BC8\u6458\u658B\u5B85\u7A84\u503A\u5BE8\u77BB" + 
        "\u6BE1\u8A79\u7C98\u6CBE\u76CF\u65A9\u8F97\u5D2D" + 
        "\u5C55\u8638\u6808\u5360\u6218\u7AD9\u6E5B\u7EFD" + 
        "\u6A1F\u7AE0\u5F70\u6F33\u5F20\u638C\u6DA8\u6756" + 
        "\u4E08\u5E10\u8D26\u4ED7\u80C0\u7634\u969C\u62DB" + 
        "\u662D\u627E\u6CBC\u8D75\u7167\u7F69\u5146\u8087" + 
        "\u53EC\u906E\u6298\u54F2\u86F0\u8F99\u8005\u9517" + 
        "\u8517\u8FD9\u6D59\u73CD\u659F\u771F\u7504\u7827" + 
        "\u81FB\u8D1E\u9488\u4FA6\u6795\u75B9\u8BCA\u9707" + 
        "\u632F\u9547\u9635\u84B8\u6323\u7741\u5F81\u72F0" + 
        "\u4E89\u6014\u6574\u62EF\u6B63\u653F" ,
        "\u5E27\u75C7\u90D1\u8BC1\u829D\u679D\u652F\u5431" + 
        "\u8718\u77E5\u80A2\u8102\u6C41\u4E4B\u7EC7\u804C" + 
        "\u76F4\u690D\u6B96\u6267\u503C\u4F84\u5740\u6307" + 
        "\u6B62\u8DBE\u53EA\u65E8\u7EB8\u5FD7\u631A\u63B7" + 
        "\u81F3\u81F4\u7F6E\u5E1C\u5CD9\u5236\u667A\u79E9" + 
        "\u7A1A\u8D28\u7099\u75D4\u6EDE\u6CBB\u7A92\u4E2D" + 
        "\u76C5\u5FE0\u949F\u8877\u7EC8\u79CD\u80BF\u91CD" + 
        "\u4EF2\u4F17\u821F\u5468\u5DDE\u6D32\u8BCC\u7CA5" + 
        "\u8F74\u8098\u5E1A\u5492\u76B1\u5B99\u663C\u9AA4" + 
        "\u73E0\u682A\u86DB\u6731\u732A\u8BF8\u8BDB\u9010" + 
        "\u7AF9\u70DB\u716E\u62C4\u77A9\u5631\u4E3B\u8457" + 
        "\u67F1\u52A9\u86C0\u8D2E\u94F8\u7B51" ,
        "\u4F4F\u6CE8\u795D\u9A7B\u6293\u722A\u62FD\u4E13" + 
        "\u7816\u8F6C\u64B0\u8D5A\u7BC6\u6869\u5E84\u88C5" + 
        "\u5986\u649E\u58EE\u72B6\u690E\u9525\u8FFD\u8D58" + 
        "\u5760\u7F00\u8C06\u51C6\u6349\u62D9\u5353\u684C" + 
        "\u7422\u8301\u914C\u5544\u7740\u707C\u6D4A\u5179" + 
        "\u54A8\u8D44\u59FF\u6ECB\u6DC4\u5B5C\u7D2B\u4ED4" + 
        "\u7C7D\u6ED3\u5B50\u81EA\u6E0D\u5B57\u9B03\u68D5" + 
        "\u8E2A\u5B97\u7EFC\u603B\u7EB5\u90B9\u8D70\u594F" + 
        "\u63CD\u79DF\u8DB3\u5352\u65CF\u7956\u8BC5\u963B" + 
        "\u7EC4\u94BB\u7E82\u5634\u9189\u6700\u7F6A\u5C0A" + 
        "\u9075\u6628\u5DE6\u4F50\u67DE\u505A\u4F5C\u5750" + 
        "\u5EA7\uFFFD\uFFFD\uFFFD\uFFFD\uFFFD" ,
        "\u4E8D\u4E0C\u5140\u4E10\u5EFF\u5345\u4E15\u4E98" + 
        "\u4E1E\u9B32\u5B6C\u5669\u4E28\u79BA\u4E3F\u5315" + 
        "\u4E47\u592D\u723B\u536E\u6C10\u56DF\u80E4\u9997" + 
        "\u6BD3\u777E\u9F17\u4E36\u4E9F\u9F10\u4E5C\u4E69" + 
        "\u4E93\u8288\u5B5B\u556C\u560F\u4EC4\u538D\u539D" + 
        "\u53A3\u53A5\u53AE\u9765\u8D5D\u531A\u53F5\u5326" + 
        "\u532E\u533E\u8D5C\u5366\u5363\u5202\u5208\u520E" + 
        "\u522D\u5233\u523F\u5240\u524C\u525E\u5261\u525C" + 
        "\u84AF\u527D\u5282\u5281\u5290\u5293\u5182\u7F54" + 
        "\u4EBB\u4EC3\u4EC9\u4EC2\u4EE8\u4EE1\u4EEB\u4EDE" + 
        "\u4F1B\u4EF3\u4F22\u4F64\u4EF5\u4F25\u4F27\u4F09" + 
        "\u4F2B\u4F5E\u4F67\u6538\u4F5A\u4F5D" ,
        "\u4F5F\u4F57\u4F32\u4F3D\u4F76\u4F74\u4F91\u4F89" + 
        "\u4F83\u4F8F\u4F7E\u4F7B\u4FAA\u4F7C\u4FAC\u4F94" + 
        "\u4FE6\u4FE8\u4FEA\u4FC5\u4FDA\u4FE3\u4FDC\u4FD1" + 
        "\u4FDF\u4FF8\u5029\u504C\u4FF3\u502C\u500F\u502E" + 
        "\u502D\u4FFE\u501C\u500C\u5025\u5028\u507E\u5043" + 
        "\u5055\u5048\u504E\u506C\u507B\u50A5\u50A7\u50A9" + 
        "\u50BA\u50D6\u5106\u50ED\u50EC\u50E6\u50EE\u5107" + 
        "\u510B\u4EDD\u6C3D\u4F58\u4F65\u4FCE\u9FA0\u6C46" + 
        "\u7C74\u516E\u5DFD\u9EC9\u9998\u5181\u5914\u52F9" + 
        "\u530D\u8A07\u5310\u51EB\u5919\u5155\u4EA0\u5156" + 
        "\u4EB3\u886E\u88A4\u4EB5\u8114\u88D2\u7980\u5B34" + 
        "\u8803\u7FB8\u51AB\u51B1\u51BD\u51BC" ,
        "\u51C7\u5196\u51A2\u51A5\u8BA0\u8BA6\u8BA7\u8BAA" + 
        "\u8BB4\u8BB5\u8BB7\u8BC2\u8BC3\u8BCB\u8BCF\u8BCE" + 
        "\u8BD2\u8BD3\u8BD4\u8BD6\u8BD8\u8BD9\u8BDC\u8BDF" + 
        "\u8BE0\u8BE4\u8BE8\u8BE9\u8BEE\u8BF0\u8BF3\u8BF6" + 
        "\u8BF9\u8BFC\u8BFF\u8C00\u8C02\u8C04\u8C07\u8C0C" + 
        "\u8C0F\u8C11\u8C12\u8C14\u8C15\u8C16\u8C19\u8C1B" + 
        "\u8C18\u8C1D\u8C1F\u8C20\u8C21\u8C25\u8C27\u8C2A" + 
        "\u8C2B\u8C2E\u8C2F\u8C32\u8C33\u8C35\u8C36\u5369" + 
        "\u537A\u961D\u9622\u9621\u9631\u962A\u963D\u963C" + 
        "\u9642\u9649\u9654\u965F\u9667\u966C\u9672\u9674" + 
        "\u9688\u968D\u9697\u96B0\u9097\u909B\u909D\u9099" + 
        "\u90AC\u90A1\u90B4\u90B3\u90B6\u90BA" ,
        "\u90B8\u90B0\u90CF\u90C5\u90BE\u90D0\u90C4\u90C7" + 
        "\u90D3\u90E6\u90E2\u90DC\u90D7\u90DB\u90EB\u90EF" + 
        "\u90FE\u9104\u9122\u911E\u9123\u9131\u912F\u9139" + 
        "\u9143\u9146\u520D\u5942\u52A2\u52AC\u52AD\u52BE" + 
        "\u54FF\u52D0\u52D6\u52F0\u53DF\u71EE\u77CD\u5EF4" + 
        "\u51F5\u51FC\u9B2F\u53B6\u5F01\u755A\u5DEF\u574C" + 
        "\u57A9\u57A1\u587E\u58BC\u58C5\u58D1\u5729\u572C" + 
        "\u572A\u5733\u5739\u572E\u572F\u575C\u573B\u5742" + 
        "\u5769\u5785\u576B\u5786\u577C\u577B\u5768\u576D" + 
        "\u5776\u5773\u57AD\u57A4\u578C\u57B2\u57CF\u57A7" + 
        "\u57B4\u5793\u57A0\u57D5\u57D8\u57DA\u57D9\u57D2" + 
        "\u57B8\u57F4\u57EF\u57F8\u57E4\u57DD" ,
        "\u580B\u580D\u57FD\u57ED\u5800\u581E\u5819\u5844" + 
        "\u5820\u5865\u586C\u5881\u5889\u589A\u5880\u99A8" + 
        "\u9F19\u61FF\u8279\u827D\u827F\u828F\u828A\u82A8" + 
        "\u8284\u828E\u8291\u8297\u8299\u82AB\u82B8\u82BE" + 
        "\u82B0\u82C8\u82CA\u82E3\u8298\u82B7\u82AE\u82CB" + 
        "\u82CC\u82C1\u82A9\u82B4\u82A1\u82AA\u829F\u82C4" + 
        "\u82CE\u82A4\u82E1\u8309\u82F7\u82E4\u830F\u8307" + 
        "\u82DC\u82F4\u82D2\u82D8\u830C\u82FB\u82D3\u8311" + 
        "\u831A\u8306\u8314\u8315\u82E0\u82D5\u831C\u8351" + 
        "\u835B\u835C\u8308\u8392\u833C\u8334\u8331\u839B" + 
        "\u835E\u832F\u834F\u8347\u8343\u835F\u8340\u8317" + 
        "\u8360\u832D\u833A\u8333\u8366\u8365" ,
        "\u8368\u831B\u8369\u836C\u836A\u836D\u836E\u83B0" + 
        "\u8378\u83B3\u83B4\u83A0\u83AA\u8393\u839C\u8385" + 
        "\u837C\u83B6\u83A9\u837D\u83B8\u837B\u8398\u839E" + 
        "\u83A8\u83BA\u83BC\u83C1\u8401\u83E5\u83D8\u5807" + 
        "\u8418\u840B\u83DD\u83FD\u83D6\u841C\u8438\u8411" + 
        "\u8406\u83D4\u83DF\u840F\u8403\u83F8\u83F9\u83EA" + 
        "\u83C5\u83C0\u8426\u83F0\u83E1\u845C\u8451\u845A" + 
        "\u8459\u8473\u8487\u8488\u847A\u8489\u8478\u843C" + 
        "\u8446\u8469\u8476\u848C\u848E\u8431\u846D\u84C1" + 
        "\u84CD\u84D0\u84E6\u84BD\u84D3\u84CA\u84BF\u84BA" + 
        "\u84E0\u84A1\u84B9\u84B4\u8497\u84E5\u84E3\u850C" + 
        "\u750D\u8538\u84F0\u8539\u851F\u853A" ,
        "\u8556\u853B\u84FF\u84FC\u8559\u8548\u8568\u8564" + 
        "\u855E\u857A\u77A2\u8543\u8572\u857B\u85A4\u85A8" + 
        "\u8587\u858F\u8579\u85AE\u859C\u8585\u85B9\u85B7" + 
        "\u85B0\u85D3\u85C1\u85DC\u85FF\u8627\u8605\u8629" + 
        "\u8616\u863C\u5EFE\u5F08\u593C\u5941\u8037\u5955" + 
        "\u595A\u5958\u530F\u5C22\u5C25\u5C2C\u5C34\u624C" + 
        "\u626A\u629F\u62BB\u62CA\u62DA\u62D7\u62EE\u6322" + 
        "\u62F6\u6339\u634B\u6343\u63AD\u63F6\u6371\u637A" + 
        "\u638E\u63B4\u636D\u63AC\u638A\u6369\u63AE\u63BC" + 
        "\u63F2\u63F8\u63E0\u63FF\u63C4\u63DE\u63CE\u6452" + 
        "\u63C6\u63BE\u6445\u6441\u640B\u641B\u6420\u640C" + 
        "\u6426\u6421\u645E\u6484\u646D\u6496" ,
        "\u647A\u64B7\u64B8\u6499\u64BA\u64C0\u64D0\u64D7" + 
        "\u64E4\u64E2\u6509\u6525\u652E\u5F0B\u5FD2\u7519" + 
        "\u5F11\u535F\u53F1\u53FD\u53E9\u53E8\u53FB\u5412" + 
        "\u5416\u5406\u544B\u5452\u5453\u5454\u5456\u5443" + 
        "\u5421\u5457\u5459\u5423\u5432\u5482\u5494\u5477" + 
        "\u5471\u5464\u549A\u549B\u5484\u5476\u5466\u549D" + 
        "\u54D0\u54AD\u54C2\u54B4\u54D2\u54A7\u54A6\u54D3" + 
        "\u54D4\u5472\u54A3\u54D5\u54BB\u54BF\u54CC\u54D9" + 
        "\u54DA\u54DC\u54A9\u54AA\u54A4\u54DD\u54CF\u54DE" + 
        "\u551B\u54E7\u5520\u54FD\u5514\u54F3\u5522\u5523" + 
        "\u550F\u5511\u5527\u552A\u5567\u558F\u55B5\u5549" + 
        "\u556D\u5541\u5555\u553F\u5550\u553C" ,
        "\u5537\u5556\u5575\u5576\u5577\u5533\u5530\u555C" + 
        "\u558B\u55D2\u5583\u55B1\u55B9\u5588\u5581\u559F" + 
        "\u557E\u55D6\u5591\u557B\u55DF\u55BD\u55BE\u5594" + 
        "\u5599\u55EA\u55F7\u55C9\u561F\u55D1\u55EB\u55EC" + 
        "\u55D4\u55E6\u55DD\u55C4\u55EF\u55E5\u55F2\u55F3" + 
        "\u55CC\u55CD\u55E8\u55F5\u55E4\u8F94\u561E\u5608" + 
        "\u560C\u5601\u5624\u5623\u55FE\u5600\u5627\u562D" + 
        "\u5658\u5639\u5657\u562C\u564D\u5662\u5659\u565C" + 
        "\u564C\u5654\u5686\u5664\u5671\u566B\u567B\u567C" + 
        "\u5685\u5693\u56AF\u56D4\u56D7\u56DD\u56E1\u56F5" + 
        "\u56EB\u56F9\u56FF\u5704\u570A\u5709\u571C\u5E0F" + 
        "\u5E19\u5E14\u5E11\u5E31\u5E3B\u5E3C" ,
        "\u5E37\u5E44\u5E54\u5E5B\u5E5E\u5E61\u5C8C\u5C7A" + 
        "\u5C8D\u5C90\u5C96\u5C88\u5C98\u5C99\u5C91\u5C9A" + 
        "\u5C9C\u5CB5\u5CA2\u5CBD\u5CAC\u5CAB\u5CB1\u5CA3" + 
        "\u5CC1\u5CB7\u5CC4\u5CD2\u5CE4\u5CCB\u5CE5\u5D02" + 
        "\u5D03\u5D27\u5D26\u5D2E\u5D24\u5D1E\u5D06\u5D1B" + 
        "\u5D58\u5D3E\u5D34\u5D3D\u5D6C\u5D5B\u5D6F\u5D5D" + 
        "\u5D6B\u5D4B\u5D4A\u5D69\u5D74\u5D82\u5D99\u5D9D" + 
        "\u8C73\u5DB7\u5DC5\u5F73\u5F77\u5F82\u5F87\u5F89" + 
        "\u5F8C\u5F95\u5F99\u5F9C\u5FA8\u5FAD\u5FB5\u5FBC" + 
        "\u8862\u5F61\u72AD\u72B0\u72B4\u72B7\u72B8\u72C3" + 
        "\u72C1\u72CE\u72CD\u72D2\u72E8\u72EF\u72E9\u72F2" + 
        "\u72F4\u72F7\u7301\u72F3\u7303\u72FA" ,
        "\u72FB\u7317\u7313\u7321\u730A\u731E\u731D\u7315" + 
        "\u7322\u7339\u7325\u732C\u7338\u7331\u7350\u734D" + 
        "\u7357\u7360\u736C\u736F\u737E\u821B\u5925\u98E7" + 
        "\u5924\u5902\u9963\u9967\u9968\u9969\u996A\u996B" + 
        "\u996C\u9974\u9977\u997D\u9980\u9984\u9987\u998A" + 
        "\u998D\u9990\u9991\u9993\u9994\u9995\u5E80\u5E91" + 
        "\u5E8B\u5E96\u5EA5\u5EA0\u5EB9\u5EB5\u5EBE\u5EB3" + 
        "\u8D53\u5ED2\u5ED1\u5EDB\u5EE8\u5EEA\u81BA\u5FC4" + 
        "\u5FC9\u5FD6\u5FCF\u6003\u5FEE\u6004\u5FE1\u5FE4" + 
        "\u5FFE\u6005\u6006\u5FEA\u5FED\u5FF8\u6019\u6035" + 
        "\u6026\u601B\u600F\u600D\u6029\u602B\u600A\u603F" + 
        "\u6021\u6078\u6079\u607B\u607A\u6042" ,
        "\u606A\u607D\u6096\u609A\u60AD\u609D\u6083\u6092" + 
        "\u608C\u609B\u60EC\u60BB\u60B1\u60DD\u60D8\u60C6" + 
        "\u60DA\u60B4\u6120\u6126\u6115\u6123\u60F4\u6100" + 
        "\u610E\u612B\u614A\u6175\u61AC\u6194\u61A7\u61B7" + 
        "\u61D4\u61F5\u5FDD\u96B3\u95E9\u95EB\u95F1\u95F3" + 
        "\u95F5\u95F6\u95FC\u95FE\u9603\u9604\u9606\u9608" + 
        "\u960A\u960B\u960C\u960D\u960F\u9612\u9615\u9616" + 
        "\u9617\u9619\u961A\u4E2C\u723F\u6215\u6C35\u6C54" + 
        "\u6C5C\u6C4A\u6CA3\u6C85\u6C90\u6C94\u6C8C\u6C68" + 
        "\u6C69\u6C74\u6C76\u6C86\u6CA9\u6CD0\u6CD4\u6CAD" + 
        "\u6CF7\u6CF8\u6CF1\u6CD7\u6CB2\u6CE0\u6CD6\u6CFA" + 
        "\u6CEB\u6CEE\u6CB1\u6CD3\u6CEF\u6CFE" ,
        "\u6D39\u6D27\u6D0C\u6D43\u6D48\u6D07\u6D04\u6D19" + 
        "\u6D0E\u6D2B\u6D4D\u6D2E\u6D35\u6D1A\u6D4F\u6D52" + 
        "\u6D54\u6D33\u6D91\u6D6F\u6D9E\u6DA0\u6D5E\u6D93" + 
        "\u6D94\u6D5C\u6D60\u6D7C\u6D63\u6E1A\u6DC7\u6DC5" + 
        "\u6DDE\u6E0E\u6DBF\u6DE0\u6E11\u6DE6\u6DDD\u6DD9" + 
        "\u6E16\u6DAB\u6E0C\u6DAE\u6E2B\u6E6E\u6E4E\u6E6B" + 
        "\u6EB2\u6E5F\u6E86\u6E53\u6E54\u6E32\u6E25\u6E44" + 
        "\u6EDF\u6EB1\u6E98\u6EE0\u6F2D\u6EE2\u6EA5\u6EA7" + 
        "\u6EBD\u6EBB\u6EB7\u6ED7\u6EB4\u6ECF\u6E8F\u6EC2" + 
        "\u6E9F\u6F62\u6F46\u6F47\u6F24\u6F15\u6EF9\u6F2F" + 
        "\u6F36\u6F4B\u6F74\u6F2A\u6F09\u6F29\u6F89\u6F8D" + 
        "\u6F8C\u6F78\u6F72\u6F7C\u6F7A\u6FD1" ,
        "\u6FC9\u6FA7\u6FB9\u6FB6\u6FC2\u6FE1\u6FEE\u6FDE" + 
        "\u6FE0\u6FEF\u701A\u7023\u701B\u7039\u7035\u704F" + 
        "\u705E\u5B80\u5B84\u5B95\u5B93\u5BA5\u5BB8\u752F" + 
        "\u9A9E\u6434\u5BE4\u5BEE\u8930\u5BF0\u8E47\u8B07" + 
        "\u8FB6\u8FD3\u8FD5\u8FE5\u8FEE\u8FE4\u8FE9\u8FE6" + 
        "\u8FF3\u8FE8\u9005\u9004\u900B\u9026\u9011\u900D" + 
        "\u9016\u9021\u9035\u9036\u902D\u902F\u9044\u9051" + 
        "\u9052\u9050\u9068\u9058\u9062\u905B\u66B9\u9074" + 
        "\u907D\u9082\u9088\u9083\u908B\u5F50\u5F57\u5F56" + 
        "\u5F58\u5C3B\u54AB\u5C50\u5C59\u5B71\u5C63\u5C66" + 
        "\u7FBC\u5F2A\u5F29\u5F2D\u8274\u5F3C\u9B3B\u5C6E" + 
        "\u5981\u5983\u598D\u59A9\u59AA\u59A3" ,
        "\u5997\u59CA\u59AB\u599E\u59A4\u59D2\u59B2\u59AF" + 
        "\u59D7\u59BE\u5A05\u5A06\u59DD\u5A08\u59E3\u59D8" + 
        "\u59F9\u5A0C\u5A09\u5A32\u5A34\u5A11\u5A23\u5A13" + 
        "\u5A40\u5A67\u5A4A\u5A55\u5A3C\u5A62\u5A75\u80EC" + 
        "\u5AAA\u5A9B\u5A77\u5A7A\u5ABE\u5AEB\u5AB2\u5AD2" + 
        "\u5AD4\u5AB8\u5AE0\u5AE3\u5AF1\u5AD6\u5AE6\u5AD8" + 
        "\u5ADC\u5B09\u5B17\u5B16\u5B32\u5B37\u5B40\u5C15" + 
        "\u5C1C\u5B5A\u5B65\u5B73\u5B51\u5B53\u5B62\u9A75" + 
        "\u9A77\u9A78\u9A7A\u9A7F\u9A7D\u9A80\u9A81\u9A85" + 
        "\u9A88\u9A8A\u9A90\u9A92\u9A93\u9A96\u9A98\u9A9B" + 
        "\u9A9C\u9A9D\u9A9F\u9AA0\u9AA2\u9AA3\u9AA5\u9AA7" + 
        "\u7E9F\u7EA1\u7EA3\u7EA5\u7EA8\u7EA9" ,
        "\u7EAD\u7EB0\u7EBE\u7EC0\u7EC1\u7EC2\u7EC9\u7ECB" + 
        "\u7ECC\u7ED0\u7ED4\u7ED7\u7EDB\u7EE0\u7EE1\u7EE8" + 
        "\u7EEB\u7EEE\u7EEF\u7EF1\u7EF2\u7F0D\u7EF6\u7EFA" + 
        "\u7EFB\u7EFE\u7F01\u7F02\u7F03\u7F07\u7F08\u7F0B" + 
        "\u7F0C\u7F0F\u7F11\u7F12\u7F17\u7F19\u7F1C\u7F1B" + 
        "\u7F1F\u7F21\u7F22\u7F23\u7F24\u7F25\u7F26\u7F27" + 
        "\u7F2A\u7F2B\u7F2C\u7F2D\u7F2F\u7F30\u7F31\u7F32" + 
        "\u7F33\u7F35\u5E7A\u757F\u5DDB\u753E\u9095\u738E" + 
        "\u7391\u73AE\u73A2\u739F\u73CF\u73C2\u73D1\u73B7" + 
        "\u73B3\u73C0\u73C9\u73C8\u73E5\u73D9\u987C\u740A" + 
        "\u73E9\u73E7\u73DE\u73BA\u73F2\u740F\u742A\u745B" + 
        "\u7426\u7425\u7428\u7430\u742E\u742C" ,
        "\u741B\u741A\u7441\u745C\u7457\u7455\u7459\u7477" + 
        "\u746D\u747E\u749C\u748E\u7480\u7481\u7487\u748B" + 
        "\u749E\u74A8\u74A9\u7490\u74A7\u74D2\u74BA\u97EA" + 
        "\u97EB\u97EC\u674C\u6753\u675E\u6748\u6769\u67A5" + 
        "\u6787\u676A\u6773\u6798\u67A7\u6775\u67A8\u679E" + 
        "\u67AD\u678B\u6777\u677C\u67F0\u6809\u67D8\u680A" + 
        "\u67E9\u67B0\u680C\u67D9\u67B5\u67DA\u67B3\u67DD" + 
        "\u6800\u67C3\u67B8\u67E2\u680E\u67C1\u67FD\u6832" + 
        "\u6833\u6860\u6861\u684E\u6862\u6844\u6864\u6883" + 
        "\u681D\u6855\u6866\u6841\u6867\u6840\u683E\u684A" + 
        "\u6849\u6829\u68B5\u688F\u6874\u6877\u6893\u686B" + 
        "\u68C2\u696E\u68FC\u691F\u6920\u68F9" ,
        "\u6924\u68F0\u690B\u6901\u6957\u68E3\u6910\u6971" + 
        "\u6939\u6960\u6942\u695D\u6984\u696B\u6980\u6998" + 
        "\u6978\u6934\u69CC\u6987\u6988\u69CE\u6989\u6966" + 
        "\u6963\u6979\u699B\u69A7\u69BB\u69AB\u69AD\u69D4" + 
        "\u69B1\u69C1\u69CA\u69DF\u6995\u69E0\u698D\u69FF" + 
        "\u6A2F\u69ED\u6A17\u6A18\u6A65\u69F2\u6A44\u6A3E" + 
        "\u6AA0\u6A50\u6A5B\u6A35\u6A8E\u6A79\u6A3D\u6A28" + 
        "\u6A58\u6A7C\u6A91\u6A90\u6AA9\u6A97\u6AAB\u7337" + 
        "\u7352\u6B81\u6B82\u6B87\u6B84\u6B92\u6B93\u6B8D" + 
        "\u6B9A\u6B9B\u6BA1\u6BAA\u8F6B\u8F6D\u8F71\u8F72" + 
        "\u8F73\u8F75\u8F76\u8F78\u8F77\u8F79\u8F7A\u8F7C" + 
        "\u8F7E\u8F81\u8F82\u8F84\u8F87\u8F8B" ,
        "\u8F8D\u8F8E\u8F8F\u8F98\u8F9A\u8ECE\u620B\u6217" + 
        "\u621B\u621F\u6222\u6221\u6225\u6224\u622C\u81E7" + 
        "\u74EF\u74F4\u74FF\u750F\u7511\u7513\u6534\u65EE" + 
        "\u65EF\u65F0\u660A\u6619\u6772\u6603\u6615\u6600" + 
        "\u7085\u66F7\u661D\u6634\u6631\u6636\u6635\u8006" + 
        "\u665F\u6654\u6641\u664F\u6656\u6661\u6657\u6677" + 
        "\u6684\u668C\u66A7\u669D\u66BE\u66DB\u66DC\u66E6" + 
        "\u66E9\u8D32\u8D33\u8D36\u8D3B\u8D3D\u8D40\u8D45" + 
        "\u8D46\u8D48\u8D49\u8D47\u8D4D\u8D55\u8D59\u89C7" + 
        "\u89CA\u89CB\u89CC\u89CE\u89CF\u89D0\u89D1\u726E" + 
        "\u729F\u725D\u7266\u726F\u727E\u727F\u7284\u728B" + 
        "\u728D\u728F\u7292\u6308\u6332\u63B0" ,
        "\u643F\u64D8\u8004\u6BEA\u6BF3\u6BFD\u6BF5\u6BF9" + 
        "\u6C05\u6C07\u6C06\u6C0D\u6C15\u6C18\u6C19\u6C1A" + 
        "\u6C21\u6C29\u6C24\u6C2A\u6C32\u6535\u6555\u656B" + 
        "\u724D\u7252\u7256\u7230\u8662\u5216\u809F\u809C" + 
        "\u8093\u80BC\u670A\u80BD\u80B1\u80AB\u80AD\u80B4" + 
        "\u80B7\u80E7\u80E8\u80E9\u80EA\u80DB\u80C2\u80C4" + 
        "\u80D9\u80CD\u80D7\u6710\u80DD\u80EB\u80F1\u80F4" + 
        "\u80ED\u810D\u810E\u80F2\u80FC\u6715\u8112\u8C5A" + 
        "\u8136\u811E\u812C\u8118\u8132\u8148\u814C\u8153" + 
        "\u8174\u8159\u815A\u8171\u8160\u8169\u817C\u817D" + 
        "\u816D\u8167\u584D\u5AB5\u8188\u8182\u8191\u6ED5" + 
        "\u81A3\u81AA\u81CC\u6726\u81CA\u81BB" ,
        "\u81C1\u81A6\u6B24\u6B37\u6B39\u6B43\u6B46\u6B59" + 
        "\u98D1\u98D2\u98D3\u98D5\u98D9\u98DA\u6BB3\u5F40" + 
        "\u6BC2\u89F3\u6590\u9F51\u6593\u65BC\u65C6\u65C4" + 
        "\u65C3\u65CC\u65CE\u65D2\u65D6\u7080\u709C\u7096" + 
        "\u709D\u70BB\u70C0\u70B7\u70AB\u70B1\u70E8\u70CA" + 
        "\u7110\u7113\u7116\u712F\u7131\u7173\u715C\u7168" + 
        "\u7145\u7172\u714A\u7178\u717A\u7198\u71B3\u71B5" + 
        "\u71A8\u71A0\u71E0\u71D4\u71E7\u71F9\u721D\u7228" + 
        "\u706C\u7118\u7166\u71B9\u623E\u623D\u6243\u6248" + 
        "\u6249\u793B\u7940\u7946\u7949\u795B\u795C\u7953" + 
        "\u795A\u7962\u7957\u7960\u796F\u7967\u797A\u7985" + 
        "\u798A\u799A\u79A7\u79B3\u5FD1\u5FD0" ,
        "\u603C\u605D\u605A\u6067\u6041\u6059\u6063\u60AB" + 
        "\u6106\u610D\u615D\u61A9\u619D\u61CB\u61D1\u6206" + 
        "\u8080\u807F\u6C93\u6CF6\u6DFC\u77F6\u77F8\u7800" + 
        "\u7809\u7817\u7818\u7811\u65AB\u782D\u781C\u781D" + 
        "\u7839\u783A\u783B\u781F\u783C\u7825\u782C\u7823" + 
        "\u7829\u784E\u786D\u7856\u7857\u7826\u7850\u7847" + 
        "\u784C\u786A\u789B\u7893\u789A\u7887\u789C\u78A1" + 
        "\u78A3\u78B2\u78B9\u78A5\u78D4\u78D9\u78C9\u78EC" + 
        "\u78F2\u7905\u78F4\u7913\u7924\u791E\u7934\u9F9B" + 
        "\u9EF9\u9EFB\u9EFC\u76F1\u7704\u770D\u76F9\u7707" + 
        "\u7708\u771A\u7722\u7719\u772D\u7726\u7735\u7738" + 
        "\u7750\u7751\u7747\u7743\u775A\u7768" ,
        "\u7762\u7765\u777F\u778D\u777D\u7780\u778C\u7791" + 
        "\u779F\u77A0\u77B0\u77B5\u77BD\u753A\u7540\u754E" + 
        "\u754B\u7548\u755B\u7572\u7579\u7583\u7F58\u7F61" + 
        "\u7F5F\u8A48\u7F68\u7F74\u7F71\u7F79\u7F81\u7F7E" + 
        "\u76CD\u76E5\u8832\u9485\u9486\u9487\u948B\u948A" + 
        "\u948C\u948D\u948F\u9490\u9494\u9497\u9495\u949A" + 
        "\u949B\u949C\u94A3\u94A4\u94AB\u94AA\u94AD\u94AC" + 
        "\u94AF\u94B0\u94B2\u94B4\u94B6\u94B7\u94B8\u94B9" + 
        "\u94BA\u94BC\u94BD\u94BF\u94C4\u94C8\u94C9\u94CA" + 
        "\u94CB\u94CC\u94CD\u94CE\u94D0\u94D1\u94D2\u94D5" + 
        "\u94D6\u94D7\u94D9\u94D8\u94DB\u94DE\u94DF\u94E0" + 
        "\u94E2\u94E4\u94E5\u94E7\u94E8\u94EA" ,
        "\u94E9\u94EB\u94EE\u94EF\u94F3\u94F4\u94F5\u94F7" + 
        "\u94F9\u94FC\u94FD\u94FF\u9503\u9502\u9506\u9507" + 
        "\u9509\u950A\u950D\u950E\u950F\u9512\u9513\u9514" + 
        "\u9515\u9516\u9518\u951B\u951D\u951E\u951F\u9522" + 
        "\u952A\u952B\u9529\u952C\u9531\u9532\u9534\u9536" + 
        "\u9537\u9538\u953C\u953E\u953F\u9542\u9535\u9544" + 
        "\u9545\u9546\u9549\u954C\u954E\u954F\u9552\u9553" + 
        "\u9554\u9556\u9557\u9558\u9559\u955B\u955E\u955F" + 
        "\u955D\u9561\u9562\u9564\u9565\u9566\u9567\u9568" + 
        "\u9569\u956A\u956B\u956C\u956F\u9571\u9572\u9573" + 
        "\u953A\u77E7\u77EC\u96C9\u79D5\u79ED\u79E3\u79EB" + 
        "\u7A06\u5D47\u7A03\u7A02\u7A1E\u7A14" ,
        "\u7A39\u7A37\u7A51\u9ECF\u99A5\u7A70\u7688\u768E" + 
        "\u7693\u7699\u76A4\u74DE\u74E0\u752C\u9E20\u9E22" + 
        "\u9E28\u9E29\u9E2A\u9E2B\u9E2C\u9E32\u9E31\u9E36" + 
        "\u9E38\u9E37\u9E39\u9E3A\u9E3E\u9E41\u9E42\u9E44" + 
        "\u9E46\u9E47\u9E48\u9E49\u9E4B\u9E4C\u9E4E\u9E51" + 
        "\u9E55\u9E57\u9E5A\u9E5B\u9E5C\u9E5E\u9E63\u9E66" + 
        "\u9E67\u9E68\u9E69\u9E6A\u9E6B\u9E6C\u9E71\u9E6D" + 
        "\u9E73\u7592\u7594\u7596\u75A0\u759D\u75AC\u75A3" + 
        "\u75B3\u75B4\u75B8\u75C4\u75B1\u75B0\u75C3\u75C2" + 
        "\u75D6\u75CD\u75E3\u75E8\u75E6\u75E4\u75EB\u75E7" + 
        "\u7603\u75F1\u75FC\u75FF\u7610\u7600\u7605\u760C" + 
        "\u7617\u760A\u7625\u7618\u7615\u7619" ,
        "\u761B\u763C\u7622\u7620\u7640\u762D\u7630\u763F" + 
        "\u7635\u7643\u763E\u7633\u764D\u765E\u7654\u765C" + 
        "\u7656\u766B\u766F\u7FCA\u7AE6\u7A78\u7A79\u7A80" + 
        "\u7A86\u7A88\u7A95\u7AA6\u7AA0\u7AAC\u7AA8\u7AAD" + 
        "\u7AB3\u8864\u8869\u8872\u887D\u887F\u8882\u88A2" + 
        "\u88C6\u88B7\u88BC\u88C9\u88E2\u88CE\u88E3\u88E5" + 
        "\u88F1\u891A\u88FC\u88E8\u88FE\u88F0\u8921\u8919" + 
        "\u8913\u891B\u890A\u8934\u892B\u8936\u8941\u8966" + 
        "\u897B\u758B\u80E5\u76B2\u76B4\u77DC\u8012\u8014" + 
        "\u8016\u801C\u8020\u8022\u8025\u8026\u8027\u8029" + 
        "\u8028\u8031\u800B\u8035\u8043\u8046\u804D\u8052" + 
        "\u8069\u8071\u8983\u9878\u9880\u9883" ,
        "\u9889\u988C\u988D\u988F\u9894\u989A\u989B\u989E" + 
        "\u989F\u98A1\u98A2\u98A5\u98A6\u864D\u8654\u866C" + 
        "\u866E\u867F\u867A\u867C\u867B\u86A8\u868D\u868B" + 
        "\u86AC\u869D\u86A7\u86A3\u86AA\u8693\u86A9\u86B6" + 
        "\u86C4\u86B5\u86CE\u86B0\u86BA\u86B1\u86AF\u86C9" + 
        "\u86CF\u86B4\u86E9\u86F1\u86F2\u86ED\u86F3\u86D0" + 
        "\u8713\u86DE\u86F4\u86DF\u86D8\u86D1\u8703\u8707" + 
        "\u86F8\u8708\u870A\u870D\u8709\u8723\u873B\u871E" + 
        "\u8725\u872E\u871A\u873E\u8748\u8734\u8731\u8729" + 
        "\u8737\u873F\u8782\u8722\u877D\u877E\u877B\u8760" + 
        "\u8770\u874C\u876E\u878B\u8753\u8763\u877C\u8764" + 
        "\u8759\u8765\u8793\u87AF\u87A8\u87D2" ,
        "\u87C6\u8788\u8785\u87AD\u8797\u8783\u87AB\u87E5" + 
        "\u87AC\u87B5\u87B3\u87CB\u87D3\u87BD\u87D1\u87C0" + 
        "\u87CA\u87DB\u87EA\u87E0\u87EE\u8816\u8813\u87FE" + 
        "\u880A\u881B\u8821\u8839\u883C\u7F36\u7F42\u7F44" + 
        "\u7F45\u8210\u7AFA\u7AFD\u7B08\u7B03\u7B04\u7B15" + 
        "\u7B0A\u7B2B\u7B0F\u7B47\u7B38\u7B2A\u7B19\u7B2E" + 
        "\u7B31\u7B20\u7B25\u7B24\u7B33\u7B3E\u7B1E\u7B58" + 
        "\u7B5A\u7B45\u7B75\u7B4C\u7B5D\u7B60\u7B6E\u7B7B" + 
        "\u7B62\u7B72\u7B71\u7B90\u7BA6\u7BA7\u7BB8\u7BAC" + 
        "\u7B9D\u7BA8\u7B85\u7BAA\u7B9C\u7BA2\u7BAB\u7BB4" + 
        "\u7BD1\u7BC1\u7BCC\u7BDD\u7BDA\u7BE5\u7BE6\u7BEA" + 
        "\u7C0C\u7BFE\u7BFC\u7C0F\u7C16\u7C0B" ,
        "\u7C1F\u7C2A\u7C26\u7C38\u7C41\u7C40\u81FE\u8201" + 
        "\u8202\u8204\u81EC\u8844\u8221\u8222\u8223\u822D" + 
        "\u822F\u8228\u822B\u8238\u823B\u8233\u8234\u823E" + 
        "\u8244\u8249\u824B\u824F\u825A\u825F\u8268\u887E" + 
        "\u8885\u8888\u88D8\u88DF\u895E\u7F9D\u7F9F\u7FA7" + 
        "\u7FAF\u7FB0\u7FB2\u7C7C\u6549\u7C91\u7C9D\u7C9C" + 
        "\u7C9E\u7CA2\u7CB2\u7CBC\u7CBD\u7CC1\u7CC7\u7CCC" + 
        "\u7CCD\u7CC8\u7CC5\u7CD7\u7CE8\u826E\u66A8\u7FBF" + 
        "\u7FCE\u7FD5\u7FE5\u7FE1\u7FE6\u7FE9\u7FEE\u7FF3" + 
        "\u7CF8\u7D77\u7DA6\u7DAE\u7E47\u7E9B\u9EB8\u9EB4" + 
        "\u8D73\u8D84\u8D94\u8D91\u8DB1\u8D67\u8D6D\u8C47" + 
        "\u8C49\u914A\u9150\u914E\u914F\u9164" ,
        "\u9162\u9161\u9170\u9169\u916F\u917D\u917E\u9172" + 
        "\u9174\u9179\u918C\u9185\u9190\u918D\u9191\u91A2" + 
        "\u91A3\u91AA\u91AD\u91AE\u91AF\u91B5\u91B4\u91BA" + 
        "\u8C55\u9E7E\u8DB8\u8DEB\u8E05\u8E59\u8E69\u8DB5" + 
        "\u8DBF\u8DBC\u8DBA\u8DC4\u8DD6\u8DD7\u8DDA\u8DDE" + 
        "\u8DCE\u8DCF\u8DDB\u8DC6\u8DEC\u8DF7\u8DF8\u8DE3" + 
        "\u8DF9\u8DFB\u8DE4\u8E09\u8DFD\u8E14\u8E1D\u8E1F" + 
        "\u8E2C\u8E2E\u8E23\u8E2F\u8E3A\u8E40\u8E39\u8E35" + 
        "\u8E3D\u8E31\u8E49\u8E41\u8E42\u8E51\u8E52\u8E4A" + 
        "\u8E70\u8E76\u8E7C\u8E6F\u8E74\u8E85\u8E8F\u8E94" + 
        "\u8E90\u8E9C\u8E9E\u8C78\u8C82\u8C8A\u8C85\u8C98" + 
        "\u8C94\u659B\u89D6\u89DE\u89DA\u89DC" ,
        "\u89E5\u89EB\u89EF\u8A3E\u8B26\u9753\u96E9\u96F3" + 
        "\u96EF\u9706\u9701\u9708\u970F\u970E\u972A\u972D" + 
        "\u9730\u973E\u9F80\u9F83\u9F85\u9F86\u9F87\u9F88" + 
        "\u9F89\u9F8A\u9F8C\u9EFE\u9F0B\u9F0D\u96B9\u96BC" + 
        "\u96BD\u96CE\u96D2\u77BF\u96E0\u928E\u92AE\u92C8" + 
        "\u933E\u936A\u93CA\u938F\u943E\u946B\u9C7F\u9C82" + 
        "\u9C85\u9C86\u9C87\u9C88\u7A23\u9C8B\u9C8E\u9C90" + 
        "\u9C91\u9C92\u9C94\u9C95\u9C9A\u9C9B\u9C9E\u9C9F" + 
        "\u9CA0\u9CA1\u9CA2\u9CA3\u9CA5\u9CA6\u9CA7\u9CA8" + 
        "\u9CA9\u9CAB\u9CAD\u9CAE\u9CB0\u9CB1\u9CB2\u9CB3" + 
        "\u9CB4\u9CB5\u9CB6\u9CB7\u9CBA\u9CBB\u9CBC\u9CBD" + 
        "\u9CC4\u9CC5\u9CC6\u9CC7\u9CCA\u9CCB" ,
        "\u9CCC\u9CCD\u9CCE\u9CCF\u9CD0\u9CD3\u9CD4\u9CD5" + 
        "\u9CD7\u9CD8\u9CD9\u9CDC\u9CDD\u9CDF\u9CE2\u977C" + 
        "\u9785\u9791\u9792\u9794\u97AF\u97AB\u97A3\u97B2" + 
        "\u97B4\u9AB1\u9AB0\u9AB7\u9E58\u9AB6\u9ABA\u9ABC" + 
        "\u9AC1\u9AC0\u9AC5\u9AC2\u9ACB\u9ACC\u9AD1\u9B45" + 
        "\u9B43\u9B47\u9B49\u9B48\u9B4D\u9B51\u98E8\u990D" + 
        "\u992E\u9955\u9954\u9ADF\u9AE1\u9AE6\u9AEF\u9AEB" + 
        "\u9AFB\u9AED\u9AF9\u9B08\u9B0F\u9B13\u9B1F\u9B23" + 
        "\u9EBD\u9EBE\u7E3B\u9E82\u9E87\u9E88\u9E8B\u9E92" + 
        "\u93D6\u9E9D\u9E9F\u9EDB\u9EDC\u9EDD\u9EE0\u9EDF" + 
        "\u9EE2\u9EE9\u9EE7\u9EE5\u9EEA\u9EEF\u9F22\u9F2C" + 
        "\u9F2F\u9F39\u9F37\u9F3D\u9F3E\u9F44" ,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
        };

    static char[][] b2c = new char[b2cStr.length][];
    static char[] b2cSB;
    private static volatile boolean b2cInitialized = false;

    static void initb2c() {
        if (b2cInitialized)
            return;
        synchronized (b2c) {
            if (b2cInitialized)
                return;
            for (int i = 0; i < b2cStr.length; i++) {
                if (b2cStr[i] == null)
                    b2c[i] = DoubleByte.B2C_UNMAPPABLE;
                else
                    b2c[i] = b2cStr[i].toCharArray();
            }
            b2cSB = b2cSBStr.toCharArray();
            b2cInitialized = true;
        }
    }

    static char[] c2b = new char[0x6200];
    static char[] c2bIndex = new char[0x100];
    private static volatile boolean c2bInitialized = false;

    static void initc2b() {
        if (c2bInitialized)
            return;
        synchronized (c2b) {
            if (c2bInitialized)
                return;
            String b2cNR = null;
            String c2bNR = null;
            DoubleByte.Encoder.initC2B(b2cStr, b2cSBStr, b2cNR, c2bNR,
                                       0xa1, 0xfe,
                                       c2b, c2bIndex);
            c2bInitialized = true;
        }
    }
}
