//===- PrintDebugInfo.h -- Print Debug Info Pass Header -----*- C++ -*-----===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//
//===----------------------------------------------------------------------===//
// Copyright 2013-2020 Azul Systems, Inc.  All Rights Reserved.
// http://www.azul.com
// Azul Systems is a contributor to the LLVM Team.
// Distributed under the same license terms detailed in LICENSE.TXT above.
//===----------------------------------------------------------------------===//
// \file
// This file provides the interface for PrintDebugInfo pass.
//
//===----------------------------------------------------------------------===//

#ifndef PRINTDEBUGINFO_H
#define PRINTDEBUGINFO_H

#include "llvm/IR/AssemblyAnnotationWriter.h"

namespace llvm {

class Module;

struct PrintDebugInfo : PassInfoMixin<PrintDebugInfo> {
  raw_ostream &OS = dbgs();

  PreservedAnalyses run(Module &M, ModuleAnalysisManager &AM);
};
}

#endif

