//===- llvm/Orca/OrcaVerifier.h - Orca Specific Module Verification  ------===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//
//===----------------------------------------------------------------------===//
// Copyright 2019 Azul Systems, Inc.  All Rights Reserved.
// http://www.azul.com
// Azul Systems is a contributor to the LLVM Team.
// Distributed under the same license terms detailed in LICENSE.TXT above.
//===----------------------------------------------------------------------===//
// \file
// This file defines a verification pass that checks module features unique to
// Azul's Orca compiler.
///
//===----------------------------------------------------------------------===//

#include "llvm/IR/PassManager.h"

namespace llvm {

class Function;

struct OrcaVerifierPass : PassInfoMixin<OrcaVerifierPass> {

public:
  OrcaVerifierPass() = default;

  PreservedAnalyses run(Function &F, FunctionAnalysisManager &MAM);
};

} // end namespace llvm
