//===-- OrcaTypes.h - Helpers for Handling Java heap Types ------*- C++ -*-===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//
// Copyright 2013-2018 Azul Systems, Inc.  All Rights Reserved.
// http://www.azul.com
// Azul Systems is a contributor to the LLVM Team.
// Distributed under the same license terms detailed in LICENSE.TXT above.
//===----------------------------------------------------------------------===//
//
//  This file provides generic Java heap type handling logic.
//
//  Java OOPs (object oriented pointers) are represented in LLVM IR as an
//  PointerType in addrspace(1) to a named StructType with a name that starts
//  with 'j'.
//
//===----------------------------------------------------------------------===//

#ifndef LLVM_AZUL_TYPES_H
#define LLVM_AZUL_TYPES_H

#include "llvm/IR/Orca/Abstractions.h"
#include "llvm/Orca/VMInterface.h"
#include "llvm/Orca/Utils.h"

#include "llvm/IR/DerivedTypes.h"
#include "llvm/IR/Value.h"


namespace llvm {
  struct OrcaTypes {
    // WARNING: There is a Zing side dependency on the existance of this
    // definition.  It needs to be updated and removed.
    static const unsigned JavaHeapAddrSpace = azul::JavaHeapAddrSpace;
  };
}

#endif
