//===- llvm/Orca/OrcaSafepointIRVerifier.h -   ----------------------------===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//
//===----------------------------------------------------------------------===//
// Copyright 2019 Azul Systems, Inc.  All Rights Reserved.
// http://www.azul.com
// Azul Systems is a contributor to the LLVM Team.
// Distributed under the same license terms detailed in LICENSE.TXT above.
//===----------------------------------------------------------------------===//
// \file
// Wrapper to LLVM's SafepointIRVerifer. Ensures the relocation is already done.
///
//===----------------------------------------------------------------------===//

#include "llvm/IR/PassManager.h"
#include "llvm/IR/SafepointIRVerifier.h"
#include "llvm/Orca/Utils.h"

namespace llvm {

class Function;

struct OrcaSafepointIRVerifierPass
    : PassInfoMixin<OrcaSafepointIRVerifierPass> {
  SafepointIRVerifierPass Verifier;

public:
  OrcaSafepointIRVerifierPass() = default;

  PreservedAnalyses run(Function &F, FunctionAnalysisManager &FAM) {
    if (azul::Utils::hasExplicitRelocations(*(F.getParent())))
      return PreservedAnalyses::all();
    return Verifier.run(F, FAM);
  }
};

} // end namespace llvm
