//===-- llvm/Orca/AzulPasses.h - Azul Transformations ---------------------*- C++ -*-===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//
// Copyright 2013-2018 Azul Systems, Inc.  All Rights Reserved.
// http://www.azul.com
// Azul Systems is a contributor to the LLVM Team.
// Distributed under the same license terms detailed in LICENSE.TXT above.
//===----------------------------------------------------------------------===//
//
// This header file defines prototypes for accessor functions that expose passes
// in the Azul library.
//
//===----------------------------------------------------------------------===//

#ifndef LLVM_AZUL_AZULPASSES_H
#define LLVM_AZUL_AZULPASSES_H

#include "llvm/ADT/StringRef.h"

namespace llvm {

class Pass;
class FunctionPass;
class ModulePass;
class ImmutablePass;

//===----------------------------------------------------------------------===//
//
// AddGCBarriers - Azul's add LVBs and SVBs pass.
//
FunctionPass *createAddGCBarriersLegacyPass();

//===----------------------------------------------------------------------===//
//
// OrcaVerifier - IR Verification specific to Azul's Orca compiler.
//
FunctionPass *createOrcaVerifierPass();

//===----------------------------------------------------------------------===//
//
// EnableLateInlining - Azul's enable late function inlining pass.  Argument is
// the subset of late inline candidates to enable.
//
Pass *createEnableLateInliningLegacyPass(StringRef Name = "");

//===----------------------------------------------------------------------===//
//
// OrcaOptPipeline - Azul's Java optimization pipeline.
//
ModulePass *createOrcaOptLegacyPipelinePass();

//===----------------------------------------------------------------------===//
//
// AzulDropInliningCandidates - Drop function bodies marked with
// "is-inlining-candidate".  Azul specific functionality.
//
ModulePass *createAzulDropInliningCandidatesLegacyPass();

//===----------------------------------------------------------------------===//
//
// ThreadLocalOpt - Replace abstractions with their thread local variants when
// legal.
//
Pass *createThreadLocalOptPass();
  
//===----------------------------------------------------------------------===//
//
// DropAtomics - Drop the atomic marker from any unordered atomic loads or
// stores.  Note that this is a utility pass, but the transform performed is
// *unsound*.  Use with care.
//
Pass *createDropAtomicsLegacyPass();

//===----------------------------------------------------------------------===//
//
// AzulAAWrapperPass - Azul specific alias analysis.
//
ImmutablePass *createAzulAAWrapperPass();

//===----------------------------------------------------------------------===//
//
// GenerateInlineCacheCalls - Replace indirect invocations with inline cache
// calls
//
ModulePass *createGenerateInlineCacheCallsLegacyPass();

//===----------------------------------------------------------------------===//
//
// PruneSwitchCases - prune switch(get_klass_id(V)) cases using static type
// of V
//
FunctionPass *createPruneSwitchCasesLegacyPass();

//===----------------------------------------------------------------------===//
//
// PropagateJavaTypes - propagate java type information from function attributes
// to the values inside of the function.
//
FunctionPass *createPropagateJavaTypesLegacyPass();

ModulePass *createAzulHealCorrelatedMetadataLegacyPass();

//===----------------------------------------------------------------------===//
//
// MakeTransactional - wraps selected function into hardware transactions
//
FunctionPass *createMakeTransactionalPass();

FunctionPass *createNormalizeProfileLegacyPass();

FunctionPass *createLoopMetadataUpdateLegacyPass();

//===----------------------------------------------------------------------===//
//
// ExpandSmallObjArraycopy -- replace small known-constant length
//  memcpy/memmove of pointer-to-oop with corresponding load/stores
//

ModulePass* createExpandSmallObjArraycopyLegacyPass();

//===----------------------------------------------------------------------===//
//
// RThreadAccess - Add Thread Pointer Register (rthread, specified by
// the option -orca-reserved-thread-pointer-register) as a base to
// addrspace(azul::JavaThreadTLSAddrSpace) pointers.
//
FunctionPass *createRThreadAccessPass();

} // End llvm namespace

#endif
