//===- llvm/Orca/OrcaPassStatsInstrumentation.h - Definition of the
// OrcaPassStatsInstrumentation class --------*- C++ -*-===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//
//===----------------------------------------------------------------------===//
// Copyright 2024 Azul Systems, Inc.  All Rights Reserved.
// http://www.azul.com
// Azul Systems is a contributor to the LLVM Team.
// Distributed under the same license terms detailed in LICENSE.TXT above.
//===----------------------------------------------------------------------===//
// \file
// Collects and dumps basic pass execution statistics, like how many times a
// pass ran and how many times the IR was changed.
//===----------------------------------------------------------------------===//
#include "llvm/ADT/StringMap.h"
#include "llvm/IR/PassInstrumentation.h"

namespace llvm {
namespace json {
  class OStream;
}

// Counts how many times pass a pass was invoked and how many of the invocations
// resulted in IR change.
class OrcaPassStatsInstrumentation {
public:
  // Upon destruction, it'll print the stats to CompileInfoOut, if it was
  // provided, and/or to stderr.
  ~OrcaPassStatsInstrumentation();

  void registerCallbacks(PassInstrumentationCallbacks &PIC);
  void setOutStream(json::OStream *OS) {
    CompileInfoOut = OS;
  }

private:
  struct PassStats {
    unsigned TimesInvoked = 0;
    unsigned TimesChangedIR = 0; // It can't be greater than `TimesInvoked`.
  };

  StringMap<PassStats> Stats;
  json::OStream *CompileInfoOut = nullptr;

  void afterPass(StringRef PassID, const PreservedAnalyses &PA);
};

}
