//===- OrcaOptIsSubtypeOf.h---------------------------------*- C++ -*----===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//
//===----------------------------------------------------------------------===//
// Copyright 2021 Azul Systems, Inc.  All Rights Reserved.
// http://www.azul.com
// Azul Systems is a contributor to the LLVM Team.
// Distributed under the same license terms detailed in LICENSE.TXT above.
//===----------------------------------------------------------------------===//
//
// This file provides the interface for OrcaOptIsSubtypeOfPass pass.
//
//===----------------------------------------------------------------------===//

#include "llvm/IR/PassManager.h"

namespace llvm {

class DominatorTree;
class LoopInfo;
class MemorySSAUpdater;
class DomTreeUpdater;

class OrcaOptIsSubtypeOfPass : public PassInfoMixin<OrcaOptIsSubtypeOfPass> {

public:
  OrcaOptIsSubtypeOfPass() = default;

  PreservedAnalyses run(Function &F, FunctionAnalysisManager &AM);

private:
  bool optimize(Function &F, DomTreeUpdater *DTU, LoopInfo *LI,
                MemorySSAUpdater *MSSA) const;
};

} // end namespace llvm
