//===- llvm/Orca/OrcaIRStatsInstrumentation.h - Definition of the
// OrcaIRStatsInstrumentation class --------*- C++ -*-===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//
//===----------------------------------------------------------------------===//
// Copyright 2019 Azul Systems, Inc.  All Rights Reserved.
// http://www.azul.com
// Azul Systems is a contributor to the LLVM Team.
// Distributed under the same license terms detailed in LICENSE.TXT above.
//===----------------------------------------------------------------------===//
// \file
// Collect dump different IR statistics for each executed pass.
//===----------------------------------------------------------------------===//
#include "llvm/IR/Module.h"
#include "llvm/Passes/StandardInstrumentations.h"

#include <map>
#include <optional>
#include <string>

namespace llvm {
enum OrcaIRStatsType {
  OIRS_None,
  OIRS_Module,
  OIRS_TopLevel
};

class OrcaIRStatsInstrumentation {
private:
  struct Stats {
    int64_t InstructionCount = 0;
    int64_t CallsiteCount = 0;
    int64_t JavaCallsiteCount = 0;
    int64_t IndirectCallsiteCount = 0;
    int64_t DeclaredFunctions = 0;
    int64_t DefinedFunctions = 0;
  };

public:
  OrcaIRStatsInstrumentation() = default;
  ~OrcaIRStatsInstrumentation() = default;

  void registerCallbacks(PassInstrumentationCallbacks &PIC);

private:
  std::map<std::string, Stats> Data;
  void saveStatsBeforePass(StringRef PassID, Any IR);
  void dumpStatsAfterPass(StringRef PassID, Any IR);
  void computeStats(const Module *M, Stats &S);
  std::optional<std::pair<const Module *, std::string> >
  unwrapModule(StringRef PassID, Any IR);
  bool isIRInTopLevelMethod(StringRef PassID, Any IR);
};
}
