//===- llvm/Orca/AzulHealCorrelatedMetadata.h - Definition of the AzulHealCorrelatedMetadata class --------*- C++ -*-===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
// 
//===----------------------------------------------------------------------===//
// Copyright 2013-2018 Azul Systems, Inc.  All Rights Reserved.
// http://www.azul.com
// Azul Systems is a contributor to the LLVM Team.
// Distributed under the same license terms detailed in LICENSE.TXT above.
//===----------------------------------------------------------------------===//
// \file
// This file provides the interface for Azul's own Heal Correlated Metadata
// pass.
///
//===----------------------------------------------------------------------===//

#include "llvm/IR/PassManager.h"

namespace llvm {

class Module;

struct AzulHealCorrelatedMetadata : PassInfoMixin<AzulHealCorrelatedMetadata> {

public:
  AzulHealCorrelatedMetadata() = default;

  PreservedAnalyses run(Module &M, ModuleAnalysisManager &MAM) {
    return runImpl(M);
  }
  ;

  /// Helper used by public run method and by the legacy pass
  PreservedAnalyses runImpl(Module &M);
};

} // end namespace llvm
