//===- llvm/Orca/OrcaDeoptimizeColdPaths.h - --------------------*- C++ -*-===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//
//===----------------------------------------------------------------------===//
// Copyright 2013-2022 Azul Systems, Inc.  All Rights Reserved.
// http://www.azul.com
// Azul Systems is a contributor to the LLVM Team.
// Distributed under the same license terms detailed in LICENSE.TXT above.
//===----------------------------------------------------------------------===//
// \file
// This file provides the interface for Azul's own OrcaDeoptimizeColdPaths
// pass. This pass analyzes the azul.maybe_deoptimize call sites and tries
// to figure out whether inserting deopt there is profitable or not.
///
//===----------------------------------------------------------------------===//

#ifndef ORCADEOPTIMIZECOLDPATHS
#define ORCADEOPTIMIZECOLDPATHS

#include "llvm/ADT/SmallPtrSet.h"
#include "llvm/Analysis/TargetTransformInfo.h"
#include "llvm/IR/Dominators.h"
#include "llvm/IR/PassManager.h"

namespace llvm {

class BasicBlock;
class CallInst;

class OrcaDeoptimizeColdPaths
    : public PassInfoMixin<OrcaDeoptimizeColdPaths> {
public:
  OrcaDeoptimizeColdPaths() = default;

  PreservedAnalyses run(Function &F, FunctionAnalysisManager &AM);

  bool runImpl(Function &F, DominatorTree &DT, TargetTransformInfo &TTI,
               const SmallVectorImpl<CallInst *> &DeoptCandidates,
               const SmallPtrSetImpl<BasicBlock *> &CandidateBlocks);
};

} // end namespace llvm

#endif /* ORCADEOPTIMIZECOLDPATHS */
