//===- JITEventCallbacks.h - register callbacks for JIT events --*- C++ -*-===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//
//===----------------------------------------------------------------------===//
// Copyright 2013-2018 Azul Systems, Inc.  All Rights Reserved.
// http://www.azul.com
// Azul Systems is a contributor to the LLVM Team.
// Distributed under the same license terms detailed in LICENSE.TXT above.
//===----------------------------------------------------------------------===//
// \file
// Defines a simple interface for registration of callbacks run on JIT
// events, most notably ObjectLoaded event.
//
//===----------------------------------------------------------------------===//

#ifndef LLVM_JIT_EVENT_CALLBACKS_H
#define LLVM_JIT_EVENT_CALLBACKS_H

#include "llvm/ExecutionEngine/JITEventListener.h"

namespace llvm {
class ExecutionEngine;
using JITEventObjectLoadedCallbackType =
    void(JITEventListener::ObjectKey, const object::ObjectFile &,
         const RuntimeDyld::LoadedObjectInfo &);
} // namespace llvm

namespace azul {
void registerObjectLoadedJITCallback(
    llvm::ExecutionEngine &engine,
    std::function<llvm::JITEventObjectLoadedCallbackType> &&Callback);

void unregisterObjectLoadedJITCallbacks(llvm::ExecutionEngine &engine);
} // namespace azul

#endif
