//===- llvm/Orca/GenerateInlineCacheCalls.h - Definition of the GenerateInlineCacheCalls class --------*- C++ -*-===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
// 
//===----------------------------------------------------------------------===//
// Copyright 2013-2018 Azul Systems, Inc.  All Rights Reserved.
// http://www.azul.com
// Azul Systems is a contributor to the LLVM Team.
// Distributed under the same license terms detailed in LICENSE.TXT above.
//===----------------------------------------------------------------------===//
// \file
// This file provides the interface for Azul's own Generate Inline Cache pass.
///
//===----------------------------------------------------------------------===//

#include "llvm/IR/PassManager.h"

namespace llvm {

class Module;
class CallBase;

struct GenerateInlineCacheCalls : PassInfoMixin<GenerateInlineCacheCalls> {
  bool tryGenerateInlineCacheCall(CallBase *CB);

public:
  GenerateInlineCacheCalls() = default;

  PreservedAnalyses run(Module &M, ModuleAnalysisManager &MAM);

};

} // end namespace llvm
