//===- FlowSensitiveOptimizeAllocations.h - -opt-alloc-fs pass ------------===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//
//===----------------------------------------------------------------------===//
// Copyright 2013-2018 Azul Systems, Inc.  All Rights Reserved.
// http://www.azul.com
// Azul Systems is a contributor to the LLVM Team.
// Distributed under the same license terms detailed in LICENSE.TXT above.
//===----------------------------------------------------------------------===//
// \file
// This pass tries to remove redundant allocations.
// TODO: CURRENTLY THIS IS JUST A FRAMEWORK.
//===----------------------------------------------------------------------===//

#include "llvm/IR/PassManager.h"
#include "llvm/Analysis/Orca/FlowSensitiveEA.h"

namespace azul {
namespace orca {
class OrcaPipeline;
}
} // namespace azul

namespace llvm {

struct OrcaFlowSensitiveOptimizeAllocationsPass
    : PassInfoMixin<OrcaFlowSensitiveOptimizeAllocationsPass> {
  PreservedAnalyses run(Function &F, FunctionAnalysisManager &FAM);

  bool rewriteUsingFlowSensitiveEA(Function &F, FunctionAnalysisManager &FAM) {
    return !run(F, FAM).areAllPreserved();
  }
};

struct OrcaSymbolicOptimizeAllocationsPass
    : PassInfoMixin<OrcaSymbolicOptimizeAllocationsPass> {
  PreservedAnalyses run(Function &F, FunctionAnalysisManager &FAM);
};
} // end namespace llvm
