//===-- VMQueryCache.h ------------------------------------------*- C++ -*-===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//
// Copyright 2013-2018 Azul Systems, Inc.  All Rights Reserved.
// http://www.azul.com
// Azul Systems is a contributor to the LLVM Team.
// Distributed under the same license terms detailed in LICENSE.TXT above.
//===----------------------------------------------------------------------===//

#ifndef LLVM_AZUL_VM_QUERY_CACHE_H
#define LLVM_AZUL_VM_QUERY_CACHE_H

#include "llvm/IR/Orca/FunctionCache.h"
#include "llvm/IR/Orca/QueryTypes.h"
#include "llvm/Support/Orca/QueryCache.h"

namespace azul {

namespace orca {
class JavaTypeInfo;
struct FieldInfo;
class FunctionInfo;
}

template <int Tag> struct VMQueryTypeTraits {};

namespace VMQuery {
enum {
#define DEF_KIND_ENUM(ALL_CAPS_NAME, A, B, C, D, E) KIND_##ALL_CAPS_NAME,

  QUERY_TYPES_DO_NOARGS(DEF_KIND_ENUM)

#undef DEF_KIND_ENUM
      KIND_MAX
};
}

#define DEF_QT_TRAIT(ALL_CAPS_NAME, RType, CCName, AssertIdem, CStringName, Callback) \
  template <> struct VMQueryTypeTraits<VMQuery::KIND_##ALL_CAPS_NAME> {        \
    static constexpr bool AssertIdempotent = AssertIdem;                       \
    static constexpr const char* TagName = #ALL_CAPS_NAME;                     \
    static constexpr const char* CallbackName = #Callback;                     \
    typedef RType ResultTy;                                                    \
  };

QUERY_TYPES_DO_NOARGS(DEF_QT_TRAIT)

#undef DEF_QT_TRAIT

class VMQueryCache : public QueryCache<VMQuery::KIND_MAX, VMQueryTypeTraits> {
  internal::FunctionCache FC;

public:
  internal::FunctionCache &getFunctionCache() { return FC; }

  /// deserialize query cache from the buffer, on failure return true and fill
  /// the error message.
  /// TODO: Consider returning llvm::StringError instead of ErrMsg argument.
  bool read(llvm::StringRef Buffer, std::string& ErrMsg);

  /// deserialize query cache from the buffer, report fatal error on failure.
  void read(llvm::StringRef Buffer);

  /// serialize query cache to the stream.
  void write(llvm::raw_ostream &QueryCacheOut);
};

void verifyQueryCallback(int QueryKind, Query *Q);
}

#endif
