//===-- EnableDownstreamChanges.h -------------------------------*- C++ -*-===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//
// Copyright 2020-2020 Azul Systems, Inc.  All Rights Reserved.
// http://www.azul.com
// Azul Systems is a contributor to the LLVM Team.
// Distributed under the same license terms detailed in LICENSE.TXT above.
//===----------------------------------------------------------------------===//
//
// Defines the function to distinguish upstream and downstream changes
// at runtime.
//
//===----------------------------------------------------------------------===//

#ifndef LLVM_ORCA_ENABLE_DOWNSTREAM_CHANGES_H
#define LLVM_ORCA_ENABLE_DOWNSTREAM_CHANGES_H

namespace azul {
namespace Utils {

/// Return true if our downstream changes to common code should be enabled.
/// This is the generic enable flag for anything which doesn't have a more fine
/// grained one.  As a reminder, our policy is that unless a flag is set, Orca
/// behavior should *exactly match* upstream behavior.
bool enableDownstreamChanges();

} // End Utils namespace
} // End azul namespace

#endif // LLVM_ORCA_ENABLE_DOWNSTREAM_CHANGES_H
