/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.AESCrypt;
import com.sun.crypto.provider.FeedbackCipher;
import com.sun.crypto.provider.RangeUtil;
import com.sun.crypto.provider.SymmetricCipher;
import java.security.InvalidKeyException;

final class ElectronicCodeBook
extends FeedbackCipher {
    ElectronicCodeBook(SymmetricCipher symmetricCipher) {
        super(symmetricCipher);
    }

    @Override
    String getFeedback() {
        return "ECB";
    }

    @Override
    void reset() {
    }

    @Override
    void save() {
    }

    @Override
    void restore() {
    }

    @Override
    void init(boolean bl, String string, byte[] byArray, byte[] byArray2) throws InvalidKeyException {
        if (byArray == null || byArray2 != null) {
            throw new InvalidKeyException("Internal error");
        }
        this.embeddedCipher.init(bl, string, byArray);
    }

    private int implECBEncryptAzul(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int[] nArray) {
        return this.implECBEncrypt(byArray, n, n2, byArray2, n3);
    }

    private int implECBDecryptAzul(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int[] nArray) {
        return this.implECBDecrypt(byArray, n, n2, byArray2, n3);
    }

    private int implECBEncrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        for (int i = n2; i >= this.blockSize; i -= this.blockSize) {
            this.embeddedCipher.encryptBlock(byArray, n, byArray2, n3);
            n += this.blockSize;
            n3 += this.blockSize;
        }
        return n2;
    }

    private int implECBDecrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        for (int i = n2; i >= this.blockSize; i -= this.blockSize) {
            this.embeddedCipher.decryptBlock(byArray, n, byArray2, n3);
            n += this.blockSize;
            n3 += this.blockSize;
        }
        return n2;
    }

    @Override
    int encrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        RangeUtil.blockSizeCheck(n2, this.blockSize);
        RangeUtil.nullAndBoundsCheck(byArray, n, n2);
        RangeUtil.nullAndBoundsCheck(byArray2, n3, n2);
        if (this.embeddedCipher instanceof AESCrypt) {
            AESCrypt aESCrypt = (AESCrypt)this.embeddedCipher;
            return this.implECBEncryptAzul(byArray, n, n2, byArray2, n3, aESCrypt.getK());
        }
        return this.implECBEncrypt(byArray, n, n2, byArray2, n3);
    }

    @Override
    int decrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        RangeUtil.blockSizeCheck(n2, this.blockSize);
        RangeUtil.nullAndBoundsCheck(byArray, n, n2);
        RangeUtil.nullAndBoundsCheck(byArray2, n3, n2);
        if (this.embeddedCipher instanceof AESCrypt) {
            AESCrypt aESCrypt = (AESCrypt)this.embeddedCipher;
            return this.implECBDecryptAzul(byArray, n, n2, byArray2, n3, aESCrypt.getK());
        }
        return this.implECBDecrypt(byArray, n, n2, byArray2, n3);
    }
}

