/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec.ed;

import java.security.AccessController;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.ProviderException;
import java.util.Arrays;
import java.util.HashMap;
import sun.security.ec.ed.EdDSAKeyFactory;
import sun.security.ec.ed.EdDSAKeyPairGenerator;
import sun.security.ec.ed.EdDSASignature;
import sun.security.util.SecurityConstants;

public class OpenEdDSA
extends Provider {
    private static final long serialVersionUID = -2279741672933606418L;

    public OpenEdDSA() {
        super("OpenEdDSA", (Double)((Object)SecurityConstants.PROVIDER_VER), "Open EdDSA algorithm provider");
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                OpenEdDSA.this.putEdDSAEntries();
                return null;
            }
        });
    }

    private void putEdDSAEntries() {
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("ImplementedIn", "Software");
        this.putService(new ProviderService((Provider)this, "KeyFactory", "EdDSA", "org.openeddsa.sun.security.ec.ed.EdDSAKeyFactory", null, hashMap));
        this.putService(new ProviderService((Provider)this, "KeyFactory", "Ed25519", "org.openeddsa.sun.security.ec.ed.EdDSAKeyFactory.Ed25519", new String[]{"1.3.101.112", "OID.1.3.101.112"}, hashMap));
        this.putService(new ProviderService((Provider)this, "KeyFactory", "Ed448", "org.openeddsa.sun.security.ec.ed.EdDSAKeyFactory.Ed448", new String[]{"1.3.101.113", "OID.1.3.101.113"}, hashMap));
        this.putService(new ProviderService((Provider)this, "KeyPairGenerator", "EdDSA", "org.openeddsa.sun.security.ec.ed.EdDSAKeyPairGenerator", null, hashMap));
        this.putService(new ProviderService((Provider)this, "KeyPairGenerator", "Ed25519", "org.openeddsa.sun.security.ec.ed.EdDSAKeyPairGenerator.Ed25519", new String[]{"1.3.101.112", "OID.1.3.101.112"}, hashMap));
        this.putService(new ProviderService((Provider)this, "KeyPairGenerator", "Ed448", "org.openeddsa.sun.security.ec.ed.EdDSAKeyPairGenerator.Ed448", new String[]{"1.3.101.113", "OID.1.3.101.113"}, hashMap));
        this.putService(new ProviderService((Provider)this, "Signature", "EdDSA", "org.openeddsa.sun.security.ec.ed.EdDSASignature", null, hashMap));
        this.putService(new ProviderService((Provider)this, "Signature", "Ed25519", "org.openeddsa.sun.security.ec.ed.EdDSASignature.Ed25519", new String[]{"1.3.101.112", "OID.1.3.101.112"}, hashMap));
        this.putService(new ProviderService((Provider)this, "Signature", "Ed448", "org.openeddsa.sun.security.ec.ed.EdDSASignature.Ed448", new String[]{"1.3.101.113", "OID.1.3.101.113"}, hashMap));
    }

    private static class ProviderService
    extends Provider.Service {
        ProviderService(Provider provider, String string, String string2, String string3) {
            super(provider, string, string2, string3, null, null);
        }

        ProviderService(Provider provider, String string, String string2, String string3, String[] stringArray, HashMap<String, String> hashMap) {
            super(provider, string, string2, string3, stringArray == null ? null : Arrays.asList(stringArray), hashMap);
        }

        @Override
        public Object newInstance(Object object) throws NoSuchAlgorithmException {
            String string = this.getType();
            if (object != null) {
                throw new InvalidParameterException("constructorParameter not used with " + string + " engines");
            }
            String string2 = this.getAlgorithm();
            try {
                if (string.equals("Signature")) {
                    if (string2.equalsIgnoreCase("EdDSA")) {
                        return new EdDSASignature();
                    }
                    if (string2.equalsIgnoreCase("Ed25519")) {
                        return new EdDSASignature.Ed25519();
                    }
                    if (string2.equalsIgnoreCase("Ed448")) {
                        return new EdDSASignature.Ed448();
                    }
                } else if (string.equals("KeyFactory")) {
                    if (string2.equalsIgnoreCase("EdDSA")) {
                        return new EdDSAKeyFactory();
                    }
                    if (string2.equalsIgnoreCase("Ed25519")) {
                        return new EdDSAKeyFactory.Ed25519();
                    }
                    if (string2.equalsIgnoreCase("Ed448")) {
                        return new EdDSAKeyFactory.Ed448();
                    }
                } else if (string.equals("KeyPairGenerator")) {
                    if (string2.equalsIgnoreCase("EdDSA")) {
                        return new EdDSAKeyPairGenerator();
                    }
                    if (string2.equalsIgnoreCase("Ed25519")) {
                        return new EdDSAKeyPairGenerator.Ed25519();
                    }
                    if (string2.equalsIgnoreCase("Ed448")) {
                        return new EdDSAKeyPairGenerator.Ed448();
                    }
                }
            }
            catch (Exception exception) {
                throw new NoSuchAlgorithmException("Error constructing " + string + " for " + string2 + " using OpenEdDSA", exception);
            }
            throw new ProviderException("No impl for " + string2 + " " + string);
        }
    }
}

