/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec.ed;

import java.io.ByteArrayOutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.util.function.Function;
import org.openeddsa.java.security.interfaces.EdECPrivateKey;
import org.openeddsa.java.security.interfaces.EdECPublicKey;
import org.openeddsa.java.security.spec.EdDSAParameterSpec;
import org.openeddsa.java.security.spec.NamedParameterSpec;
import sun.security.ec.ed.EdDSAOperations;
import sun.security.ec.ed.EdDSAParameters;
import sun.security.ec.ed.EdDSAPublicKeyImpl;
import sun.security.ec.point.AffinePoint;

public class EdDSASignature
extends SignatureSpi {
    private byte[] privateKey;
    private AffinePoint publicKeyPoint;
    private byte[] publicKeyBytes;
    private EdDSAOperations ops;
    private EdDSAParameters lockedParams = null;
    private MessageAccumulator message = null;
    private EdDSAParameterSpec sigParams = new EdDSAParameterSpec(false);

    public EdDSASignature() {
    }

    EdDSASignature(NamedParameterSpec namedParameterSpec) {
        this.lockedParams = EdDSAParameters.get(ProviderException::new, (AlgorithmParameterSpec)namedParameterSpec);
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof EdECPublicKey)) {
            throw new InvalidKeyException("Unsupported key type");
        }
        EdECPublicKey edECPublicKey = (EdECPublicKey)publicKey;
        EdDSAParameters edDSAParameters = EdDSAParameters.get(InvalidKeyException::new, (AlgorithmParameterSpec)edECPublicKey.getParams());
        this.initImpl(edDSAParameters);
        this.privateKey = null;
        this.publicKeyPoint = this.ops.decodeAffinePoint(InvalidKeyException::new, edECPublicKey.getPoint());
        EdDSAPublicKeyImpl edDSAPublicKeyImpl = new EdDSAPublicKeyImpl(edDSAParameters, edECPublicKey.getPoint());
        this.publicKeyBytes = edDSAPublicKeyImpl.getEncodedPoint();
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.engineInitSign(privateKey, null);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        if (!(privateKey instanceof EdECPrivateKey)) {
            throw new InvalidKeyException("Unsupported key type");
        }
        EdECPrivateKey edECPrivateKey = (EdECPrivateKey)privateKey;
        this.initImpl(edECPrivateKey.getParams());
        this.privateKey = (byte[])edECPrivateKey.getBytes().orElseThrow(() -> new InvalidKeyException("No private key value"));
        this.publicKeyPoint = null;
        this.publicKeyBytes = null;
    }

    private <T extends Throwable> void checkLockedParams(Function<String, T> function, EdDSAParameters edDSAParameters) throws T {
        if (this.lockedParams != null && this.lockedParams != edDSAParameters) {
            throw (Throwable)function.apply("Parameters must be " + this.lockedParams.getName());
        }
    }

    private void ensureMessageInit() throws SignatureException {
        if (this.message == null) {
            this.initMessage();
        }
    }

    private void initMessage() throws SignatureException {
        if (this.ops == null) {
            throw new SignatureException("not initialized");
        }
        EdDSAParameters edDSAParameters = this.ops.getParameters();
        this.message = this.sigParams.isPrehash() ? new DigestAccumulator(edDSAParameters.createDigester(64)) : new MemoryAccumulator();
    }

    @Override
    protected void engineUpdate(byte by) throws SignatureException {
        this.ensureMessageInit();
        this.message.add(by);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.ensureMessageInit();
        this.message.add(byArray, n, n2);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        if (this.privateKey == null) {
            throw new SignatureException("Missing private key");
        }
        this.ensureMessageInit();
        byte[] byArray = this.ops.sign(this.sigParams, this.privateKey, this.message.getMessage());
        this.message = null;
        return byArray;
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        if (this.publicKeyBytes == null) {
            throw new SignatureException("Missing publicKey");
        }
        if (this.message == null) {
            return false;
        }
        boolean bl = this.ops.verify(this.sigParams, this.publicKeyPoint, this.publicKeyBytes, this.message.getMessage(), byArray);
        this.message = null;
        return bl;
    }

    private void initImpl(EdDSAParameters edDSAParameters) throws InvalidKeyException {
        this.checkLockedParams(InvalidKeyException::new, edDSAParameters);
        try {
            this.ops = new EdDSAOperations(edDSAParameters);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ProviderException(noSuchAlgorithmException);
        }
        this.message = null;
    }

    private void initImpl(NamedParameterSpec namedParameterSpec) throws InvalidKeyException {
        EdDSAParameters edDSAParameters = EdDSAParameters.get(InvalidKeyException::new, (AlgorithmParameterSpec)namedParameterSpec);
        this.initImpl(edDSAParameters);
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new UnsupportedOperationException("getParameter() not supported");
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new UnsupportedOperationException("setParameter() not supported");
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec == null) {
            return;
        }
        if (algorithmParameterSpec instanceof EdDSAParameterSpec) {
            if (this.message != null) {
                throw new InvalidParameterException("Cannot change signature parameters during operation");
            }
        } else {
            throw new InvalidAlgorithmParameterException("Only EdDSAParameterSpec supported");
        }
        EdDSAParameterSpec edDSAParameterSpec = (EdDSAParameterSpec)algorithmParameterSpec;
        EdDSASignature.checkContextLength(edDSAParameterSpec);
        this.sigParams = edDSAParameterSpec;
    }

    private static void checkContextLength(EdDSAParameterSpec edDSAParameterSpec) throws InvalidAlgorithmParameterException {
        byte[] byArray;
        if (edDSAParameterSpec.getContext().isPresent() && (byArray = (byte[])edDSAParameterSpec.getContext().get()).length > 255) {
            throw new InvalidAlgorithmParameterException("Context is longer than 255 bytes");
        }
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    public static class Ed448
    extends EdDSASignature {
        public Ed448() {
            super(NamedParameterSpec.ED448);
        }
    }

    public static class Ed25519
    extends EdDSASignature {
        public Ed25519() {
            super(NamedParameterSpec.ED25519);
        }
    }

    private static class MemoryAccumulator
    implements MessageAccumulator {
        ByteArrayOutputStream message = new ByteArrayOutputStream();

        private MemoryAccumulator() {
        }

        @Override
        public void add(byte by) {
            this.message.write(by);
        }

        @Override
        public void add(byte[] byArray, int n, int n2) {
            this.message.write(byArray, n, n2);
        }

        @Override
        public byte[] getMessage() {
            return this.message.toByteArray();
        }
    }

    private static class DigestAccumulator
    implements MessageAccumulator {
        private final EdDSAParameters.Digester digester;

        DigestAccumulator(EdDSAParameters.Digester digester) {
            this.digester = digester;
        }

        @Override
        public void add(byte by) {
            this.digester.update(by);
        }

        @Override
        public void add(byte[] byArray, int n, int n2) {
            this.digester.update(byArray, n, n2);
        }

        @Override
        public byte[] getMessage() {
            return this.digester.digest();
        }
    }

    private static interface MessageAccumulator {
        public void add(byte var1);

        public void add(byte[] var1, int var2, int var3);

        public byte[] getMessage();
    }
}

