/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec.ed;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyRep;
import java.util.Arrays;
import org.openeddsa.java.security.interfaces.EdECPublicKey;
import org.openeddsa.java.security.spec.EdECPoint;
import org.openeddsa.java.security.spec.NamedParameterSpec;
import sun.security.ec.ed.EdDSAParameters;
import sun.security.util.BitArray;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X509Key;

public final class EdDSAPublicKeyImpl
extends X509Key
implements EdECPublicKey {
    private static final long serialVersionUID = 1L;
    private final EdECPoint point;
    private final NamedParameterSpec paramSpec;

    public EdDSAPublicKeyImpl(EdDSAParameters edDSAParameters, EdECPoint edECPoint) throws InvalidKeyException {
        this.paramSpec = new NamedParameterSpec(edDSAParameters.getName());
        this.algid = new AlgorithmId(edDSAParameters.getOid());
        this.point = edECPoint;
        byte[] byArray = edECPoint.getY().toByteArray();
        EdDSAPublicKeyImpl.reverse(byArray);
        byArray = Arrays.copyOf(byArray, edDSAParameters.getKeyLength());
        byte by = (byte)(edECPoint.isXOdd() ? 128 : 0);
        int n = byArray.length - 1;
        byArray[n] = (byte)(byArray[n] | by);
        this.setKey(new BitArray(byArray.length * 8, byArray));
        this.checkLength(edDSAParameters);
    }

    public EdDSAPublicKeyImpl(byte[] byArray) throws InvalidKeyException {
        this.decode(byArray);
        EdDSAParameters edDSAParameters = EdDSAParameters.get(InvalidKeyException::new, this.algid);
        this.paramSpec = new NamedParameterSpec(edDSAParameters.getName());
        byte[] byArray2 = this.getKey().toByteArray();
        byte by = byArray2[byArray2.length - 1];
        int n = byArray2.length - 1;
        byArray2[n] = (byte)(byArray2[n] & 0x7F);
        boolean bl = (by & 0x80) != 0;
        EdDSAPublicKeyImpl.reverse(byArray2);
        BigInteger bigInteger = new BigInteger(1, byArray2);
        this.point = new EdECPoint(bl, bigInteger);
        this.checkLength(edDSAParameters);
    }

    void checkLength(EdDSAParameters edDSAParameters) throws InvalidKeyException {
        if (edDSAParameters.getKeyLength() * 8 != this.getKey().length()) {
            throw new InvalidKeyException("key length must be " + edDSAParameters.getKeyLength());
        }
    }

    public byte[] getEncodedPoint() {
        return this.getKey().toByteArray();
    }

    public EdECPoint getPoint() {
        return this.point;
    }

    public NamedParameterSpec getParams() {
        return this.paramSpec;
    }

    @Override
    public String getAlgorithm() {
        return "EdDSA";
    }

    private Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.PUBLIC, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    private static void swap(byte[] byArray, int n, int n2) {
        byte by = byArray[n];
        byArray[n] = byArray[n2];
        byArray[n2] = by;
    }

    private static void reverse(byte[] byArray) {
        int n = 0;
        for (int i = byArray.length - 1; n < i; ++n, --i) {
            EdDSAPublicKeyImpl.swap(byArray, n, i);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        throw new InvalidObjectException("EdDSAPublicKeyImpl keys are not directly deserializable");
    }
}

