/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec.ed;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.security.InvalidKeyException;
import java.security.ProviderException;
import java.util.Optional;
import org.openeddsa.java.security.interfaces.EdECPrivateKey;
import org.openeddsa.java.security.spec.NamedParameterSpec;
import sun.security.ec.ed.EdDSAParameters;
import sun.security.pkcs.PKCS8Key;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.x509.AlgorithmId;

public final class EdDSAPrivateKeyImpl
extends PKCS8Key
implements EdECPrivateKey {
    private static final long serialVersionUID = 1L;
    private final NamedParameterSpec paramSpec;
    private byte[] h;

    EdDSAPrivateKeyImpl(EdDSAParameters edDSAParameters, byte[] byArray) throws InvalidKeyException {
        this.paramSpec = new NamedParameterSpec(edDSAParameters.getName());
        this.algid = new AlgorithmId(edDSAParameters.getOid());
        this.h = (byte[])byArray.clone();
        this.encodeKey();
        this.checkLength(edDSAParameters);
    }

    EdDSAPrivateKeyImpl(byte[] byArray) throws InvalidKeyException {
        this.decode(byArray);
        EdDSAParameters edDSAParameters = EdDSAParameters.get(InvalidKeyException::new, this.algid);
        this.paramSpec = new NamedParameterSpec(edDSAParameters.getName());
        this.decodeKey();
        this.checkLength(edDSAParameters);
    }

    private void decodeKey() throws InvalidKeyException {
        try {
            DerInputStream derInputStream = new DerInputStream(this.key);
            this.h = derInputStream.getOctetString();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException);
        }
    }

    private void encodeKey() {
        DerOutputStream derOutputStream = new DerOutputStream();
        try {
            derOutputStream.putOctetString(this.h);
            this.key = derOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new ProviderException(iOException);
        }
    }

    void checkLength(EdDSAParameters edDSAParameters) throws InvalidKeyException {
        if (edDSAParameters.getKeyLength() != this.h.length) {
            throw new InvalidKeyException("key length is " + this.h.length + ", key length must be " + edDSAParameters.getKeyLength());
        }
    }

    public byte[] getKey() {
        return (byte[])this.h.clone();
    }

    @Override
    public String getAlgorithm() {
        return "EdDSA";
    }

    public NamedParameterSpec getParams() {
        return this.paramSpec;
    }

    public Optional<byte[]> getBytes() {
        return Optional.of(this.getKey());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        throw new InvalidObjectException("EdDSAPrivateKeyImpl keys are not directly deserializable");
    }
}

