/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec.ed;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.function.Function;
import org.openeddsa.java.security.spec.EdDSAParameterSpec;
import org.openeddsa.java.security.spec.NamedParameterSpec;
import sun.security.ec.ParametersMap;
import sun.security.ec.ed.Ed25519Operations;
import sun.security.ec.ed.Ed448Operations;
import sun.security.ec.ed.EdECOperations;
import sun.security.provider.SHAKE256;
import sun.security.util.ObjectIdentifier;
import sun.security.util.math.ImmutableIntegerModuloP;
import sun.security.util.math.IntegerFieldModuloP;
import sun.security.util.math.intpoly.Curve25519OrderField;
import sun.security.util.math.intpoly.Curve448OrderField;
import sun.security.util.math.intpoly.IntegerPolynomial;
import sun.security.util.math.intpoly.IntegerPolynomial25519;
import sun.security.util.math.intpoly.IntegerPolynomial448;
import sun.security.x509.AlgorithmId;

public class EdDSAParameters {
    static ParametersMap<EdDSAParameters> namedParams;
    private final String name;
    private final ObjectIdentifier oid;
    private final IntegerFieldModuloP field;
    private final IntegerFieldModuloP orderField;
    private final ImmutableIntegerModuloP d;
    private final EdECOperations edOperations;
    private final DigesterFactory digester;
    private final int keyLength;
    private final int bits;
    private final int logCofactor;
    private final Function<EdDSAParameterSpec, byte[]> dom;
    private static final String prefixStr25519 = "SigEd25519 no Ed25519 collisions";
    private static final String prefixStr448 = "SigEd448";

    public EdDSAParameters(String string, ObjectIdentifier objectIdentifier, IntegerFieldModuloP integerFieldModuloP, IntegerFieldModuloP integerFieldModuloP2, ImmutableIntegerModuloP immutableIntegerModuloP, EdECOperations edECOperations, DigesterFactory digesterFactory, Function<EdDSAParameterSpec, byte[]> function, int n, int n2, int n3) {
        this.oid = objectIdentifier;
        this.name = string;
        this.field = integerFieldModuloP;
        this.orderField = integerFieldModuloP2;
        this.d = immutableIntegerModuloP;
        this.edOperations = edECOperations;
        this.digester = digesterFactory;
        this.keyLength = n;
        this.bits = n2;
        this.logCofactor = n3;
        this.dom = function;
    }

    public String getName() {
        return this.name;
    }

    public ObjectIdentifier getOid() {
        return this.oid;
    }

    public IntegerFieldModuloP getField() {
        return this.field;
    }

    public IntegerFieldModuloP getOrderField() {
        return this.orderField;
    }

    public ImmutableIntegerModuloP getD() {
        return this.d;
    }

    public EdECOperations getEdOperations() {
        return this.edOperations;
    }

    public int getKeyLength() {
        return this.keyLength;
    }

    public int getBits() {
        return this.bits;
    }

    public int getLogCofactor() {
        return this.logCofactor;
    }

    public Digester createDigester() {
        return this.digester.createDigester();
    }

    public Digester createDigester(int n) {
        return this.digester.createDigester(n);
    }

    public byte[] digest(byte[] ... byArray) {
        return this.digester.digest(byArray);
    }

    public byte[] dom(EdDSAParameterSpec edDSAParameterSpec) {
        return this.dom.apply(edDSAParameterSpec);
    }

    static byte[] dom2(EdDSAParameterSpec edDSAParameterSpec) {
        if (!edDSAParameterSpec.isPrehash() && !edDSAParameterSpec.getContext().isPresent()) {
            return new byte[0];
        }
        return EdDSAParameters.domImpl(prefixStr25519, edDSAParameterSpec);
    }

    static byte[] dom4(EdDSAParameterSpec edDSAParameterSpec) {
        return EdDSAParameters.domImpl(prefixStr448, edDSAParameterSpec);
    }

    static byte[] domImpl(String string, EdDSAParameterSpec edDSAParameterSpec) {
        byte by;
        byte[] byArray = string.getBytes(StandardCharsets.US_ASCII);
        byte[] byArray2 = edDSAParameterSpec.getContext().orElse(new byte[0]);
        int n = byArray.length + 2 + byArray2.length;
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        byArray3[byArray.length] = by = (byte)(edDSAParameterSpec.isPrehash() ? 1 : 0);
        byArray3[byArray.length + 1] = (byte)byArray2.length;
        System.arraycopy(byArray2, 0, byArray3, byArray.length + 2, byArray2.length);
        return byArray3;
    }

    public static <T extends Throwable> EdDSAParameters getBySize(Function<String, T> function, int n) throws T {
        return namedParams.getBySize(function, n);
    }

    public static <T extends Throwable> EdDSAParameters get(Function<String, T> function, AlgorithmId algorithmId) throws T {
        return namedParams.get(function, algorithmId);
    }

    public static <T extends Throwable> EdDSAParameters get(Function<String, T> function, AlgorithmParameterSpec algorithmParameterSpec) throws T {
        return namedParams.get(function, algorithmParameterSpec);
    }

    static {
        EdDSAParameters edDSAParameters;
        DigesterFactory digesterFactory;
        int n;
        ObjectIdentifier objectIdentifier;
        String string;
        EdECOperations edECOperations;
        BigInteger bigInteger;
        BigInteger bigInteger2;
        ImmutableIntegerModuloP immutableIntegerModuloP;
        BigInteger bigInteger3;
        IntegerPolynomial integerPolynomial;
        IntegerPolynomial integerPolynomial2;
        namedParams = new ParametersMap();
        try {
            integerPolynomial2 = new IntegerPolynomial25519();
            integerPolynomial = new Curve25519OrderField();
            bigInteger3 = new BigInteger("37095705934669439343138083508754565189542113879843219016388785533085940283555");
            immutableIntegerModuloP = integerPolynomial2.getElement(bigInteger3);
            bigInteger2 = new BigInteger("15112221349535400772501151409588531511454012693041857206046113283949847762202");
            bigInteger = new BigInteger("46316835694926478169428394003475163141307993866256225615783033603165251855960");
            edECOperations = new Ed25519Operations(immutableIntegerModuloP, bigInteger2, bigInteger);
            string = NamedParameterSpec.ED25519.getName();
            objectIdentifier = new ObjectIdentifier("1.3.101.112");
            n = 255;
            digesterFactory = new SHA512DigesterFactory();
            edDSAParameters = new EdDSAParameters(string, objectIdentifier, integerPolynomial2, integerPolynomial, immutableIntegerModuloP, edECOperations, digesterFactory, EdDSAParameters::dom2, 32, n, 3);
            namedParams.put(string, objectIdentifier, n, edDSAParameters);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            integerPolynomial2 = new IntegerPolynomial448();
            integerPolynomial = new Curve448OrderField();
            bigInteger3 = integerPolynomial2.getSize().subtract(new BigInteger("39081"));
            immutableIntegerModuloP = integerPolynomial2.getElement(bigInteger3);
            bigInteger2 = new BigInteger("224580040295924300187604334099896036246789641632564134246125461686950415467406032909029192869357953282578032075146446173674602635247710");
            bigInteger = new BigInteger("298819210078481492676017930443930673437544040154080242095928241372331506189835876003536878655418784733982303233503462500531545062832660");
            edECOperations = new Ed448Operations(immutableIntegerModuloP, bigInteger2, bigInteger);
            string = NamedParameterSpec.ED448.getName();
            objectIdentifier = new ObjectIdentifier("1.3.101.113");
            n = 448;
            digesterFactory = new SHAKE256DigesterFactory();
            edDSAParameters = new EdDSAParameters(string, objectIdentifier, integerPolynomial2, integerPolynomial, immutableIntegerModuloP, edECOperations, digesterFactory, EdDSAParameters::dom4, 57, n, 2);
            namedParams.put(string, objectIdentifier, n, edDSAParameters);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        namedParams.fix();
    }

    private static class SHAKE256Digester
    implements Digester {
        SHAKE256 md;

        SHAKE256Digester(int n) {
            this.md = new SHAKE256(n);
        }

        @Override
        public void update(byte by) {
            this.md.update(by);
        }

        @Override
        public void update(byte[] byArray, int n, int n2) {
            this.md.update(byArray, n, n2);
        }

        @Override
        public byte[] digest() {
            return this.md.digest();
        }
    }

    private static class MessageDigester
    implements Digester {
        private final MessageDigest md;

        private MessageDigester(MessageDigest messageDigest) {
            this.md = messageDigest;
        }

        @Override
        public void update(byte by) {
            this.md.update(by);
        }

        @Override
        public void update(byte[] byArray, int n, int n2) {
            this.md.update(byArray, n, n2);
        }

        @Override
        public byte[] digest() {
            return this.md.digest();
        }
    }

    public static interface Digester {
        public void update(byte var1);

        public void update(byte[] var1, int var2, int var3);

        public byte[] digest();
    }

    private static class SHAKE256DigesterFactory
    implements DigesterFactory {
        private SHAKE256DigesterFactory() {
        }

        @Override
        public Digester createDigester() {
            return new SHAKE256Digester(114);
        }

        @Override
        public Digester createDigester(int n) {
            return new SHAKE256Digester(n);
        }
    }

    private static class SHA512DigesterFactory
    implements DigesterFactory {
        private SHA512DigesterFactory() {
        }

        @Override
        public Digester createDigester() {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-512");
                return new MessageDigester(messageDigest);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new ProviderException(noSuchAlgorithmException);
            }
        }
    }

    public static interface DigesterFactory {
        public Digester createDigester();

        default public Digester createDigester(int n) {
            return this.createDigester();
        }

        default public byte[] digest(byte[] ... byArray) {
            Digester digester = this.createDigester();
            for (byte[] byArray2 : byArray) {
                digester.update(byArray2, 0, byArray2.length);
            }
            return digester.digest();
        }
    }
}

