/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec.ed;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.function.Function;
import org.openeddsa.java.security.spec.EdDSAParameterSpec;
import org.openeddsa.java.security.spec.EdECPoint;
import sun.security.ec.ed.EdDSAParameters;
import sun.security.ec.ed.EdECOperations;
import sun.security.ec.point.AffinePoint;
import sun.security.ec.point.ImmutablePoint;
import sun.security.ec.point.MutablePoint;
import sun.security.ec.point.Point;
import sun.security.util.ArrayUtil;
import sun.security.util.math.ImmutableIntegerModuloP;
import sun.security.util.math.IntegerFieldModuloP;
import sun.security.util.math.MutableIntegerModuloP;

public class EdDSAOperations {
    private final EdDSAParameters params;

    public EdDSAOperations(EdDSAParameters edDSAParameters) throws NoSuchAlgorithmException {
        this.params = edDSAParameters;
    }

    public EdDSAParameters getParameters() {
        return this.params;
    }

    public byte[] generatePrivate(SecureRandom secureRandom) {
        byte[] byArray = new byte[this.params.getKeyLength()];
        secureRandom.nextBytes(byArray);
        return byArray;
    }

    public EdECPoint computePublic(byte[] byArray) {
        byte[] byArray2 = this.params.digest(new byte[][]{byArray});
        int n = byArray2.length / 2;
        byte[] byArray3 = Arrays.copyOf(byArray2, n);
        this.prune(byArray3);
        ImmutableIntegerModuloP immutableIntegerModuloP = this.params.getOrderField().getElement(byArray3);
        immutableIntegerModuloP.asByteArray(byArray3);
        Point point = this.params.getEdOperations().basePointMultiply(byArray3);
        return EdDSAOperations.asEdECPoint(point.asAffine());
    }

    private static EdECPoint asEdECPoint(AffinePoint affinePoint) {
        return new EdECPoint(affinePoint.getX().asBigInteger().testBit(0), affinePoint.getY().asBigInteger());
    }

    public byte[] sign(EdDSAParameterSpec edDSAParameterSpec, byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = this.params.digest(new byte[][]{byArray});
        int n = byArray3.length / 2;
        byte[] byArray4 = Arrays.copyOf(byArray3, n);
        this.prune(byArray4);
        ImmutableIntegerModuloP immutableIntegerModuloP = this.params.getOrderField().getElement(byArray4);
        immutableIntegerModuloP.asByteArray(byArray4);
        Point point = this.params.getEdOperations().basePointMultiply(byArray4);
        byte[] byArray5 = Arrays.copyOfRange(byArray3, byArray3.length / 2, byArray3.length);
        byte[] byArray6 = this.params.dom(edDSAParameterSpec);
        byte[] byArray7 = this.params.digest(byArray6, byArray5, byArray2);
        ImmutableIntegerModuloP immutableIntegerModuloP2 = this.params.getOrderField().getElement(byArray7);
        byArray7 = new byte[this.params.getKeyLength()];
        immutableIntegerModuloP2.asByteArray(byArray7);
        Point point2 = this.params.getEdOperations().basePointMultiply(byArray7);
        byte[] byArray8 = EdDSAOperations.encode(n, point2);
        byte[] byArray9 = EdDSAOperations.encode(n, point);
        byte[] byArray10 = this.params.digest(byArray6, byArray8, byArray9, byArray2);
        IntegerFieldModuloP integerFieldModuloP = this.params.getOrderField();
        ImmutableIntegerModuloP immutableIntegerModuloP3 = integerFieldModuloP.getElement(byArray10);
        ImmutableIntegerModuloP immutableIntegerModuloP4 = integerFieldModuloP.getElement(byArray7);
        MutableIntegerModuloP mutableIntegerModuloP = immutableIntegerModuloP3.mutable().setProduct(immutableIntegerModuloP);
        mutableIntegerModuloP.setSum(immutableIntegerModuloP4);
        mutableIntegerModuloP.setReduced();
        byte[] byArray11 = mutableIntegerModuloP.asByteArray(n);
        byte[] byArray12 = EdDSAOperations.encode(n, point2);
        byte[] byArray13 = new byte[n * 2];
        System.arraycopy(byArray12, 0, byArray13, 0, n);
        System.arraycopy(byArray11, 0, byArray13, n, n);
        return byArray13;
    }

    public boolean verify(EdDSAParameterSpec edDSAParameterSpec, AffinePoint affinePoint, byte[] byArray, byte[] byArray2, byte[] byArray3) throws SignatureException {
        if (byArray3 == null) {
            throw new SignatureException("signature was null");
        }
        byte[] byArray4 = Arrays.copyOf(byArray3, byArray3.length / 2);
        byte[] byArray5 = Arrays.copyOfRange(byArray3, byArray3.length / 2, byArray3.length);
        ArrayUtil.reverse(byArray5);
        BigInteger bigInteger = new BigInteger(1, byArray5);
        if (bigInteger.compareTo(this.params.getOrderField().getSize()) >= 0) {
            throw new SignatureException("s is too large");
        }
        ArrayUtil.reverse(byArray5);
        byte[] byArray6 = this.params.dom(edDSAParameterSpec);
        AffinePoint affinePoint2 = this.decodeAffinePoint(SignatureException::new, byArray4);
        byte[] byArray7 = this.params.digest(byArray6, byArray4, byArray, byArray2);
        IntegerFieldModuloP integerFieldModuloP = this.params.getOrderField();
        ImmutableIntegerModuloP immutableIntegerModuloP = integerFieldModuloP.getElement(byArray7);
        byArray7 = immutableIntegerModuloP.asByteArray(byArray7.length / 2);
        ImmutablePoint immutablePoint = this.params.getEdOperations().of(affinePoint2);
        ImmutablePoint immutablePoint2 = this.params.getEdOperations().of(affinePoint);
        EdECOperations edECOperations = this.params.getEdOperations();
        Point point = edECOperations.basePointMultiply(byArray5);
        MutablePoint mutablePoint = edECOperations.setSum(edECOperations.setProduct(immutablePoint2.mutable(), byArray7), immutablePoint.mutable());
        return point.affineEquals(mutablePoint);
    }

    public boolean verify(EdDSAParameterSpec edDSAParameterSpec, byte[] byArray, byte[] byArray2, byte[] byArray3) throws InvalidKeyException, SignatureException {
        AffinePoint affinePoint = this.decodeAffinePoint(InvalidKeyException::new, byArray);
        return this.verify(edDSAParameterSpec, affinePoint, byArray, byArray2, byArray3);
    }

    public <T extends Throwable> AffinePoint decodeAffinePoint(Function<String, T> function, byte[] byArray) throws T {
        if (byArray.length != this.params.getKeyLength()) {
            throw (Throwable)function.apply("incorrect length");
        }
        byArray = (byte[])byArray.clone();
        int n = (0xFF & byArray[byArray.length - 1]) >>> 7;
        int n2 = byArray.length - 1;
        byArray[n2] = (byte)(byArray[n2] & 0x7F);
        int n3 = this.params.getBits() + 7 >> 3;
        ImmutableIntegerModuloP immutableIntegerModuloP = this.params.getField().getElement(byArray, 0, n3, (byte)0);
        ArrayUtil.reverse(byArray);
        BigInteger bigInteger = new BigInteger(1, byArray);
        if (bigInteger.compareTo(this.params.getField().getSize()) >= 0) {
            throw (Throwable)function.apply("y value is too large");
        }
        return this.params.getEdOperations().decodeAffinePoint(function, n, immutableIntegerModuloP);
    }

    public <T extends Throwable> AffinePoint decodeAffinePoint(Function<String, T> function, EdECPoint edECPoint) throws T {
        if (edECPoint.getY().compareTo(this.params.getField().getSize()) >= 0) {
            throw (Throwable)function.apply("y value is too large");
        }
        int n = edECPoint.isXOdd() ? 1 : 0;
        ImmutableIntegerModuloP immutableIntegerModuloP = this.params.getField().getElement(edECPoint.getY());
        return this.params.getEdOperations().decodeAffinePoint(function, n, immutableIntegerModuloP);
    }

    private static int maskHighOrder(byte[] byArray, int n) {
        int n2 = byArray.length - 1;
        int n3 = byArray.length * 8 - n;
        int n4 = 8 - n3;
        byte by = (byte)((1 << n4) - 1);
        int n5 = n2;
        byArray[n5] = (byte)(byArray[n5] & by);
        return n4;
    }

    private static void prune(byte[] byArray, int n, int n2) {
        byte by;
        int n3 = byArray.length - 1;
        int n4 = EdDSAOperations.maskHighOrder(byArray, n);
        if (n4 == 0) {
            int n5 = n3 - 1;
            byArray[n5] = (byte)(byArray[n5] | 0x80);
        } else {
            by = (byte)(1 << n4 - 1);
            int n6 = n3;
            byArray[n6] = (byte)(byArray[n6] | by);
        }
        by = (byte)(255 << n2);
        byArray[0] = (byte)(byArray[0] & by);
    }

    void prune(byte[] byArray) {
        EdDSAOperations.prune(byArray, this.params.getBits(), this.params.getLogCofactor());
    }

    private static byte[] encode(int n, Point point) {
        return EdDSAOperations.encode(n, point.asAffine());
    }

    private static byte[] encode(int n, AffinePoint affinePoint) {
        byte[] byArray = affinePoint.getY().asByteArray(n);
        int n2 = affinePoint.getX().asByteArray(1)[0] & 1;
        int n3 = byArray.length - 1;
        byArray[n3] = (byte)(byArray[n3] | n2 << 7);
        return byArray;
    }
}

