/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec.ed;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import org.openeddsa.java.security.spec.EdECPoint;
import org.openeddsa.java.security.spec.NamedParameterSpec;
import sun.security.ec.ed.EdDSAOperations;
import sun.security.ec.ed.EdDSAParameters;
import sun.security.ec.ed.EdDSAPrivateKeyImpl;
import sun.security.ec.ed.EdDSAPublicKeyImpl;
import sun.security.util.SecurityProviderConstants;

public class EdDSAKeyPairGenerator
extends KeyPairGeneratorSpi {
    private SecureRandom random = null;
    private EdDSAOperations ops = null;
    private EdDSAParameters lockedParams = null;

    public EdDSAKeyPairGenerator() {
        this.initialize(SecurityProviderConstants.DEF_ED_KEY_SIZE, null);
    }

    private EdDSAKeyPairGenerator(NamedParameterSpec namedParameterSpec) {
        this.tryInitialize(namedParameterSpec);
        this.lockedParams = this.ops.getParameters();
    }

    private void tryInitialize(NamedParameterSpec namedParameterSpec) {
        try {
            this.initialize((AlgorithmParameterSpec)namedParameterSpec, null);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            String string = namedParameterSpec.getName();
            throw new ProviderException(string + " not supported");
        }
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        EdDSAParameters edDSAParameters = EdDSAParameters.getBySize(InvalidParameterException::new, n);
        this.initializeImpl(edDSAParameters, secureRandom);
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        EdDSAParameters edDSAParameters = EdDSAParameters.get(InvalidAlgorithmParameterException::new, algorithmParameterSpec);
        try {
            this.initializeImpl(edDSAParameters, secureRandom);
        }
        catch (InvalidParameterException invalidParameterException) {
            throw new InvalidAlgorithmParameterException(invalidParameterException);
        }
    }

    private void initializeImpl(EdDSAParameters edDSAParameters, SecureRandom secureRandom) {
        if (this.lockedParams != null && this.lockedParams != edDSAParameters) {
            throw new InvalidParameterException("Parameters must be " + this.lockedParams.getName());
        }
        try {
            this.ops = new EdDSAOperations(edDSAParameters);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ProviderException(noSuchAlgorithmException);
        }
        this.random = secureRandom == null ? CachedSecureRandomHolder.instance : secureRandom;
    }

    @Override
    public KeyPair generateKeyPair() {
        byte[] byArray = this.ops.generatePrivate(this.random);
        EdECPoint edECPoint = this.ops.computePublic(byArray);
        try {
            return new KeyPair(new EdDSAPublicKeyImpl(this.ops.getParameters(), edECPoint), new EdDSAPrivateKeyImpl(this.ops.getParameters(), byArray));
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new ProviderException(invalidKeyException);
        }
    }

    private static class CachedSecureRandomHolder {
        public static SecureRandom instance = new SecureRandom();

        private CachedSecureRandomHolder() {
        }
    }

    public static class Ed448
    extends EdDSAKeyPairGenerator {
        public Ed448() {
            super(NamedParameterSpec.ED448);
        }
    }

    public static class Ed25519
    extends EdDSAKeyPairGenerator {
        public Ed25519() {
            super(NamedParameterSpec.ED25519);
        }
    }
}

