/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec.ed;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.function.Function;
import org.openeddsa.java.security.interfaces.EdECKey;
import org.openeddsa.java.security.interfaces.EdECPrivateKey;
import org.openeddsa.java.security.interfaces.EdECPublicKey;
import org.openeddsa.java.security.spec.EdECPrivateKeySpec;
import org.openeddsa.java.security.spec.EdECPublicKeySpec;
import org.openeddsa.java.security.spec.NamedParameterSpec;
import sun.security.ec.ed.EdDSAParameters;
import sun.security.ec.ed.EdDSAPrivateKeyImpl;
import sun.security.ec.ed.EdDSAPublicKeyImpl;

public class EdDSAKeyFactory
extends KeyFactorySpi {
    private EdDSAParameters lockedParams = null;

    public EdDSAKeyFactory() {
    }

    protected EdDSAKeyFactory(NamedParameterSpec namedParameterSpec) {
        this.lockedParams = EdDSAParameters.get(ProviderException::new, (AlgorithmParameterSpec)namedParameterSpec);
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("Key must not be null");
        }
        if (key instanceof EdECKey) {
            EdECKey edECKey = (EdECKey)key;
            EdDSAParameters edDSAParameters = EdDSAParameters.get(InvalidKeyException::new, (AlgorithmParameterSpec)edECKey.getParams());
            this.checkLockedParams(InvalidKeyException::new, edDSAParameters);
            if (edECKey instanceof EdECPublicKey) {
                EdECPublicKey edECPublicKey = (EdECPublicKey)edECKey;
                return new EdDSAPublicKeyImpl(edDSAParameters, edECPublicKey.getPoint());
            }
            if (edECKey instanceof EdECPrivateKey) {
                EdECPrivateKey edECPrivateKey = (EdECPrivateKey)edECKey;
                byte[] byArray = (byte[])edECPrivateKey.getBytes().orElseThrow(() -> new InvalidKeyException("No private key data"));
                return new EdDSAPrivateKeyImpl(edDSAParameters, byArray);
            }
            throw new InvalidKeyException("Unsupported EdECKey subclass");
        }
        if (key instanceof PublicKey && key.getFormat().equals("X.509")) {
            EdDSAPublicKeyImpl edDSAPublicKeyImpl = new EdDSAPublicKeyImpl(key.getEncoded());
            this.checkLockedParams(InvalidKeyException::new, edDSAPublicKeyImpl.getParams());
            return edDSAPublicKeyImpl;
        }
        if (key instanceof PrivateKey && key.getFormat().equals("PKCS#8")) {
            EdDSAPrivateKeyImpl edDSAPrivateKeyImpl = new EdDSAPrivateKeyImpl(key.getEncoded());
            this.checkLockedParams(InvalidKeyException::new, edDSAPrivateKeyImpl.getParams());
            return edDSAPrivateKeyImpl;
        }
        throw new InvalidKeyException("Unsupported key type or format");
    }

    private <T extends Throwable> void checkLockedParams(Function<String, T> function, NamedParameterSpec namedParameterSpec) throws T {
        EdDSAParameters edDSAParameters = EdDSAParameters.get(function, (AlgorithmParameterSpec)namedParameterSpec);
        this.checkLockedParams(function, edDSAParameters);
    }

    private <T extends Throwable> void checkLockedParams(Function<String, T> function, EdDSAParameters edDSAParameters) throws T {
        if (this.lockedParams != null && this.lockedParams != edDSAParameters) {
            throw (Throwable)function.apply("Parameters must be " + this.lockedParams.getName());
        }
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            return this.generatePublicImpl(keySpec);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException(invalidKeyException);
        }
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            return this.generatePrivateImpl(keySpec);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException(invalidKeyException);
        }
    }

    private PublicKey generatePublicImpl(KeySpec keySpec) throws InvalidKeyException, InvalidKeySpecException {
        if (keySpec instanceof X509EncodedKeySpec) {
            X509EncodedKeySpec x509EncodedKeySpec = (X509EncodedKeySpec)keySpec;
            EdDSAPublicKeyImpl edDSAPublicKeyImpl = new EdDSAPublicKeyImpl(x509EncodedKeySpec.getEncoded());
            this.checkLockedParams(InvalidKeySpecException::new, edDSAPublicKeyImpl.getParams());
            return edDSAPublicKeyImpl;
        }
        if (keySpec instanceof EdECPublicKeySpec) {
            EdECPublicKeySpec edECPublicKeySpec = (EdECPublicKeySpec)keySpec;
            EdDSAParameters edDSAParameters = EdDSAParameters.get(InvalidKeySpecException::new, (AlgorithmParameterSpec)edECPublicKeySpec.getParams());
            this.checkLockedParams(InvalidKeySpecException::new, edDSAParameters);
            return new EdDSAPublicKeyImpl(edDSAParameters, edECPublicKeySpec.getPoint());
        }
        throw new InvalidKeySpecException("Only X509EncodedKeySpec and EdECPublicKeySpec are supported");
    }

    private PrivateKey generatePrivateImpl(KeySpec keySpec) throws InvalidKeyException, InvalidKeySpecException {
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = (PKCS8EncodedKeySpec)keySpec;
            EdDSAPrivateKeyImpl edDSAPrivateKeyImpl = new EdDSAPrivateKeyImpl(pKCS8EncodedKeySpec.getEncoded());
            this.checkLockedParams(InvalidKeySpecException::new, edDSAPrivateKeyImpl.getParams());
            return edDSAPrivateKeyImpl;
        }
        if (keySpec instanceof EdECPrivateKeySpec) {
            EdECPrivateKeySpec edECPrivateKeySpec = (EdECPrivateKeySpec)keySpec;
            EdDSAParameters edDSAParameters = EdDSAParameters.get(InvalidKeySpecException::new, (AlgorithmParameterSpec)edECPrivateKeySpec.getParams());
            this.checkLockedParams(InvalidKeySpecException::new, edDSAParameters);
            return new EdDSAPrivateKeyImpl(edDSAParameters, edECPrivateKeySpec.getBytes());
        }
        throw new InvalidKeySpecException("Only PKCS8EncodedKeySpec and EdECPrivateKeySpec supported");
    }

    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> clazz) throws InvalidKeySpecException {
        if (key instanceof EdECPublicKey) {
            this.checkLockedParams(InvalidKeySpecException::new, ((EdECPublicKey)key).getParams());
            if (X509EncodedKeySpec.class.isAssignableFrom(clazz)) {
                if (!key.getFormat().equals("X.509")) {
                    throw new InvalidKeySpecException("Format is not X.509");
                }
                return (T)((KeySpec)clazz.cast(new X509EncodedKeySpec(key.getEncoded())));
            }
            if (EdECPublicKeySpec.class.isAssignableFrom(clazz)) {
                EdECPublicKey edECPublicKey = (EdECPublicKey)key;
                return (T)((KeySpec)clazz.cast(new EdECPublicKeySpec(edECPublicKey.getParams(), edECPublicKey.getPoint())));
            }
            throw new InvalidKeySpecException("KeySpec must be X509EncodedKeySpec or EdECPublicKeySpec");
        }
        if (key instanceof EdECPrivateKey) {
            this.checkLockedParams(InvalidKeySpecException::new, ((EdECPrivateKey)key).getParams());
            if (PKCS8EncodedKeySpec.class.isAssignableFrom(clazz)) {
                if (!key.getFormat().equals("PKCS#8")) {
                    throw new InvalidKeySpecException("Format is not PKCS#8");
                }
                return (T)((KeySpec)clazz.cast(new PKCS8EncodedKeySpec(key.getEncoded())));
            }
            if (EdECPrivateKeySpec.class.isAssignableFrom(clazz)) {
                EdECPrivateKey edECPrivateKey = (EdECPrivateKey)key;
                byte[] byArray = (byte[])edECPrivateKey.getBytes().orElseThrow(() -> new InvalidKeySpecException("No private key value"));
                return (T)((KeySpec)clazz.cast(new EdECPrivateKeySpec(edECPrivateKey.getParams(), byArray)));
            }
            throw new InvalidKeySpecException("KeySpec must be PKCS8EncodedKeySpec or EdECPrivateKeySpec");
        }
        throw new InvalidKeySpecException("Unsupported key type");
    }

    public static class Ed448
    extends EdDSAKeyFactory {
        public Ed448() {
            super(NamedParameterSpec.ED448);
        }
    }

    public static class Ed25519
    extends EdDSAKeyFactory {
        public Ed25519() {
            super(NamedParameterSpec.ED25519);
        }
    }
}

