/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec.ed;

import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import org.openeddsa.java.security.spec.EdDSAParameterSpec;

public class EdDSAAlgorithmParameters
extends AlgorithmParametersSpi {
    EdDSAParameterSpec edspec;

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (algorithmParameterSpec instanceof EdDSAParameterSpec) {
            this.edspec = (EdDSAParameterSpec)algorithmParameterSpec;
            return;
        }
        throw new InvalidParameterSpecException("Unknown AlgorithmParameterSpec");
    }

    @Override
    protected void engineInit(byte[] byArray) throws IOException {
        throw new IOException("EdDSA does not support parameters as a byte array.");
    }

    @Override
    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> clazz) throws InvalidParameterSpecException {
        if (clazz.isAssignableFrom(ECParameterSpec.class)) {
            return (T)((AlgorithmParameterSpec)clazz.cast(this.edspec));
        }
        throw new InvalidParameterSpecException("Only EDDSAParameterSpec supported.");
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        throw new IOException("EdDSA does not support parameters as a byte array.");
    }

    @Override
    protected byte[] engineGetEncoded(String string) throws IOException {
        throw new IOException("EdDSA does not support parameters as a byte array.");
    }

    @Override
    protected String engineToString() {
        return this.edspec.toString();
    }
}

