/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec.ed;

import java.math.BigInteger;
import java.util.function.Function;
import sun.security.ec.ed.EdECOperations;
import sun.security.ec.point.AffinePoint;
import sun.security.ec.point.MutablePoint;
import sun.security.ec.point.Point;
import sun.security.ec.point.ProjectivePoint;
import sun.security.util.math.ImmutableIntegerModuloP;
import sun.security.util.math.IntegerFieldModuloP;
import sun.security.util.math.IntegerModuloP;
import sun.security.util.math.MutableIntegerModuloP;
import sun.security.util.math.SmallValue;

public class Ed448Operations
extends EdECOperations {
    private final SmallValue two;
    private final ImmutableIntegerModuloP d;
    private final ProjectivePoint.Immutable basePoint;
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private static final BigInteger THREE = BigInteger.valueOf(3L);
    private static final BigInteger FIVE = BigInteger.valueOf(5L);
    private final BigInteger sizeMinus3;

    public Ed448Operations(ImmutableIntegerModuloP immutableIntegerModuloP, BigInteger bigInteger, BigInteger bigInteger2) {
        this.two = immutableIntegerModuloP.getField().getSmallValue(2);
        this.d = immutableIntegerModuloP;
        this.basePoint = this.of(new AffinePoint(immutableIntegerModuloP.getField().getElement(bigInteger), immutableIntegerModuloP.getField().getElement(bigInteger2)));
        this.sizeMinus3 = immutableIntegerModuloP.getField().getSize().subtract(THREE);
    }

    @Override
    public Point basePointMultiply(byte[] byArray) {
        return this.setProduct(this.basePoint.mutable(), byArray);
    }

    @Override
    protected ProjectivePoint.Immutable getNeutral() {
        IntegerFieldModuloP integerFieldModuloP = this.d.getField();
        return new ProjectivePoint.Immutable(integerFieldModuloP.get0(), integerFieldModuloP.get1(), integerFieldModuloP.get1());
    }

    @Override
    protected MutablePoint setSum(MutablePoint mutablePoint, MutablePoint mutablePoint2, MutableIntegerModuloP mutableIntegerModuloP, MutableIntegerModuloP mutableIntegerModuloP2, MutableIntegerModuloP mutableIntegerModuloP3) {
        ProjectivePoint.Mutable mutable = (ProjectivePoint.Mutable)mutablePoint;
        ProjectivePoint.Mutable mutable2 = (ProjectivePoint.Mutable)mutablePoint2;
        return this.setSum(mutable, mutable2, mutableIntegerModuloP, mutableIntegerModuloP2, mutableIntegerModuloP3);
    }

    @Override
    protected MutablePoint setDouble(MutablePoint mutablePoint, MutableIntegerModuloP mutableIntegerModuloP, MutableIntegerModuloP mutableIntegerModuloP2) {
        ProjectivePoint.Mutable mutable = (ProjectivePoint.Mutable)mutablePoint;
        return this.setDouble(mutable, mutableIntegerModuloP, mutableIntegerModuloP2);
    }

    @Override
    public ProjectivePoint.Immutable of(AffinePoint affinePoint) {
        return new ProjectivePoint.Immutable(affinePoint.getX(), affinePoint.getY(), affinePoint.getX().getField().get1());
    }

    @Override
    public <T extends Throwable> AffinePoint decodeAffinePoint(Function<String, T> function, int n, IntegerModuloP integerModuloP) throws T {
        ImmutableIntegerModuloP immutableIntegerModuloP = integerModuloP.square();
        ImmutableIntegerModuloP immutableIntegerModuloP2 = immutableIntegerModuloP.subtract(this.d.getField().get1());
        MutableIntegerModuloP mutableIntegerModuloP = this.d.mutable().setProduct(immutableIntegerModuloP).setDifference(this.d.getField().get1());
        ImmutableIntegerModuloP immutableIntegerModuloP3 = immutableIntegerModuloP2.pow(FIVE).multiply(mutableIntegerModuloP.pow(THREE)).pow(this.sizeMinus3.shiftRight(2));
        MutableIntegerModuloP mutableIntegerModuloP2 = mutableIntegerModuloP.mutable().setProduct(immutableIntegerModuloP2.pow(THREE)).setProduct(immutableIntegerModuloP3);
        mutableIntegerModuloP.setProduct(mutableIntegerModuloP2).setProduct(mutableIntegerModuloP2);
        if (!mutableIntegerModuloP.asBigInteger().equals(immutableIntegerModuloP2.asBigInteger())) {
            throw (Throwable)function.apply("Invalid point");
        }
        if (mutableIntegerModuloP2.asBigInteger().equals(BigInteger.ZERO) && n == 1) {
            throw (Throwable)function.apply("Invalid point");
        }
        if (n != mutableIntegerModuloP2.asBigInteger().mod(TWO).intValue()) {
            mutableIntegerModuloP2.setAdditiveInverse();
        }
        return new AffinePoint(mutableIntegerModuloP2.fixed(), integerModuloP.fixed());
    }

    ProjectivePoint.Mutable setSum(ProjectivePoint.Mutable mutable, ProjectivePoint.Mutable mutable2, MutableIntegerModuloP mutableIntegerModuloP, MutableIntegerModuloP mutableIntegerModuloP2, MutableIntegerModuloP mutableIntegerModuloP3) {
        mutableIntegerModuloP.setValue((IntegerModuloP)mutable.getX()).setProduct((IntegerModuloP)mutable2.getX());
        mutableIntegerModuloP2.setValue((IntegerModuloP)mutable2.getX()).setSum((IntegerModuloP)mutable2.getY());
        ((MutableIntegerModuloP)mutable.getX()).setSum((IntegerModuloP)mutable.getY()).setProduct(mutableIntegerModuloP2);
        ((MutableIntegerModuloP)mutable.getZ()).setProduct((IntegerModuloP)mutable2.getZ());
        ((MutableIntegerModuloP)mutable.getY()).setProduct((IntegerModuloP)mutable2.getY());
        mutableIntegerModuloP3.setValue(this.d).setProduct(mutableIntegerModuloP).setProduct((IntegerModuloP)mutable.getY());
        ((MutableIntegerModuloP)mutable.getX()).setDifference(mutableIntegerModuloP).setReduced().setDifference((IntegerModuloP)mutable.getY());
        ((MutableIntegerModuloP)mutable.getY()).setDifference(mutableIntegerModuloP);
        mutableIntegerModuloP.setValue((IntegerModuloP)mutable.getZ()).setSquare();
        mutableIntegerModuloP2.setValue(mutableIntegerModuloP).setDifference(mutableIntegerModuloP3);
        mutableIntegerModuloP.setSum(mutableIntegerModuloP3);
        ((MutableIntegerModuloP)mutable.getX()).setProduct(mutableIntegerModuloP2).setProduct((IntegerModuloP)mutable.getZ());
        ((MutableIntegerModuloP)mutable.getY()).setProduct(mutableIntegerModuloP).setProduct((IntegerModuloP)mutable.getZ());
        ((MutableIntegerModuloP)mutable.getZ()).setValue(mutableIntegerModuloP2.multiply(mutableIntegerModuloP));
        return mutable;
    }

    protected ProjectivePoint.Mutable setDouble(ProjectivePoint.Mutable mutable, MutableIntegerModuloP mutableIntegerModuloP, MutableIntegerModuloP mutableIntegerModuloP2) {
        mutableIntegerModuloP2.setValue((IntegerModuloP)mutable.getX()).setSquare();
        ((MutableIntegerModuloP)mutable.getX()).setSum((IntegerModuloP)mutable.getY()).setSquare();
        ((MutableIntegerModuloP)mutable.getY()).setSquare();
        ((MutableIntegerModuloP)mutable.getZ()).setSquare();
        mutableIntegerModuloP.setValue(mutableIntegerModuloP2).setSum((IntegerModuloP)mutable.getY()).setReduced();
        mutableIntegerModuloP2.setDifference((IntegerModuloP)mutable.getY());
        ((MutableIntegerModuloP)mutable.getY()).setValue(mutableIntegerModuloP).setProduct(mutableIntegerModuloP2);
        ((MutableIntegerModuloP)mutable.getZ()).setProduct(this.two);
        ((MutableIntegerModuloP)mutable.getZ()).setAdditiveInverse().setSum(mutableIntegerModuloP);
        ((MutableIntegerModuloP)mutable.getX()).setDifference(mutableIntegerModuloP).setProduct((IntegerModuloP)mutable.getZ());
        ((MutableIntegerModuloP)mutable.getZ()).setProduct(mutableIntegerModuloP);
        return mutable;
    }
}

