/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec.ed;

import java.math.BigInteger;
import java.util.function.Function;
import sun.security.ec.ed.EdECOperations;
import sun.security.ec.point.AffinePoint;
import sun.security.ec.point.ExtendedHomogeneousPoint;
import sun.security.ec.point.MutablePoint;
import sun.security.ec.point.Point;
import sun.security.util.math.ImmutableIntegerModuloP;
import sun.security.util.math.IntegerFieldModuloP;
import sun.security.util.math.IntegerModuloP;
import sun.security.util.math.MutableIntegerModuloP;
import sun.security.util.math.SmallValue;

public class Ed25519Operations
extends EdECOperations {
    private final SmallValue two;
    private final ImmutableIntegerModuloP d;
    private final ExtendedHomogeneousPoint.Immutable basePoint;
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private static final BigInteger SEVEN = BigInteger.valueOf(7L);
    private final BigInteger sizeMinus5;

    public Ed25519Operations(ImmutableIntegerModuloP immutableIntegerModuloP, BigInteger bigInteger, BigInteger bigInteger2) {
        this.two = immutableIntegerModuloP.getField().getSmallValue(2);
        this.d = immutableIntegerModuloP;
        this.basePoint = this.of(new AffinePoint(immutableIntegerModuloP.getField().getElement(bigInteger), immutableIntegerModuloP.getField().getElement(bigInteger2)));
        this.sizeMinus5 = immutableIntegerModuloP.getField().getSize().subtract(BigInteger.valueOf(5L));
    }

    @Override
    public Point basePointMultiply(byte[] byArray) {
        return this.setProduct(this.basePoint.mutable(), byArray);
    }

    @Override
    protected ExtendedHomogeneousPoint.Immutable getNeutral() {
        IntegerFieldModuloP integerFieldModuloP = this.d.getField();
        return new ExtendedHomogeneousPoint.Immutable(integerFieldModuloP.get0(), integerFieldModuloP.get1(), integerFieldModuloP.get0(), integerFieldModuloP.get1());
    }

    @Override
    protected MutablePoint setSum(MutablePoint mutablePoint, MutablePoint mutablePoint2, MutableIntegerModuloP mutableIntegerModuloP, MutableIntegerModuloP mutableIntegerModuloP2, MutableIntegerModuloP mutableIntegerModuloP3) {
        ExtendedHomogeneousPoint.Mutable mutable = (ExtendedHomogeneousPoint.Mutable)mutablePoint;
        ExtendedHomogeneousPoint.Mutable mutable2 = (ExtendedHomogeneousPoint.Mutable)mutablePoint2;
        return this.setSum(mutable, mutable2, mutableIntegerModuloP, mutableIntegerModuloP2, mutableIntegerModuloP3);
    }

    @Override
    protected MutablePoint setDouble(MutablePoint mutablePoint, MutableIntegerModuloP mutableIntegerModuloP, MutableIntegerModuloP mutableIntegerModuloP2) {
        ExtendedHomogeneousPoint.Mutable mutable = (ExtendedHomogeneousPoint.Mutable)mutablePoint;
        return this.setDouble(mutable, mutableIntegerModuloP, mutableIntegerModuloP2);
    }

    @Override
    public ExtendedHomogeneousPoint.Immutable of(AffinePoint affinePoint) {
        return new ExtendedHomogeneousPoint.Immutable(affinePoint.getX(), affinePoint.getY(), affinePoint.getX().multiply(affinePoint.getY()), affinePoint.getX().getField().get1());
    }

    @Override
    public <T extends Throwable> AffinePoint decodeAffinePoint(Function<String, T> function, int n, IntegerModuloP integerModuloP) throws T {
        IntegerFieldModuloP integerFieldModuloP = this.d.getField();
        BigInteger bigInteger = integerFieldModuloP.getSize();
        ImmutableIntegerModuloP immutableIntegerModuloP = integerModuloP.square();
        ImmutableIntegerModuloP immutableIntegerModuloP2 = immutableIntegerModuloP.subtract(integerFieldModuloP.get1());
        MutableIntegerModuloP mutableIntegerModuloP = this.d.mutable().setProduct(immutableIntegerModuloP).setSum(integerFieldModuloP.get1());
        MutableIntegerModuloP mutableIntegerModuloP2 = immutableIntegerModuloP2.mutable().setProduct(mutableIntegerModuloP.pow(BigInteger.valueOf(3L)));
        ImmutableIntegerModuloP immutableIntegerModuloP3 = immutableIntegerModuloP2.multiply(mutableIntegerModuloP.pow(SEVEN)).pow(this.sizeMinus5.shiftRight(3));
        mutableIntegerModuloP2.setProduct(immutableIntegerModuloP3);
        mutableIntegerModuloP.setProduct(mutableIntegerModuloP2).setProduct(mutableIntegerModuloP2);
        BigInteger bigInteger2 = mutableIntegerModuloP.asBigInteger();
        if (!bigInteger2.equals(immutableIntegerModuloP2.asBigInteger())) {
            if (bigInteger2.equals(immutableIntegerModuloP2.additiveInverse().asBigInteger())) {
                BigInteger bigInteger3 = bigInteger.subtract(BigInteger.ONE).shiftRight(2);
                ImmutableIntegerModuloP immutableIntegerModuloP4 = integerFieldModuloP.getElement(TWO.modPow(bigInteger3, bigInteger));
                mutableIntegerModuloP2.setProduct(immutableIntegerModuloP4);
            } else {
                throw (Throwable)function.apply("Invalid point");
            }
        }
        if (mutableIntegerModuloP2.asBigInteger().equals(BigInteger.ZERO) && n == 1) {
            throw (Throwable)function.apply("Invalid point");
        }
        if (n != mutableIntegerModuloP2.asBigInteger().mod(BigInteger.valueOf(2L)).intValue()) {
            mutableIntegerModuloP2.setAdditiveInverse();
        }
        return new AffinePoint(mutableIntegerModuloP2.fixed(), integerModuloP.fixed());
    }

    ExtendedHomogeneousPoint.Mutable setSum(ExtendedHomogeneousPoint.Mutable mutable, ExtendedHomogeneousPoint.Mutable mutable2, MutableIntegerModuloP mutableIntegerModuloP, MutableIntegerModuloP mutableIntegerModuloP2, MutableIntegerModuloP mutableIntegerModuloP3) {
        mutableIntegerModuloP.setValue((IntegerModuloP)mutable2.getY()).setDifference((IntegerModuloP)mutable2.getX());
        mutableIntegerModuloP2.setValue((IntegerModuloP)mutable.getY()).setDifference((IntegerModuloP)mutable.getX()).setProduct(mutableIntegerModuloP);
        mutableIntegerModuloP.setValue((IntegerModuloP)mutable2.getY()).setSum((IntegerModuloP)mutable2.getX());
        mutableIntegerModuloP3.setValue((IntegerModuloP)mutable.getY()).setSum((IntegerModuloP)mutable.getX()).setProduct(mutableIntegerModuloP);
        ((MutableIntegerModuloP)mutable.getX()).setValue(mutableIntegerModuloP3).setDifference(mutableIntegerModuloP2);
        mutableIntegerModuloP3.setSum(mutableIntegerModuloP2);
        mutableIntegerModuloP2.setValue(this.d).setSum(this.d).setProduct((IntegerModuloP)mutable.getT()).setProduct((IntegerModuloP)mutable2.getT());
        mutableIntegerModuloP.setValue((IntegerModuloP)mutable.getZ()).setProduct((IntegerModuloP)mutable2.getZ()).setProduct(this.two);
        ((MutableIntegerModuloP)mutable.getY()).setValue(mutableIntegerModuloP).setSum(mutableIntegerModuloP2);
        ((MutableIntegerModuloP)mutable.getZ()).setValue(mutableIntegerModuloP).setDifference(mutableIntegerModuloP2);
        ((MutableIntegerModuloP)mutable.getT()).setValue((IntegerModuloP)mutable.getX()).setProduct(mutableIntegerModuloP3);
        ((MutableIntegerModuloP)mutable.getX()).setProduct((IntegerModuloP)mutable.getZ());
        ((MutableIntegerModuloP)mutable.getZ()).setProduct((IntegerModuloP)mutable.getY());
        ((MutableIntegerModuloP)mutable.getY()).setProduct(mutableIntegerModuloP3);
        return mutable;
    }

    protected ExtendedHomogeneousPoint.Mutable setDouble(ExtendedHomogeneousPoint.Mutable mutable, MutableIntegerModuloP mutableIntegerModuloP, MutableIntegerModuloP mutableIntegerModuloP2) {
        mutableIntegerModuloP.setValue((IntegerModuloP)mutable.getX()).setSum((IntegerModuloP)mutable.getY()).setSquare();
        ((MutableIntegerModuloP)mutable.getX()).setSquare();
        ((MutableIntegerModuloP)mutable.getY()).setSquare();
        mutableIntegerModuloP2.setValue((IntegerModuloP)mutable.getX()).setSum((IntegerModuloP)mutable.getY()).setReduced();
        ((MutableIntegerModuloP)mutable.getZ()).setSquare().setProduct(this.two);
        ((MutableIntegerModuloP)mutable.getT()).setValue(mutableIntegerModuloP2).setDifference(mutableIntegerModuloP);
        mutableIntegerModuloP.setValue((IntegerModuloP)mutable.getX()).setDifference((IntegerModuloP)mutable.getY()).setReduced();
        ((MutableIntegerModuloP)mutable.getZ()).setSum(mutableIntegerModuloP);
        ((MutableIntegerModuloP)mutable.getX()).setValue((IntegerModuloP)mutable.getT()).setProduct((IntegerModuloP)mutable.getZ());
        ((MutableIntegerModuloP)mutable.getY()).setValue(mutableIntegerModuloP).setProduct(mutableIntegerModuloP2);
        ((MutableIntegerModuloP)mutable.getT()).setProduct(mutableIntegerModuloP2);
        ((MutableIntegerModuloP)mutable.getZ()).setProduct(mutableIntegerModuloP);
        return mutable;
    }
}

